/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.mixin;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.GravesMod;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.event.PlayerGraveCreationEvent;
import eu.pb4.graves.event.PlayerGraveItemAddedEvent;
import eu.pb4.graves.event.PlayerGraveItemsEvent;
import eu.pb4.graves.grave.GraveBlock;
import eu.pb4.graves.grave.GraveBlockEntity;
import eu.pb4.graves.grave.GravesXPCalculation;
import eu.pb4.graves.other.GraveUtils;
import eu.pb4.placeholders.PlaceholderAPI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Unique
    private boolean graves_commandKill = false;

    @Inject(method={"kill"}, at={@At(value="HEAD")})
    private void graves_onKill(CallbackInfo ci) {
        this.graves_commandKill = true;
    }

    @Inject(method={"drop"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;dropInventory()V", shift=At.Shift.BEFORE)}, cancellable=true)
    private void replaceWithGrave(class_1282 source, CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_3222) {
            class_3222 player = (class_3222)livingEntityMixin;
            try {
                Config config = ConfigManager.getConfig();
                if (player.method_14220().method_8450().method_8355(class_1928.field_19389) || config.blacklistedWorlds.contains(player.method_14220().method_27983().method_29177())) {
                    return;
                }
                class_2561 text = null;
                Map<String, class_2561> placeholders = Map.of("position", new class_2585(player.method_24515().method_23854()), "world", GraveUtils.toWorldName(player.method_14220().method_27983().method_29177()));
                if (!config.configData.createFromPvP && source.method_5529() instanceof class_1657) {
                    text = config.creationFailedPvPMessage;
                } else if (config.configData.createFromCommandDeaths || !this.graves_commandKill) {
                    if (!config.configData.createFromVoid && source == class_1282.field_5849 && !this.graves_commandKill) {
                        text = config.creationFailedPvPMessage;
                    } else {
                        PlayerGraveCreationEvent.CreationResult eventResult = ((PlayerGraveCreationEvent)PlayerGraveCreationEvent.EVENT.invoker()).shouldCreate(player);
                        if (eventResult.canCreate()) {
                            GraveUtils.BlockCheckResult result = GraveUtils.findGravePosition(player, player.method_14220(), player.method_24515(), config.configData.maxPlacementDistance, config.configData.replaceAnyBlock);
                            if (result.result().canCreate()) {
                                int i;
                                class_2338 gravePos = result.pos();
                                ArrayList<class_1799> items = new ArrayList<class_1799>();
                                for (i = 0; i < player.method_31548().method_5439(); ++i) {
                                    class_1799 itemStack = player.method_31548().method_5438(i);
                                    if (itemStack.method_7960() || ((PlayerGraveItemAddedEvent)PlayerGraveItemAddedEvent.EVENT.invoker()).canAddItem(player, itemStack) == class_1269.field_5814 || GraveUtils.hasSkippedEnchantment(itemStack) || class_1890.method_8221((class_1799)itemStack)) continue;
                                    items.add(player.method_31548().method_5441(i));
                                }
                                ((PlayerGraveItemsEvent)PlayerGraveItemsEvent.EVENT.invoker()).modifyItems(player, items);
                                i = 0;
                                if (config.xpCalc != GravesXPCalculation.DROP) {
                                    i = config.xpCalc.converter.calc(player);
                                }
                                if (items.size() == 0 && i == 0) {
                                    return;
                                }
                                if (config.xpCalc != GravesXPCalculation.DROP) {
                                    player.field_7520 = 0;
                                }
                                int finalI = i;
                                class_3218 world = player.method_14220();
                                GameProfile gameProfile = player.method_7334();
                                HashSet<UUID> allowedUUID = new HashSet<UUID>();
                                if (config.configData.allowAttackersToTakeItems) {
                                    class_3222 playerEntity;
                                    class_1297 class_12972 = source.method_5529();
                                    if (class_12972 instanceof class_3222) {
                                        playerEntity = (class_3222)class_12972;
                                        allowedUUID.add(playerEntity.method_5667());
                                    }
                                    if ((class_12972 = player.method_6065()) instanceof class_3222) {
                                        playerEntity = (class_3222)class_12972;
                                        allowedUUID.add(playerEntity.method_5667());
                                    }
                                }
                                GravesMod.DO_ON_NEXT_TICK.add(() -> {
                                    class_2561 text2 = null;
                                    Map<String, class_2561> placeholders2 = placeholders;
                                    class_2680 oldBlockState = world.method_8320(gravePos);
                                    world.method_8501(gravePos, (class_2680)GraveBlock.INSTANCE.method_9564().method_11657((class_2769)class_2741.field_12532, (Comparable)Integer.valueOf(player.method_6051().nextInt(15))));
                                    class_2586 entity = world.method_8321(gravePos);
                                    if (entity instanceof GraveBlockEntity) {
                                        GraveBlockEntity grave = (GraveBlockEntity)entity;
                                        grave.setGrave(gameProfile, items, finalI, source.method_5506((class_1309)player), oldBlockState, allowedUUID);
                                        text2 = config.createdGraveMessage;
                                        placeholders2 = grave.info.getPlaceholders(player.method_5682());
                                    } else {
                                        if (config.xpCalc != GravesXPCalculation.DROP) {
                                            class_1303.method_31493((class_3218)world, (class_243)class_243.method_24953((class_2382)gravePos), (int)finalI);
                                        }
                                        text2 = config.creationFailedGraveMessage;
                                        class_1264.method_17349((class_1937)world, (class_2338)gravePos, (class_2371)class_2371.method_10212((Object)class_1799.field_8037, (Object[])items.toArray(new class_1799[0])));
                                    }
                                    if (text2 != null) {
                                        player.method_14254(PlaceholderAPI.parsePredefinedText((class_2561)text2, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, placeholders2), class_2556.field_11735, class_156.field_25140);
                                    }
                                });
                            } else {
                                text = switch (result.result()) {
                                    default -> throw new IncompatibleClassChangeError();
                                    case GraveUtils.BlockResult.BLOCK -> config.creationFailedGraveMessage;
                                    case GraveUtils.BlockResult.BLOCK_CLAIM -> config.creationFailedClaimMessage;
                                    case GraveUtils.BlockResult.ALLOW -> null;
                                };
                            }
                        } else {
                            switch (eventResult) {
                                case BLOCK: {
                                    class_2561 class_25612 = config.creationFailedGraveMessage;
                                    break;
                                }
                                case BLOCK_CLAIM: {
                                    class_2561 class_25612 = config.creationFailedClaimMessage;
                                    break;
                                }
                                case BLOCK_PVP: {
                                    class_2561 class_25612 = config.creationFailedPvPMessage;
                                    break;
                                }
                                case BLOCK_VOID: {
                                    class_2561 class_25612 = config.creationFailedVoidMessage;
                                    break;
                                }
                                default: {
                                    class_2561 class_25612 = text = null;
                                }
                            }
                        }
                    }
                }
                if (text != null) {
                    player.method_14254(PlaceholderAPI.parsePredefinedText((class_2561)text, (Pattern)PlaceholderAPI.PREDEFINED_PLACEHOLDER_PATTERN, placeholders), class_2556.field_11735, class_156.field_25140);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

