/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.other;

import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.event.GraveValidPosCheckEvent;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class GraveUtils {
    public static final class_2960 REPLACEABLE_ID = new class_2960("universal_graves", "replaceable");
    public static final class_3494<class_2248> REPLACEABLE_TAG = TagFactory.BLOCK.create(REPLACEABLE_ID);
    private static final Function<Map.Entry<class_2769<?>, Comparable<?>>, String> PROPERTY_MAP_PRINTER = new Function<Map.Entry<class_2769<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<class_2769<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            class_2769<?> property = entry.getKey();
            return property.method_11899() + "=" + this.nameValue(property, entry.getValue());
        }

        private <T extends Comparable<T>> String nameValue(class_2769<T> property, Comparable<?> value) {
            return property.method_11901(value);
        }
    };

    public static BlockCheckResult findGravePosition(class_3222 player, class_3218 world, class_2338 blockPos, int maxDistance, boolean anyBlock) {
        class_2784 border = world.method_8621();
        blockPos = new class_2338(class_3532.method_15350((double)blockPos.method_10263(), (double)(border.method_11976() + 1.0), (double)(border.method_11963() - 1.0)), (double)class_3532.method_15340((int)blockPos.method_10264(), (int)world.method_31607(), (int)(world.method_31600() - 1)), class_3532.method_15350((double)blockPos.method_10260(), (double)(border.method_11958() + 1.0), (double)(border.method_11977() - 1.0)));
        BlockResult result = GraveUtils.isValidPos(player, world, border, blockPos, false);
        if (result.allow) {
            return new BlockCheckResult(blockPos, result);
        }
        BlockCheckResult checkResult = GraveUtils.findPos(player, world, blockPos, maxDistance, false);
        if (!checkResult.result.allow && anyBlock) {
            checkResult = GraveUtils.findPos(player, world, blockPos, maxDistance, true);
        }
        return checkResult;
    }

    private static BlockCheckResult findPos(class_3222 player, class_3218 world, class_2338 blockPos, int maxDistance, boolean allowAnyBlock) {
        class_2784 border = world.method_8621();
        BlockResult result = GraveUtils.isValidPos(player, world, border, blockPos, allowAnyBlock);
        class_2338.class_2339 pos = new class_2338.class_2339(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        for (int line = 1; line <= maxDistance; ++line) {
            int side = line * 2 + 1;
            for (int oY = 0; oY < side; ++oY) {
                for (int oX = 0; oX < side; ++oX) {
                    for (int oZ = 0; oZ < side; ++oZ) {
                        pos.method_10103(blockPos.method_10263() - line + oX, blockPos.method_10264() - line + oY, blockPos.method_10260() - line + oZ);
                        if (oX > 0 && oX < side - 1 && oY > 0 && oY < side - 1 && oZ > 0 && oZ < side - 1) continue;
                        BlockResult tempResult = GraveUtils.isValidPos(player, world, border, (class_2338)pos, allowAnyBlock);
                        if (tempResult.priority >= result.priority) {
                            result = tempResult;
                        }
                        if (!result.canCreate()) continue;
                        return new BlockCheckResult(pos.method_10062(), result);
                    }
                }
            }
        }
        return new BlockCheckResult(null, result);
    }

    private static BlockResult isValidPos(class_3222 player, class_3218 world, class_2784 border, class_2338 pos, boolean anyBlock) {
        class_2680 state = world.method_8320(pos);
        if (border.method_11952(pos) && pos.method_10264() >= world.method_31607() && pos.method_10264() < world.method_31600() && !state.method_31709() && (state.method_26215() || anyBlock || REPLACEABLE_TAG.method_15141((Object)state.method_26204()))) {
            return ((GraveValidPosCheckEvent)GraveValidPosCheckEvent.EVENT.invoker()).isValid(player, world, pos);
        }
        return BlockResult.BLOCK;
    }

    public static String blockStateToString(class_2680 state) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(class_2378.field_11146.method_10221((Object)state.method_26204()));
        if (!state.method_11656().isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(state.method_11656().entrySet().stream().map(PROPERTY_MAP_PRINTER).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public static class_2561 toWorldName(class_2960 identifier) {
        String[] words;
        class_2561 override = ConfigManager.getConfig().worldNameOverrides.get(identifier);
        if (override != null) {
            return override;
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (String word : words = identifier.method_12832().split("_")) {
            CharSequence[] s = word.split("", 2);
            s[0] = s[0].toUpperCase(Locale.ROOT);
            parts.add(String.join((CharSequence)"", s));
        }
        return new class_2585(String.join((CharSequence)" ", parts));
    }

    public static boolean hasSkippedEnchantment(class_1799 stack) {
        Config config = ConfigManager.getConfig();
        for (class_2520 enchant : stack.method_7921()) {
            class_2487 compound;
            class_2960 key;
            if (!(enchant instanceof class_2487) || ((key = class_1890.method_37427((class_2487)(compound = (class_2487)enchant))) == null || !config.skippedEnchantments.contains(key)) && (!config.configData.tryDetectionSoulbound || !key.method_12832().contains("soulbound") && !key.method_12832().contains("soul_bound"))) continue;
            return true;
        }
        return false;
    }

    public static enum BlockResult {
        ALLOW(true, 2),
        BLOCK(false, 0),
        BLOCK_CLAIM(false, 1);

        private final boolean allow;
        private final int priority;

        private BlockResult(boolean allow, int priority) {
            this.allow = allow;
            this.priority = priority;
        }

        public boolean canCreate() {
            return this.allow;
        }
    }

    public record BlockCheckResult(@Nullable class_2338 pos, BlockResult result) {
    }
}

