/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.moddingplayground.twigs.init.TwigsBlocks;

public class PillarOxidizableBlock
extends RotatedPillarBlock
implements WeatheringCopper {
    private final WeatheringCopper.WeatherState level;
    public static Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)TwigsBlocks.COPPER_PILLAR.get()), (Object)((Block)TwigsBlocks.EXPOSED_COPPER_PILLAR.get())).put((Object)((Block)TwigsBlocks.EXPOSED_COPPER_PILLAR.get()), (Object)((Block)TwigsBlocks.WEATHERED_COPPER_PILLAR.get())).put((Object)((Block)TwigsBlocks.WEATHERED_COPPER_PILLAR.get()), (Object)((Block)TwigsBlocks.OXIDIZED_COPPER_PILLAR.get())).build());
    public static final Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());

    public PillarOxidizableBlock(WeatheringCopper.WeatherState level, BlockBehaviour.Properties settings) {
        super(settings);
        this.level = level;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.m_220947_(state, world, pos, random);
    }

    public boolean m_6724_(BlockState state) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)state.m_60734_())).isPresent();
    }

    public Optional<BlockState> m_142123_(BlockState state) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getPreviousState(BlockState state) {
        return Optional.ofNullable((Block)PREVIOUS_BY_BLOCK.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.level;
    }
}

