/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.client.renderers;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class StrippedBambooBoatRenderer
extends BoatRenderer {
    private final Pair<ResourceLocation, BoatModel> stripped_bamboo;

    public StrippedBambooBoatRenderer(EntityRendererProvider.Context context, boolean hasChest) {
        super(context, hasChest);
        this.stripped_bamboo = Pair.of((Object)this.getTexture(hasChest), (Object)new BoatModel(context.m_174023_(StrippedBambooBoatRenderer.createModelLayerLocation(hasChest)), hasChest));
    }

    @NotNull
    public static ModelLayerLocation createModelLayerLocation(boolean hasChest) {
        return new ModelLayerLocation(new ResourceLocation("twigs", hasChest ? "chest_boat/stripped_bamboo" : "boat/stripped_bamboo"), "main");
    }

    public ResourceLocation getTexture(boolean hasChest) {
        if (hasChest) {
            return new ResourceLocation("twigs", "textures/entity/chest_boat/stripped_bamboo.png");
        }
        return new ResourceLocation("twigs", "textures/entity/boat/stripped_bamboo.png");
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(Boat boat) {
        return this.stripped_bamboo;
    }
}

