/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.crafting.conditions;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;

public class QuarkCondition
implements ICondition {
    private final ResourceLocation resourceLocation;
    private final String flag;

    public QuarkCondition(ResourceLocation resourceLocation, String flag) {
        this.resourceLocation = resourceLocation;
        this.flag = flag;
    }

    public ResourceLocation getID() {
        return this.resourceLocation;
    }

    public boolean test(ICondition.IContext context) {
        if (ModList.get().isLoaded("quark")) {
            JsonObject dummy = new JsonObject();
            dummy.addProperty("type", "quark:flag");
            dummy.addProperty("flag", this.flag);
            return CraftingHelper.getCondition((JsonObject)dummy).test(context);
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<QuarkCondition> {
        private final ResourceLocation resourceLocation = new ResourceLocation("twigs", "quark_flag");

        public void write(JsonObject json, QuarkCondition value) {
            json.addProperty("flag", value.flag);
        }

        public QuarkCondition read(JsonObject json) {
            return new QuarkCondition(this.resourceLocation, json.getAsJsonPrimitive("flag").getAsString());
        }

        public ResourceLocation getID() {
            return this.resourceLocation;
        }
    }
}

