/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.twigs.events;

import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.moddingplayground.twigs.client.particles.TwigsBreakingItemParticle;
import net.moddingplayground.twigs.client.renderers.StrippedBambooBoatRenderer;
import net.moddingplayground.twigs.init.TwigsBlockEntities;
import net.moddingplayground.twigs.init.TwigsBlocks;
import net.moddingplayground.twigs.init.TwigsEntityTypes;
import net.moddingplayground.twigs.init.TwigsParticleTypes;
import net.moddingplayground.twigs.init.TwigsWoodType;

@Mod.EventBusSubscriber(modid="twigs", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(TwigsWoodType::init);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)TwigsBlocks.PETRIFIED_LICHEN.get()), (RenderType)RenderType.m_110463_());
    }

    @SubscribeEvent
    public static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TwigsEntityTypes.STRIPPED_BAMBOO_BOAT.get(), context -> new StrippedBambooBoatRenderer(context, false));
        event.registerEntityRenderer((EntityType)TwigsEntityTypes.STRIPPED_BAMBOO_CHEST_BOAT.get(), context -> new StrippedBambooBoatRenderer(context, true));
        event.registerEntityRenderer((EntityType)TwigsEntityTypes.PEBBLE.get(), ThrownItemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TwigsBlockEntities.TWIGS_SIGN.get(), SignRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("twigs", "boat/stripped_bamboo"), "main"), () -> BoatModel.m_233347_((boolean)false));
        event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("twigs", "chest_boat/stripped_bamboo"), "main"), () -> BoatModel.m_233347_((boolean)true));
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)TwigsParticleTypes.ITEM_PEBBLE.get(), (ParticleProvider)new TwigsBreakingItemParticle.PebbleProvider());
    }
}

