/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.client.renderer.entity.layer;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.client.model.ModelWolfArmor;
import com.attributestudios.wolfarmor.client.renderer.entity.RenderWolfArmored;
import com.attributestudios.wolfarmor.entity.passive.EntityWolfArmored;
import com.attributestudios.wolfarmor.item.ItemWolfArmor;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerWolfArmor
implements LayerRenderer<EntityWolf> {
    private ModelWolfArmor[] modelWolfArmors;
    private RenderWolfArmored renderer;
    private static final Map<String, ResourceLocation> WOLF_ARMOR_TEXTURE_MAP = Maps.newHashMap();
    private float colorRed = 1.0f;
    private float colorGreen = 1.0f;
    private float colorBlue = 1.0f;
    private float alpha = 1.0f;
    private boolean shouldSkipArmorGlint;

    public LayerWolfArmor(@Nonnull RenderWolfArmored renderer) {
        this.renderer = renderer;
        this.initArmor();
    }

    public void doRenderLayer(@Nullable EntityWolf entityWolf, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        EntityWolfArmored entityWolfArmored;
        ItemStack itemStack;
        if (WolfArmorMod.getConfiguration().getIsWolfArmorRenderEnabled() && entityWolf instanceof EntityWolfArmored && !(itemStack = (entityWolfArmored = (EntityWolfArmored)entityWolf).getArmorItemStack()).func_190926_b() && itemStack.func_77973_b() instanceof ItemWolfArmor) {
            ItemWolfArmor armorItem = (ItemWolfArmor)itemStack.func_77973_b();
            for (int layer = 0; layer < this.modelWolfArmors.length; ++layer) {
                ModelWolfArmor model = this.modelWolfArmors[layer];
                model = this.getArmorModelForLayer(entityWolfArmored, itemStack, layer, model);
                model.func_178686_a(this.renderer.func_177087_b());
                model.func_78086_a((EntityLivingBase)entityWolfArmored, limbSwing, limbSwingAmount, partialTicks);
                this.renderer.func_110776_a(this.getArmorResource(entityWolfArmored, itemStack, layer, null));
                int color = armorItem.getColor(itemStack);
                if (color != -1) {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    GlStateManager.func_179131_c((float)(this.getColorRed() * r), (float)(this.getColorGreen() * g), (float)(this.getColorBlue() * b), (float)this.getAlpha());
                } else {
                    GlStateManager.func_179131_c((float)this.getColorRed(), (float)this.getColorGreen(), (float)this.getColorBlue(), (float)this.getAlpha());
                }
                model.func_78088_a((Entity)entityWolfArmored, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179131_c((float)this.getColorRed(), (float)this.getColorGreen(), (float)this.getColorBlue(), (float)this.getAlpha());
                if (armorItem.getHasOverlay(itemStack)) {
                    this.renderer.func_110776_a(this.getArmorResource(entityWolfArmored, itemStack, layer, "overlay"));
                    model.func_78088_a((Entity)entityWolfArmored, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                }
                if (this.getShouldSkipArmorGlint() || !itemStack.func_77962_s()) continue;
                LayerArmorBase.func_188364_a((RenderLivingBase)this.renderer, (EntityLivingBase)entityWolfArmored, (ModelBase)model, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
            }
        }
    }

    protected void initArmor() {
        ModelWolfArmor modelWolfArmorLayer0 = new ModelWolfArmor(0.2f);
        ModelWolfArmor modelWolfArmorLayer1 = new ModelWolfArmor(0.1f);
        this.modelWolfArmors = new ModelWolfArmor[]{modelWolfArmorLayer0, modelWolfArmorLayer1};
    }

    @Nonnull
    protected ModelWolfArmor getArmorModelForLayer(@Nonnull EntityWolfArmored entityWolfArmored, @Nonnull ItemStack itemStack, int layer, @Nonnull ModelWolfArmor model) {
        return model;
    }

    @Nonnull
    protected ResourceLocation getArmorResource(@Nonnull EntityWolfArmored entityWolfArmored, @Nonnull ItemStack itemStack, int layer, @Nullable String type) {
        String path;
        ResourceLocation resource;
        ItemWolfArmor armor = (ItemWolfArmor)itemStack.func_77973_b();
        String texture = armor.getMaterial().getName();
        String domain = "wolfarmor";
        int i = texture.indexOf(58);
        if (i > -1) {
            domain = texture.substring(0, i);
            texture = texture.substring(i);
        }
        if ((resource = WOLF_ARMOR_TEXTURE_MAP.get(path = String.format("%s:textures/models/armor/wolf_%s_%d%s.png", domain, texture, layer, type == null ? "" : String.format("_%s", type)))) == null) {
            resource = new ResourceLocation(path);
            WOLF_ARMOR_TEXTURE_MAP.put(path, resource);
        }
        return resource;
    }

    protected float getColorRed() {
        return this.colorRed;
    }

    protected float getColorGreen() {
        return this.colorGreen;
    }

    protected float getColorBlue() {
        return this.colorBlue;
    }

    protected float getAlpha() {
        return this.alpha;
    }

    public boolean func_177142_b() {
        return false;
    }

    protected boolean getShouldSkipArmorGlint() {
        return this.shouldSkipArmorGlint;
    }

    @Nonnull
    public LayerWolfArmor setColorRed(float colorRed) {
        this.colorRed = colorRed;
        return this;
    }

    @Nonnull
    public LayerWolfArmor setColorGreen(float colorGreen) {
        this.colorGreen = colorGreen;
        return this;
    }

    @Nonnull
    public LayerWolfArmor setColorBlue(float colorBlue) {
        this.colorBlue = colorBlue;
        return this;
    }

    @Nonnull
    public LayerWolfArmor setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    @Nonnull
    public LayerWolfArmor setShouldSkipArmorGlint(boolean shouldSkipArmorGlint) {
        this.shouldSkipArmorGlint = shouldSkipArmorGlint;
        return this;
    }
}

