/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.common;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class ReflectionCache {
    private static Map<String, Field> CACHED_REFLECTION_FIELDS = Maps.newHashMap();
    private static Map<String, Method> CACHED_REFLECTION_METHODS = Maps.newHashMap();

    private ReflectionCache() {
    }

    @Nullable
    public static Field getField(@Nonnull Class clazz, String ... fieldNames) {
        if (fieldNames.length > 0) {
            String key;
            Field field = null;
            for (String s : fieldNames) {
                key = clazz.getName() + "." + s;
                if (!CACHED_REFLECTION_FIELDS.containsKey(key)) continue;
                field = CACHED_REFLECTION_FIELDS.get(key);
                break;
            }
            if (field == null) {
                for (String s : fieldNames) {
                    key = clazz.getName() + "." + s;
                    try {
                        field = ReflectionHelper.findField((Class)clazz, (String[])fieldNames);
                        CACHED_REFLECTION_FIELDS.put(key, field);
                    }
                    catch (ReflectionHelper.UnableToFindFieldException ex) {
                        WolfArmorMod.getLogger().error((Exception)((Object)ex));
                    }
                }
            }
            return field;
        }
        throw new IllegalArgumentException("Must specify at least one field name.");
    }

    @Nullable
    public static <E> Method getMethod(@Nonnull Class<? super E> clazz, @Nullable E instance, @Nonnull String[] methodNames, Class<?> ... params) {
        if (methodNames.length > 0) {
            String key;
            Method method = null;
            String keyParams = "(";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    keyParams = keyParams + ", ";
                }
                keyParams = keyParams + params[i].getName();
            }
            keyParams = keyParams + ")";
            for (String s : methodNames) {
                key = clazz.getName() + "." + s + keyParams;
                if (!CACHED_REFLECTION_METHODS.containsKey(key)) continue;
                method = CACHED_REFLECTION_METHODS.get(key);
                break;
            }
            if (method == null) {
                for (String s : methodNames) {
                    key = clazz.getName() + "." + s + keyParams;
                    try {
                        method = ReflectionHelper.findMethod(clazz, instance, (String[])methodNames, (Class[])params);
                        CACHED_REFLECTION_METHODS.put(key, method);
                    }
                    catch (ReflectionHelper.UnableToFindMethodException ex) {
                        WolfArmorMod.getLogger().error((Exception)((Object)ex));
                    }
                }
            }
            return method;
        }
        throw new IllegalArgumentException("Must specify at least one method name.");
    }
}

