/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.event;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.common.ReflectionCache;
import com.attributestudios.wolfarmor.entity.passive.EntityWolfArmored;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WolfArmorEntityEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorld(@Nonnull EntityJoinWorldEvent event) {
        Entity entity;
        World world = event.getWorld();
        if (!world.field_72995_K && (entity = event.getEntity()).getClass() == EntityWolf.class) {
            EntityWolfArmored entityWolfArmored = new EntityWolfArmored(world);
            try {
                entityWolfArmored.func_82149_j(entity);
                Method writeEntityToNBT = ReflectionCache.getMethod(Entity.class, entity, new String[]{"func_70014_b", "writeEntityToNBT"}, NBTTagCompound.class);
                if (writeEntityToNBT != null) {
                    try {
                        NBTTagCompound compound = new NBTTagCompound();
                        writeEntityToNBT.invoke((Object)entity, compound);
                        entityWolfArmored.func_70037_a(compound);
                    }
                    catch (InvocationTargetException ex) {
                        WolfArmorMod.getLogger().warning("NBT data for spawned wolf has been lost! InvocationTargetException: " + ex.getMessage());
                    }
                }
            }
            catch (IllegalAccessException ex) {
                WolfArmorMod.getLogger().fatal(ex);
                throw new RuntimeException("Reflection failed in WolfArmorEntityEventHandler: invoke failed (" + ex.getMessage() + ")", ex);
            }
            world.func_72838_d((Entity)entityWolfArmored);
            entity.func_70106_y();
            event.setCanceled(true);
        }
    }
}

