/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.moolands.world;

import com.legacy.moolands.MoolandsConfig;
import com.legacy.moolands.blocks.BlocksMoolands;
import com.legacy.moolands.world.NoiseGeneratorOctaves;
import com.legacy.moolands.world.biome.WorldGenFoilage;
import com.legacy.moolands.world.biome.WorldGenTallGrass;
import com.legacy.moolands.world.mushrooms.WorldGenSmallBlueMushroom;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkProviderMooland
implements IChunkProvider {
    private Random random;
    private double[] noiseArray;
    private World world;
    double[] noise;
    private NoiseGeneratorOctaves noise_generator;
    public WorldGenFoilage foilage = new WorldGenFoilage();

    public ChunkProviderMooland(World world) {
        this.world = world;
        this.random = new Random();
        this.noise_generator = new NoiseGeneratorOctaves(this.random, 4);
    }

    public void generateTop(ChunkPrimer chunk) {
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int i1 = (int)(3.0 + this.random.nextDouble() * 0.25);
                int j1 = -1;
                IBlockState top = BlocksMoolands.mooland_grass.func_176223_P();
                IBlockState filler = BlocksMoolands.mooland_dirt.func_176223_P();
                for (int k1 = 127; k1 >= 0; --k1) {
                    Block block = chunk.func_177856_a(k, k1, l).func_177230_c();
                    if (block == Blocks.field_150350_a) {
                        j1 = -1;
                        continue;
                    }
                    if (block != BlocksMoolands.mooland_stone) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            top = Blocks.field_150350_a.func_176223_P();
                            filler = BlocksMoolands.mooland_stone.func_176223_P();
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            chunk.func_177855_a(k, k1, l, top);
                            continue;
                        }
                        chunk.func_177855_a(k, k1, l, filler);
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    chunk.func_177855_a(k, k1, l, filler);
                }
            }
        }
    }

    private void generateTerrain(int i, int j, ChunkPrimer chunk) {
        this.noiseArray = this.generateNoise(this.noiseArray, i * 2, j * 2);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d1 = this.noiseArray[(i1 * 34 + j1) * 33 + k1];
                    double d2 = this.noiseArray[(i1 * 34 + (j1 + 1)) * 33 + k1];
                    double d3 = this.noiseArray[((i1 + 1) * 34 + j1) * 33 + k1];
                    double d4 = this.noiseArray[((i1 + 1) * 34 + (j1 + 1)) * 33 + k1];
                    double d5 = (this.noiseArray[(i1 * 34 + j1) * 33 + (k1 + 1)] - d1) * 0.25;
                    double d6 = (this.noiseArray[(i1 * 34 + (j1 + 1)) * 33 + (k1 + 1)] - d2) * 0.25;
                    double d7 = (this.noiseArray[((i1 + 1) * 34 + j1) * 33 + (k1 + 1)] - d3) * 0.25;
                    double d8 = (this.noiseArray[((i1 + 1) * 34 + (j1 + 1)) * 33 + (k1 + 1)] - d4) * 0.25;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.125;
                        double d13 = (d4 - d2) * 0.125;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int k2 = 0; k2 < 8; ++k2) {
                                int x = i2 + i1 * 8;
                                int z = k2 + j1 * 8;
                                int y = k1 * 4 + l1;
                                IBlockState filler = Blocks.field_150350_a.func_176223_P();
                                if (d15 > 0.0) {
                                    filler = BlocksMoolands.mooland_stone.func_176223_P();
                                }
                                if (!MoolandsConfig.useOldGenHeight()) {
                                    if (y <= 70) {
                                        chunk.func_177855_a(x, y, z, filler);
                                    }
                                } else {
                                    chunk.func_177855_a(x, y, z, filler);
                                }
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private double[] generateNoise(double[] ad, int i, int k) {
        if (ad == null) {
            ad = new double[3366];
        }
        this.noise = this.noise_generator.generateNoiseOctaves(this.noise, i, 0, k, 3, 33, 34, 1.0, 1.0, 1.0);
        int id = 0;
        for (int l1 = 0; l1 < 3; ++l1) {
            for (int i2 = 0; i2 < 34; ++i2) {
                for (int j2 = 0; j2 < 33; ++j2) {
                    ad[id] = this.noise[id] + ((double)(j2 / 33) - 0.5);
                    ++id;
                }
            }
        }
        return ad;
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        this.generateTerrain(chunkX, chunkZ, chunkPrimer);
        this.generateTop(chunkPrimer);
        Chunk chunk = new Chunk(this.world, chunkPrimer, chunkX, chunkZ);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_73153_a(IChunkProvider provider, int x, int z) {
        BlockPos pos = new BlockPos(x * 16, 0, z * 16);
        BiomeGenBase biome = this.world.func_180494_b(pos.func_177982_a(16, 0, 16));
        if (this.random.nextInt(3) == 0 && TerrainGen.decorate((World)this.world, (Random)this.random, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.BIG_SHROOM)) {
            for (int k2 = 0; k2 < 1; ++k2) {
                int l6 = this.random.nextInt(16) + 8;
                int k10 = this.random.nextInt(16) + 8;
                new WorldGenSmallBlueMushroom().func_180709_b(this.world, this.random, this.world.func_175645_m(pos.func_177982_a(l6, 0, k10)));
            }
        }
        if (MoolandsConfig.ultimateUpdate()) {
            int l17;
            int k14;
            int i11;
            int j7;
            int i3;
            if (this.random.nextInt(5) == 0) {
                new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.random, pos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(256), this.random.nextInt(16) + 8));
            }
            for (i3 = 0; i3 < 5; ++i3) {
                j7 = this.random.nextInt(16) + 8;
                k14 = this.world.func_175645_m(pos.func_177982_a(j7, 0, i11 = this.random.nextInt(16) + 8)).func_177956_o() * 2;
                if (k14 <= 0 || pos.func_177956_o() >= 140) continue;
                l17 = this.random.nextInt(k14);
                biome.func_76730_b(this.random).func_180709_b(this.world, this.random, pos.func_177982_a(j7, l17, i11));
            }
            if (this.random.nextInt(5) == 0) {
                i3 = 0;
                while ((double)i3 < 0.2) {
                    j7 = this.random.nextInt(16) + 8;
                    k14 = this.world.func_175645_m(pos.func_177982_a(j7, 0, i11 = this.random.nextInt(16) + 8)).func_177956_o() * 2;
                    if (k14 > 0 && pos.func_177956_o() < 140) {
                        l17 = this.random.nextInt(k14);
                        this.getBlueShroom(this.random).func_180709_b(this.world, this.random, pos.func_177982_a(j7, l17, i11));
                    }
                    ++i3;
                }
                i3 = 0;
                while ((double)i3 < 0.2) {
                    j7 = this.random.nextInt(16) + 8;
                    k14 = this.world.func_175645_m(pos.func_177982_a(j7, 0, i11 = this.random.nextInt(16) + 8)).func_177956_o() * 2;
                    if (k14 > 0 && pos.func_177956_o() < 140) {
                        l17 = this.random.nextInt(k14);
                        this.getYellowShroom(this.random).func_180709_b(this.world, this.random, pos.func_177982_a(j7, l17, i11));
                    }
                    ++i3;
                }
            }
        }
        SpawnerAnimals.func_77191_a((World)this.world, (BiomeGenBase)biome, (int)(pos.func_177958_n() + 8), (int)(pos.func_177952_p() + 8), (int)16, (int)16, (Random)this.random);
    }

    public WorldGenerator getBlueShroom(Random rand) {
        return new WorldGenTallGrass(BlocksMoolands.small_blue_mushroom.func_176223_P());
    }

    public WorldGenerator getYellowShroom(Random rand) {
        return new WorldGenTallGrass(BlocksMoolands.small_yellow_mushroom.func_176223_P());
    }

    public List<BiomeGenBase.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position) {
        return null;
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public boolean func_177460_a(IChunkProvider provider, Chunk chunkIn, int chunkX, int chunkZ) {
        return false;
    }

    public Chunk func_177459_a(BlockPos blockPosIn) {
        return this.func_73154_d(blockPosIn.func_177958_n() >> 4, blockPosIn.func_177952_p() >> 4);
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate progressCallback) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomMoolandLevelSource";
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_104112_b() {
    }
}

