/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.teammetallurgy.aquaculture.Aquaculture;
import com.teammetallurgy.aquaculture.misc.BiomeDictionaryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeTagPredicate {
    private static final BiomeTagPredicate ANY = new BiomeTagPredicate(MinMaxBounds.Doubles.f_154779_, MinMaxBounds.Doubles.f_154779_, MinMaxBounds.Doubles.f_154779_, Lists.newArrayList(), Lists.newArrayList(), false);
    private static final HashMap<CheckType, List<ResourceLocation>> CACHE = new HashMap();
    private static final List<BiomeDictionary.Type> INVALID_TYPES = Arrays.asList(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END);
    private final MinMaxBounds.Doubles x;
    private final MinMaxBounds.Doubles y;
    private final MinMaxBounds.Doubles z;
    private final List<BiomeDictionary.Type> include;
    private final List<BiomeDictionary.Type> exclude;
    private final boolean and;

    public BiomeTagPredicate(MinMaxBounds.Doubles x, MinMaxBounds.Doubles y, MinMaxBounds.Doubles z, List<BiomeDictionary.Type> include, List<BiomeDictionary.Type> exclude, boolean and) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.include = include;
        this.exclude = exclude;
        this.and = and;
    }

    public boolean test(ServerLevel world, float x, float y, float z) {
        if (!this.x.m_154810_((double)x)) {
            return false;
        }
        if (!this.y.m_154810_((double)y)) {
            return false;
        }
        if (!this.z.m_154810_((double)z)) {
            return false;
        }
        BlockPos pos = new BlockPos((double)x, (double)y, (double)z);
        Biome biome = world.m_46857_(pos);
        ResourceLocation biomeFromRegistry = world.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)biome);
        CheckType checkType = CheckType.getOrCreate(this.include, this.exclude, this.and);
        List<ResourceLocation> validBiomes = CACHE.get(checkType);
        if (validBiomes == null) {
            validBiomes = BiomeTagPredicate.getValidBiomes(checkType);
            CACHE.put(checkType, validBiomes);
        }
        return validBiomes.contains(biomeFromRegistry);
    }

    public static List<ResourceLocation> getValidBiomes(CheckType checkType) {
        return BiomeTagPredicate.getValidBiomes(checkType.getInclude(), checkType.getExclude(), checkType.isAnd());
    }

    public static List<ResourceLocation> getValidBiomes(List<BiomeDictionary.Type> includeList, List<BiomeDictionary.Type> excludeList, boolean and) {
        ArrayList biomes = Lists.newArrayList();
        if (includeList.isEmpty() && !excludeList.isEmpty()) {
            HashSet validTypes = new HashSet(BiomeDictionary.Type.getAll());
            includeList.addAll(validTypes);
            excludeList.addAll(INVALID_TYPES);
        }
        if (!includeList.isEmpty()) {
            ArrayList addBiomes = Lists.newArrayList();
            for (BiomeDictionary.Type type : includeList) {
                addBiomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
            }
            if (and) {
                for (BiomeDictionary.Type type : includeList) {
                    addBiomes.removeIf(biome -> !BiomeDictionary.getBiomes((BiomeDictionary.Type)type).contains(biome));
                }
            }
            if (includeList.stream().noneMatch(INVALID_TYPES::contains)) {
                excludeList.addAll(INVALID_TYPES);
            }
            for (ResourceKey addBiome : addBiomes) {
                if (biomes.contains(addBiome.m_135782_())) continue;
                biomes.add(addBiome.m_135782_());
            }
        }
        if (!excludeList.isEmpty()) {
            for (BiomeDictionary.Type type : excludeList) {
                for (ResourceKey biome2 : BiomeDictionary.getBiomes((BiomeDictionary.Type)type)) {
                    biomes.remove(biome2.m_135782_());
                }
            }
        }
        return biomes;
    }

    public JsonElement serialize() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject object = new JsonObject();
        if (!(this.x.m_55327_() && this.y.m_55327_() && this.z.m_55327_())) {
            JsonObject posObj = new JsonObject();
            posObj.add("x", this.x.m_55328_());
            posObj.add("y", this.y.m_55328_());
            posObj.add("z", this.z.m_55328_());
            object.add("position", (JsonElement)posObj);
        }
        if (this.include != null) {
            for (BiomeDictionary.Type type : this.include) {
                object.add("include", (JsonElement)object.getAsJsonArray(type.getName()));
            }
        }
        if (this.exclude != null) {
            for (BiomeDictionary.Type type : this.exclude) {
                object.add("exclude", (JsonElement)object.getAsJsonArray(type.getName()));
            }
        }
        object.addProperty("add", Boolean.valueOf(object.getAsBoolean()));
        return object;
    }

    public static BiomeTagPredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject location = GsonHelper.m_13918_((JsonElement)element, (String)"location");
            JsonObject position = GsonHelper.m_13841_((JsonObject)location, (String)"position", (JsonObject)new JsonObject());
            MinMaxBounds.Doubles x = MinMaxBounds.Doubles.m_154791_((JsonElement)position.get("x"));
            MinMaxBounds.Doubles y = MinMaxBounds.Doubles.m_154791_((JsonElement)position.get("y"));
            MinMaxBounds.Doubles z = MinMaxBounds.Doubles.m_154791_((JsonElement)position.get("z"));
            ArrayList include = Lists.newArrayList();
            if (location.has("include")) {
                JsonArray includeArray = GsonHelper.m_13933_((JsonObject)location, (String)"include");
                for (int entry = 0; entry < includeArray.size(); ++entry) {
                    String name = includeArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    BiomeDictionary.Type type = BiomeDictionaryHelper.getType(name);
                    if (type == null) {
                        Aquaculture.LOG.error("Failed to include BiomeDictionary Type: " + name + ". Please check your loot tables");
                        continue;
                    }
                    include.add(type);
                }
            }
            ArrayList exclude = Lists.newArrayList();
            if (location.has("exclude")) {
                JsonArray excludeArray = GsonHelper.m_13933_((JsonObject)location, (String)"exclude");
                for (int entry = 0; entry < excludeArray.size(); ++entry) {
                    String name = excludeArray.get(entry).getAsString().toLowerCase(Locale.ROOT);
                    BiomeDictionary.Type type = BiomeDictionaryHelper.getType(name);
                    if (type == null) {
                        Aquaculture.LOG.error("Failed to exclude BiomeDictionary Type: " + name + ". Please check your loot tables");
                        continue;
                    }
                    exclude.add(type);
                }
            }
            boolean and = false;
            if (location.has("and")) {
                and = GsonHelper.m_13912_((JsonObject)location, (String)"and");
            }
            return new BiomeTagPredicate(x, y, z, include, exclude, and);
        }
        return ANY;
    }

    public static class CheckType {
        private static final Map<Integer, CheckType> BY_NAME = new TreeMap<Integer, CheckType>();
        private final List<BiomeDictionary.Type> include;
        private final List<BiomeDictionary.Type> exclude;
        private final boolean and;

        private CheckType(List<BiomeDictionary.Type> include, List<BiomeDictionary.Type> exclude, boolean and) {
            this.include = include;
            this.exclude = exclude;
            this.and = and;
            BY_NAME.put(this.hashCode(), this);
        }

        public List<BiomeDictionary.Type> getInclude() {
            return this.include;
        }

        public List<BiomeDictionary.Type> getExclude() {
            return this.exclude;
        }

        public boolean isAnd() {
            return this.and;
        }

        public static CheckType getOrCreate(List<BiomeDictionary.Type> include, List<BiomeDictionary.Type> exclude, boolean and) {
            CheckType checkType = BY_NAME.get(Objects.hash(include, exclude, and));
            if (checkType == null) {
                checkType = new CheckType(include, exclude, and);
            }
            return checkType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CheckType checkType = (CheckType)o;
            return this.and == checkType.and && Objects.equals(this.include, checkType.include) && Objects.equals(this.exclude, checkType.exclude);
        }

        public int hashCode() {
            return Objects.hash(this.include, this.exclude, this.and);
        }
    }
}

