/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore;

import com.alexander.mutantmore.config.MutantConfig;
import com.alexander.mutantmore.entities.MutantBlazeEntity;
import com.alexander.mutantmore.entities.MutantHoglinEntity;
import com.alexander.mutantmore.entities.MutantHuskEntity;
import com.alexander.mutantmore.entities.MutantShulkerBoxEntity;
import com.alexander.mutantmore.entities.MutantShulkerEntity;
import com.alexander.mutantmore.entities.MutantWitherSkeletonEntity;
import com.alexander.mutantmore.entities.RodlingEntity;
import com.alexander.mutantmore.init.BlockInit;
import com.alexander.mutantmore.init.EffectInit;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TileEntityTypeInit;
import com.alexander.mutantmore.items.CustomSpawnEggItem;
import com.alexander.mutantmore.packets.MutantMorePacketHandler;
import com.alexander.mutantmore.world.SensorMapModifier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="mutantmore")
@Mod.EventBusSubscriber(modid="mutantmore", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MutantMore {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "mutantmore";

    public MutantMore() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        GeckoLib.initialize();
        SoundEventInit.SOUNDS.register(bus);
        EffectInit.EFFECTS.register(bus);
        EffectInit.POTIONS.register(bus);
        EntityTypeInit.ENTITY_TYPES.register(bus);
        BlockInit.BLOCKS.register(bus);
        TileEntityTypeInit.TILE_ENTITY_TYPES.register(bus);
        ItemInit.ITEMS.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, MutantConfig.SPEC, "mutantmore-common.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onRegisterEntities(RegistryEvent.Register<EntityType<?>> event) {
        CustomSpawnEggItem.initSpawnEggs();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        MutantMorePacketHandler.register();
        event.enqueueWork(SensorMapModifier::replaceSensorMaps);
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185253_y)}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221655_bP}), (ItemStack)new ItemStack((IItemProvider)ItemInit.FORMULA_Y.get()));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.FORMULA_Y.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.MUTANT_WITHER_SKELETON_SKULL.get()}), (ItemStack)new ItemStack((IItemProvider)ItemInit.COMPOUND_Z.get()));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.FORMULA_Y.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.MUTANT_HOGLIN_TUSK.get()}), (ItemStack)new ItemStack((IItemProvider)ItemInit.COMPOUND_Z.get()));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.FORMULA_Y.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.MUTANT_BLAZE_CORE.get()}), (ItemStack)new ItemStack((IItemProvider)ItemInit.COMPOUND_Z.get()));
        if (ModList.get().isLoaded("mutantbeasts")) {
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.FORMULA_Y.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mutantbeasts", "hulk_hammer"))}), (ItemStack)new ItemStack((IItemProvider)ItemInit.COMPOUND_Z.get()));
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.FORMULA_Y.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mutantbeasts", "mutant_skeleton_skull"))}), (ItemStack)new ItemStack((IItemProvider)ItemInit.COMPOUND_Z.get()));
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.FORMULA_Y.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mutantbeasts", "creeper_shard"))}), (ItemStack)new ItemStack((IItemProvider)ItemInit.COMPOUND_Z.get()));
            BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ItemInit.FORMULA_Y.get()}), (Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mutantbeasts", "endersoul_hand"))}), (ItemStack)new ItemStack((IItemProvider)ItemInit.COMPOUND_Z.get()));
        }
        PotionBrewing.func_193357_a((Potion)Potions.field_185233_e, (Item)((Item)ItemInit.MUTANT_HOGLIN_TUSK.get()), (Potion)((Potion)EffectInit.HOG_POWER_POTION.get()));
        PotionBrewing.func_193357_a((Potion)((Potion)EffectInit.HOG_POWER_POTION.get()), (Item)Items.field_151114_aO, (Potion)((Potion)EffectInit.STRONG_HOG_POWER_POTION.get()));
        PotionBrewing.func_193357_a((Potion)((Potion)EffectInit.HOG_POWER_POTION.get()), (Item)Items.field_151137_ax, (Potion)((Potion)EffectInit.LONG_HOG_POWER_POTION.get()));
        DeferredWorkQueue.runLater(() -> {
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.MUTANT_HUSK.get()), (AttributeModifierMap)MutantHuskEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.MUTANT_WITHER_SKELETON.get()), (AttributeModifierMap)MutantWitherSkeletonEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.MUTANT_BLAZE.get()), (AttributeModifierMap)MutantBlazeEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.RODLING.get()), (AttributeModifierMap)RodlingEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.MUTANT_HOGLIN.get()), (AttributeModifierMap)MutantHoglinEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.MUTANT_SHULKER.get()), (AttributeModifierMap)MutantShulkerEntity.createAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)EntityTypeInit.MUTANT_SHULKER_BOX.get()), (AttributeModifierMap)MutantShulkerBoxEntity.createAttributes().func_233813_a_());
        });
    }
}

