/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.entities.BlazeRodEntity;
import com.alexander.mutantmore.entities.RodlingEntity;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.ItemInit;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MutantBlazeEntity
extends MonsterEntity
implements IAnimatable {
    private final EntityPredicate rodlingSummonPredicate = new EntityPredicate().func_221013_a(25.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
    private final EntityPredicate tornadoMobPredicate = new EntityPredicate().func_221013_a(50.0).func_221010_e().func_221008_a().func_221011_b();
    public static final DataParameter<Integer> SHOOT_FIREBALL_TICKS = EntityDataManager.func_187226_a(MutantBlazeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> ROD_SHOT_TICKS = EntityDataManager.func_187226_a(MutantBlazeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> CHARGE_TICKS = EntityDataManager.func_187226_a(MutantBlazeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Predicate<Entity> ALIVE = p_213685_0_ -> p_213685_0_.func_70089_S() && p_213685_0_.func_233570_aj_();
    public int fireballCooldown = 0;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public MutantBlazeEntity(EntityType<? extends MutantBlazeEntity> p_i50215_1_, World p_i50215_2_) {
        super(p_i50215_1_, p_i50215_2_);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 50;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new RodShotGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ChargeGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new ShootFireballGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return this.getChargeTicks() > 0 ? EntitySize.func_220314_b((float)2.25f, (float)1.7f) : super.func_213305_a(p_213305_1_);
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (CHARGE_TICKS.equals(p_184206_1_)) {
            this.func_213323_x_();
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(p_184206_1_);
    }

    public void func_70030_z() {
        super.func_70030_z();
        for (LivingEntity entity : this.field_70170_p.func_217374_a(LivingEntity.class, this.tornadoMobPredicate, (LivingEntity)this, this.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0))) {
            if (this.getRodShotTicks() > 0 || entity == this || entity.field_70173_aa % 5 != 0) continue;
            entity.field_70133_I = true;
            Vector3d vector3d = new Vector3d(this.func_226277_ct_() - 2.0 + (double)this.field_70146_Z.nextInt(4) - entity.func_226277_ct_(), (double)(-2 + this.field_70146_Z.nextInt(6)), this.func_226281_cx_() - 2.0 + (double)this.field_70146_Z.nextInt(4) - entity.func_226281_cx_()).func_186678_a(0.25);
            entity.func_213317_d(vector3d);
        }
        System.out.print("\r\n" + this.getShootFireballTicks());
        if (this.fireballCooldown > 0) {
            --this.fireballCooldown;
        }
        if (this.getShootFireballTicks() > 0) {
            this.setShootFireballTicks(this.getShootFireballTicks() - 1);
        }
        if (this.getRodShotTicks() > 0) {
            this.setRodShotTicks(this.getRodShotTicks() - 1);
        }
        if (this.getChargeTicks() > 0) {
            this.setChargeTicks(this.getChargeTicks() - 1);
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.field_70725_aQ > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_death", Boolean.valueOf(false)));
        } else if (this.getRodShotTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_rod_shot", Boolean.valueOf(true)));
        } else if (this.getChargeTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_charge", Boolean.valueOf(true)));
        } else if (this.getShootFireballTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        for (LivingEntity entity : this.field_70170_p.func_217374_a(LivingEntity.class, this.tornadoMobPredicate, (LivingEntity)this, this.func_174813_aQ().func_72314_b((double)(this.field_70725_aQ / 2), (double)(this.field_70725_aQ / 4), (double)(this.field_70725_aQ / 2)))) {
            if (entity == this || entity.field_70173_aa % 5 != 0) continue;
            entity.field_70133_I = true;
            Vector3d vector3d = new Vector3d(this.func_226277_ct_() - 4.0 + (double)this.field_70146_Z.nextInt(8) - entity.func_226277_ct_(), (double)(-4 + this.field_70146_Z.nextInt(8)), this.func_226281_cx_() - 4.0 + (double)this.field_70146_Z.nextInt(8) - entity.func_226281_cx_()).func_186678_a(0.25);
            entity.func_213317_d(vector3d);
        }
        if (this.field_70725_aQ == 80) {
            if (!this.field_70170_p.field_72995_K) {
                boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
                this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 5.0f, true, flag ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
            }
            this.func_199703_a((IItemProvider)ItemInit.MUTANT_BLAZE_CORE.get());
            this.func_70106_y();
            for (int i = 0; i < 46; ++i) {
                BlazeRodEntity part = new BlazeRodEntity(this.field_70170_p, (MobEntity)this, 0);
                part.func_213317_d(part.func_213322_ci().func_72441_c((double)(this.field_70146_Z.nextFloat() * 1.6f * 2.0f - 1.6f), (double)(this.field_70146_Z.nextFloat() * 0.25f + 0.1f), (double)(this.field_70146_Z.nextFloat() * 1.6f * 2.0f - 1.6f)));
                this.field_70170_p.func_217376_c((Entity)part);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233819_b_, 48.0).func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHOOT_FIREBALL_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(ROD_SHOT_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(CHARGE_TICKS, (Object)0);
    }

    public int getShootFireballTicks() {
        return (Integer)this.field_70180_af.func_187225_a(SHOOT_FIREBALL_TICKS);
    }

    public void setShootFireballTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(SHOOT_FIREBALL_TICKS, (Object)p_189794_1_);
    }

    public int getRodShotTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ROD_SHOT_TICKS);
    }

    public void setRodShotTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ROD_SHOT_TICKS, (Object)p_189794_1_);
    }

    public int getChargeTicks() {
        return (Integer)this.field_70180_af.func_187225_a(CHARGE_TICKS);
    }

    public void setChargeTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(CHARGE_TICKS, (Object)p_189794_1_);
    }

    protected float func_70647_i() {
        return super.func_70647_i() / 1.25f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187600_C;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 15; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(1.5), this.func_226279_cv_() + 0.75, this.func_226287_g_(1.5), (this.field_70146_Z.nextDouble() - 0.5) * 1.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 1.0);
                }
            }
        }
        super.func_70636_d();
    }

    private void performRangedAttack(LivingEntity p_82216_2_) {
        this.performRangedAttack(p_82216_2_.func_226277_ct_(), p_82216_2_.func_226278_cu_() + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.func_226281_cx_());
    }

    private void performRangedAttack(double p_82209_2_, double p_82209_4_, double p_82209_6_) {
        this.func_184185_a(SoundEvents.field_187557_bK, this.func_70599_aP(), this.func_70647_i());
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226280_cw_();
        double d2 = this.func_226281_cx_();
        double d3 = p_82209_2_ - d0;
        double d4 = p_82209_4_ - d1;
        double d5 = p_82209_6_ - d2;
        FireballEntity witherskullentity = new FireballEntity(this.field_70170_p, (LivingEntity)this, d3, d4, d5);
        witherskullentity.field_92057_e = 3;
        witherskullentity.func_212361_a((Entity)this);
        witherskullentity.func_226288_n_(d0, d1, d2);
        this.field_70170_p.func_217376_c((Entity)witherskullentity);
    }

    public boolean func_230270_dK_() {
        return true;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean func_70027_ad() {
        return this.getShootFireballTicks() > 0 || this.getRodShotTicks() > 0;
    }

    class ChargeGoal
    extends Goal {
        public ChargeGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean func_75250_a() {
            return MutantBlazeEntity.this.func_70638_az() != null && MutantBlazeEntity.this.fireballCooldown < 60 && MutantBlazeEntity.this.func_70032_d((Entity)MutantBlazeEntity.this.func_70638_az()) > 12.0f && MutantBlazeEntity.this.getChargeTicks() == 0 && MutantBlazeEntity.this.field_70146_Z.nextInt(100) == 0;
        }

        public boolean func_75253_b() {
            return MutantBlazeEntity.this.func_70638_az() != null && MutantBlazeEntity.this.getChargeTicks() > 0 && MutantBlazeEntity.this.func_70032_d((Entity)MutantBlazeEntity.this.func_70638_az()) > 2.0f;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantBlazeEntity.this.setChargeTicks(100);
        }

        public void func_75246_d() {
            MutantBlazeEntity.this.func_70015_d(1);
            MutantBlazeEntity mob = MutantBlazeEntity.this;
            LivingEntity target = MutantBlazeEntity.this.func_70638_az();
            mob.func_70671_ap().func_220679_a(mob.func_70638_az().func_226277_ct_(), mob.func_70638_az().func_226280_cw_(), mob.func_70638_az().func_226281_cx_());
            Vector3d vector3d = new Vector3d(target.func_226277_ct_() - mob.func_226277_ct_(), target.func_226278_cu_() - mob.func_226278_cu_(), target.func_226281_cx_() - mob.func_226281_cx_()).func_186678_a((double)0.05f);
            mob.func_213317_d(vector3d);
            mob.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    class RodShotGoal
    extends Goal {
        public RodShotGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantBlazeEntity.this.func_70638_az() != null && MutantBlazeEntity.this.func_70032_d((Entity)MutantBlazeEntity.this.func_70638_az()) <= 8.0f && MutantBlazeEntity.this.getRodShotTicks() == 0 && MutantBlazeEntity.this.field_70146_Z.nextInt(40) == 0;
        }

        public boolean func_75253_b() {
            return MutantBlazeEntity.this.func_70638_az() != null && MutantBlazeEntity.this.getRodShotTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantBlazeEntity.this.setRodShotTicks(50);
        }

        public void func_75246_d() {
            MutantBlazeEntity.this.func_70015_d(1);
            MutantBlazeEntity mob = MutantBlazeEntity.this;
            mob.func_70661_as().func_75499_g();
            if (mob.getRodShotTicks() == 25) {
                mob.func_184185_a(SoundEvents.field_187603_D, mob.func_70599_aP(), mob.func_70647_i());
                for (Entity entity : mob.field_70170_p.func_175647_a(LivingEntity.class, mob.func_174813_aQ().func_186662_g(7.0), ALIVE)) {
                    if (entity == mob) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)mob), 15.0f);
                    entity.func_70015_d(5);
                    double d0 = mob.func_70638_az().func_226277_ct_() - mob.func_226277_ct_();
                    double d1 = mob.func_70638_az().func_226281_cx_() - mob.func_226281_cx_();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    entity.field_70133_I = true;
                    entity.func_70024_g(d0 / d2 * 3.0, 0.5, d1 / d2 * 3.0);
                }
                if (mob.field_70146_Z.nextBoolean() && mob.field_70170_p.func_217374_a(RodlingEntity.class, mob.rodlingSummonPredicate, (LivingEntity)mob, mob.func_174813_aQ().func_186662_g(25.0)).size() < 5) {
                    ServerWorld serverworld = (ServerWorld)mob.field_70170_p;
                    BlockPos blockpos = mob.func_233580_cy_();
                    RodlingEntity vexentity = (RodlingEntity)((EntityType)EntityTypeInit.RODLING.get()).func_200721_a(mob.field_70170_p);
                    vexentity.func_174828_a(blockpos, 0.0f, 0.0f);
                    vexentity.func_213386_a((IServerWorld)serverworld, mob.field_70170_p.func_175649_E(blockpos), SpawnReason.MOB_SUMMONED, null, null);
                    vexentity.func_70624_b(mob.func_70638_az());
                    serverworld.func_242417_l((Entity)vexentity);
                }
            }
        }

        public boolean func_220685_C_() {
            return false;
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantBlazeEntity.this.setRodShotTicks(0);
        }
    }

    class ShootFireballGoal
    extends Goal {
        public boolean func_75250_a() {
            return MutantBlazeEntity.this.func_70638_az() != null && MutantBlazeEntity.this.func_70032_d((Entity)MutantBlazeEntity.this.func_70638_az()) > 8.0f && MutantBlazeEntity.this.getShootFireballTicks() == 0 && MutantBlazeEntity.this.fireballCooldown <= 0;
        }

        public boolean func_75253_b() {
            return MutantBlazeEntity.this.func_70638_az() != null && MutantBlazeEntity.this.getShootFireballTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantBlazeEntity.this.setShootFireballTicks(50);
            MutantBlazeEntity.this.fireballCooldown = 70;
        }

        public void func_75246_d() {
            MutantBlazeEntity.this.func_70015_d(1);
            MutantBlazeEntity mob = MutantBlazeEntity.this;
            mob.func_70671_ap().func_220679_a(mob.func_70638_az().func_226277_ct_(), mob.func_70638_az().func_226280_cw_(), mob.func_70638_az().func_226281_cx_());
            if (mob.getShootFireballTicks() == 10) {
                mob.performRangedAttack(mob.func_70638_az());
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantBlazeEntity.this.setShootFireballTicks(0);
        }

        public boolean func_220685_C_() {
            return false;
        }
    }
}

