/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.init.ItemInit;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MutantHoglinEntity
extends MonsterEntity
implements IAnimatable {
    public static final DataParameter<Integer> ATTACK_TICKS = EntityDataManager.func_187226_a(MutantHoglinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SLAM_TICKS = EntityDataManager.func_187226_a(MutantHoglinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> CHARGE_TICKS = EntityDataManager.func_187226_a(MutantHoglinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Ingredient OLE_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196205_eu, Items.field_221890_fc, Items.field_221617_aS});
    public boolean failedOle = false;
    private static final Predicate<Entity> GROUND_AND_ALIVE = p_213685_0_ -> p_213685_0_.func_70089_S() && p_213685_0_.func_233570_aj_();
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public MutantHoglinEntity(EntityType<? extends MutantHoglinEntity> p_i50189_1_, World p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ChargeGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new SlamGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new AttackGoal(this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(600));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractPiglinEntity.class, true).func_190882_b(1200));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true).func_190882_b(600));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public void func_70108_f(Entity p_70108_1_) {
        super.func_70108_f(p_70108_1_);
        if (p_70108_1_ instanceof LivingEntity && this.getChargeTicks() < 0) {
            this.doChargeTarget(p_70108_1_);
        }
    }

    public void func_70100_b_(PlayerEntity p_70100_1_) {
        if (this.getChargeTicks() < 0) {
            this.doChargeTarget((Entity)p_70100_1_);
        }
    }

    public boolean doChargeTarget(Entity p_70652_1_) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = p_70652_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e() * 2.0f);
        if (flag) {
            p_70652_1_.func_213317_d(p_70652_1_.func_213322_ci().func_72441_c(0.0, (double)0.8f, 0.0));
        }
        if (p_70652_1_ instanceof ServerPlayerEntity) {
            this.failedOle = true;
        }
        this.func_184185_a(SoundEvents.field_232714_fD_, this.func_70599_aP(), this.func_70647_i());
        if (p_70652_1_ instanceof PlayerEntity && ((PlayerEntity)p_70652_1_).func_184585_cz()) {
            ((PlayerEntity)p_70652_1_).func_184811_cZ().func_185145_a(((PlayerEntity)p_70652_1_).func_184607_cu().func_77973_b(), 80);
            ((PlayerEntity)p_70652_1_).func_184602_cy();
            p_70652_1_.field_70170_p.func_72960_a(p_70652_1_, (byte)30);
        }
        return flag;
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = p_70652_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        if (flag) {
            p_70652_1_.func_213317_d(p_70652_1_.func_213322_ci().func_72441_c(0.0, (double)0.6f, 0.0));
            this.func_174815_a((LivingEntity)this, p_70652_1_);
        }
        this.func_184185_a(SoundEvents.field_232714_fD_, this.func_70599_aP(), this.func_70647_i());
        return flag;
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(SLAM_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(CHARGE_TICKS, (Object)0);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        if (this.getSlamTicks() > 0) {
            this.setSlamTicks(this.getSlamTicks() - 1);
        }
    }

    public int getAttackTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TICKS);
    }

    public void setAttackTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ATTACK_TICKS, (Object)p_189794_1_);
    }

    public int getSlamTicks() {
        return (Integer)this.field_70180_af.func_187225_a(SLAM_TICKS);
    }

    public void setSlamTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(SLAM_TICKS, (Object)p_189794_1_);
    }

    public int getChargeTicks() {
        return (Integer)this.field_70180_af.func_187225_a(CHARGE_TICKS);
    }

    public void setChargeTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(CHARGE_TICKS, (Object)p_189794_1_);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233824_g_, 1.25).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233819_b_, 26.0).func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233823_f_, 10.0);
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.getChargeTicks() != 0 ? SoundEvents.field_232713_fC_ : SoundEvents.field_232712_fB_;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232716_fF_;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_232717_fG_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_232719_fI_;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(this.getStepSound(), 1.25f, 0.75f);
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.75f;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 1.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.field_70725_aQ > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_hoglin_death", Boolean.valueOf(false)));
        } else if (this.getChargeTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_hoglin_ready_charge", Boolean.valueOf(true)));
        } else if (this.getChargeTicks() < 0) {
            if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_hoglin_charge", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_hoglin_idle", Boolean.valueOf(true)));
            }
        } else if (this.getSlamTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_hoglin_smash", Boolean.valueOf(true)));
        } else if (this.getAttackTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_hoglin_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_hoglin_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_hoglin_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.func_213333_a(p_213333_1_, p_213333_2_, p_213333_3_);
        for (int i = 0; i < 15 + this.field_70146_Z.nextInt(15); ++i) {
            ItemEntity itementity = this.func_199703_a((IItemProvider)Items.field_151147_al);
            if (itementity == null) continue;
            itementity.func_174873_u();
        }
        ItemEntity itementity = this.func_199703_a((IItemProvider)ItemInit.MUTANT_HOGLIN_TUSK.get());
        if (itementity != null) {
            itementity.func_174873_u();
        }
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 40) {
            double d2;
            double d1;
            double d0;
            int i;
            this.func_70106_y();
            for (i = 0; i < 60; ++i) {
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
            for (i = 0; i < 60; ++i) {
                d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S() && this.func_70638_az() != null && this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            boolean flag = false;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(1.75);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)this.func_226278_cu_()), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (!(block.func_149638_a() < 6.0f)) continue;
                flag = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || flag;
            }
            if (!flag && this.field_70122_E) {
                this.func_70664_aZ();
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class ChargeGoal
    extends Goal {
        public ChargeGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantHoglinEntity.this.func_70638_az() != null && MutantHoglinEntity.this.getChargeTicks() == 0 && MutantHoglinEntity.this.field_70146_Z.nextInt(200) == 0;
        }

        public boolean func_75253_b() {
            return MutantHoglinEntity.this.func_70638_az() != null && MutantHoglinEntity.this.getChargeTicks() != 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantHoglinEntity.this.setChargeTicks(21);
            MutantHoglinEntity.this.func_184185_a(SoundEvents.field_232713_fC_, MutantHoglinEntity.this.func_70599_aP(), MutantHoglinEntity.this.func_70647_i());
        }

        public void func_75246_d() {
            MutantHoglinEntity mob = MutantHoglinEntity.this;
            if (mob.getChargeTicks() > 1) {
                mob.func_70661_as().func_75499_g();
                if (mob.getChargeTicks() > 0) {
                    mob.setChargeTicks(mob.getChargeTicks() - 1);
                }
            } else if (mob.getChargeTicks() == 1) {
                mob.func_70661_as().func_75497_a((Entity)mob.func_70638_az(), 2.0);
                mob.setChargeTicks(-1);
            } else if (mob.getChargeTicks() == -1 && mob.func_70661_as().func_75500_f()) {
                Advancement adv;
                if (mob.func_70638_az() instanceof ServerPlayerEntity && (OLE_ITEMS.test(mob.func_70638_az().func_184614_ca()) || OLE_ITEMS.test(mob.func_70638_az().func_184592_cb())) && !mob.failedOle && (adv = ServerLifecycleHooks.getCurrentServer().func_191949_aK().func_192778_a(new ResourceLocation("mutantmore:mutantmore/ole"))) != null) {
                    System.out.print(adv);
                    ((ServerPlayerEntity)mob.func_70638_az()).func_192039_O().func_192750_a(adv, "dodged");
                }
                this.func_75251_c();
                mob.setChargeTicks(0);
                mob.failedOle = false;
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantHoglinEntity mob = MutantHoglinEntity.this;
            MutantHoglinEntity.this.setChargeTicks(0);
            MutantHoglinEntity.this.failedOle = false;
        }
    }

    class SlamGoal
    extends Goal {
        public SlamGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantHoglinEntity.this.func_70638_az() != null && MutantHoglinEntity.this.func_70032_d((Entity)MutantHoglinEntity.this.func_70638_az()) <= 10.0f && MutantHoglinEntity.this.getSlamTicks() == 0 && MutantHoglinEntity.this.field_70146_Z.nextInt(50) == 0;
        }

        public boolean func_75253_b() {
            return MutantHoglinEntity.this.getSlamTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantHoglinEntity.this.setSlamTicks(50);
            MutantHoglinEntity.this.func_184185_a(SoundEvents.field_232714_fD_, MutantHoglinEntity.this.func_70599_aP(), MutantHoglinEntity.this.func_70647_i());
        }

        public void func_75246_d() {
            MutantHoglinEntity mob = MutantHoglinEntity.this;
            mob.func_70661_as().func_75499_g();
            if (mob.getSlamTicks() == 20) {
                mob.func_184185_a(SoundEvents.field_187539_bB, mob.func_70599_aP(), mob.func_70647_i());
                for (Entity entity : mob.field_70170_p.func_175647_a(LivingEntity.class, mob.func_174813_aQ().func_186662_g(7.5), GROUND_AND_ALIVE)) {
                    if (entity == MutantHoglinEntity.this) continue;
                    entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)mob), (float)mob.func_110148_a(Attributes.field_233823_f_).func_111126_e() * 2.0f);
                    entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, (double)0.6f, 0.0));
                }
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantHoglinEntity.this.setSlamTicks(0);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(MutantHoglinEntity p_i50577_2_) {
            super((CreatureEntity)p_i50577_2_, 1.0, false);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && MutantHoglinEntity.this.getChargeTicks() == 0;
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && MutantHoglinEntity.this.getChargeTicks() == 0;
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return this.field_75441_b.func_213311_cf() * 1.5f * this.field_75441_b.func_213311_cf() * 1.5f + p_179512_1_.func_213311_cf();
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 30 && MutantHoglinEntity.this.getAttackTicks() <= 0) {
                    MutantHoglinEntity.this.setAttackTicks(20);
                }
            } else {
                this.func_234039_g_();
            }
        }
    }
}

