/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.entities.SeismicWaveEntity;
import com.alexander.mutantmore.entities.ThrownBlockEntity;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.init.SoundEventInit;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MutantHuskEntity
extends MonsterEntity
implements IAnimatable {
    private static final Predicate<Entity> ALIVE = p_213685_0_ -> p_213685_0_.func_70089_S();
    public static final DataParameter<Integer> ATTACK_TICKS = EntityDataManager.func_187226_a(MutantHuskEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> THROW_MOB_TICKS = EntityDataManager.func_187226_a(MutantHuskEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> THROW_SAND_TICKS = EntityDataManager.func_187226_a(MutantHuskEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DOWN_TICKS = EntityDataManager.func_187226_a(MutantHuskEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> BURN_TICKS = EntityDataManager.func_187226_a(MutantHuskEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> ROAR_TICKS = EntityDataManager.func_187226_a(MutantHuskEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> REMAINING_LIVES = EntityDataManager.func_187226_a(MutantHuskEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int nextSlamTimer = 0;

    public MutantHuskEntity(EntityType<? extends MutantHuskEntity> p_i50189_1_, World p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.setRemainingLives(3);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new RoarGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ThrowMobGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new ThrowSandGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new SlamGroundGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(600));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true).func_190882_b(1200));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true).func_190882_b(600));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return p_70097_1_ instanceof EntityDamageSource && ((EntityDamageSource)p_70097_1_).func_76364_f() instanceof ZombieEntity ? false : super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public boolean func_184191_r(Entity p_184191_1_) {
        return p_184191_1_ instanceof ZombieEntity || super.func_184191_r(p_184191_1_);
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return this.getDownTicks() > 0 ? EntitySize.func_220314_b((float)3.0f, (float)2.75f) : super.func_213305_a(p_213305_1_);
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (DOWN_TICKS.equals(p_184206_1_)) {
            this.func_213323_x_();
            if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                this.func_71061_d_();
            }
        }
        super.func_184206_a(p_184206_1_);
    }

    public void func_174812_G() {
        this.setRemainingLives(0);
        super.func_174812_G();
    }

    protected void func_70609_aI() {
        if (this.getRemainingLives() > 0) {
            if (this.func_70027_ad()) {
                double d2;
                double d1;
                double d0;
                int i;
                this.setBurnTicks(this.getBurnTicks() + 1);
                for (i = 0; i < this.getBurnTicks() / 2; ++i) {
                    d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
                }
                if (this.getBurnTicks() == 60) {
                    for (i = 0; i < 40; ++i) {
                        d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
                    }
                    for (i = 0; i < 40; ++i) {
                        d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
                    }
                    this.func_199703_a((IItemProvider)ItemInit.EMPTY_CACTUS_JUG.get());
                    this.func_70106_y();
                }
            }
            this.setDownTicks(this.getDownTicks() + 1);
            if (this.getDownTicks() == 100) {
                this.func_70606_j(70 + this.field_70146_Z.nextInt(30));
                this.setRemainingLives(this.getRemainingLives() - 1);
                this.setDownTicks(0);
            }
        } else {
            ++this.field_70725_aQ;
            if (this.field_70725_aQ == 40) {
                for (int i = 0; i < 40; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
                }
                this.func_199703_a((IItemProvider)ItemInit.EMPTY_CACTUS_JUG.get());
                this.func_70106_y();
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(REMAINING_LIVES, (Object)3);
        this.field_70180_af.func_187214_a(ATTACK_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(THROW_MOB_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(THROW_SAND_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(DOWN_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(BURN_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(ROAR_TICKS, (Object)0);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("RemainingLives", this.getRemainingLives());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setRemainingLives(p_70037_1_.func_74762_e("RemainingLives"));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.nextSlamTimer > 0) {
            --this.nextSlamTimer;
        }
        if (this.getDownTicks() == 0) {
            this.setBurnTicks(0);
        }
        if (!this.field_70170_p.func_72935_r() && this.field_70173_aa % 100 == 0 && this.func_70089_S() && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(2.0f);
        }
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        if (this.getThrowSandTicks() > 0) {
            this.setThrowSandTicks(this.getThrowSandTicks() - 1);
        }
        if (this.getRoarTicks() > 0) {
            this.setRoarTicks(this.getRoarTicks() - 1);
        }
    }

    public int getAttackTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TICKS);
    }

    public void setAttackTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ATTACK_TICKS, (Object)p_189794_1_);
    }

    public int getThrowMobTicks() {
        return (Integer)this.field_70180_af.func_187225_a(THROW_MOB_TICKS);
    }

    public void setThrowMobTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(THROW_MOB_TICKS, (Object)p_189794_1_);
    }

    public int getThrowSandTicks() {
        return (Integer)this.field_70180_af.func_187225_a(THROW_SAND_TICKS);
    }

    public void setThrowSandTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(THROW_SAND_TICKS, (Object)p_189794_1_);
    }

    public int getDownTicks() {
        return (Integer)this.field_70180_af.func_187225_a(DOWN_TICKS);
    }

    public void setDownTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(DOWN_TICKS, (Object)p_189794_1_);
    }

    public int getBurnTicks() {
        return (Integer)this.field_70180_af.func_187225_a(BURN_TICKS);
    }

    public void setBurnTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(BURN_TICKS, (Object)p_189794_1_);
    }

    public int getRoarTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ROAR_TICKS);
    }

    public void setRoarTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ROAR_TICKS, (Object)p_189794_1_);
    }

    public int getRemainingLives() {
        return (Integer)this.field_70180_af.func_187225_a(REMAINING_LIVES);
    }

    public void setRemainingLives(int p_189794_1_) {
        this.field_70180_af.func_187227_b(REMAINING_LIVES, (Object)p_189794_1_);
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        if (!super.func_70652_k(p_70652_1_)) {
            return false;
        }
        if (p_70652_1_ instanceof LivingEntity) {
            ((LivingEntity)p_70652_1_).func_195064_c(new EffectInstance(Effects.field_76438_s, 200));
        }
        return true;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233823_f_, 8.0);
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    protected float func_70599_aP() {
        return 2.0f;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)SoundEventInit.MUTANT_HUSK_IDLE.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundEventInit.MUTANT_HUSK_HURT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return (SoundEvent)SoundEventInit.MUTANT_HUSK_HURT.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_190025_cL;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(this.getStepSound(), 0.5f, 0.5f);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.field_70725_aQ > 0 || this.getDownTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_down", Boolean.valueOf(true)));
        } else if (this.getRoarTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_roar", Boolean.valueOf(true)));
        } else if (this.getThrowMobTicks() < 15 && this.getThrowMobTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_throw_mob", Boolean.valueOf(true)));
        } else if (this.getThrowMobTicks() > 15 && this.getThrowMobTicks() <= 18) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_throwing_mob", Boolean.valueOf(true)));
        } else if (this.getThrowMobTicks() >= 19 && this.getThrowMobTicks() < 24) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_slam_mob", Boolean.valueOf(true)));
        } else if (this.getThrowMobTicks() == 24) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_slamming_mob", Boolean.valueOf(true)));
        } else if (this.getThrowSandTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_throw_sand", Boolean.valueOf(true)));
        } else if (this.getAttackTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_attack", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_husk_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void performRangedAttack(LivingEntity p_82196_1_, float p_82196_2_) {
        ThrownBlockEntity snowballentity = new ThrownBlockEntity(this.field_70170_p, (LivingEntity)this, Blocks.field_150354_m.func_176223_P(), new EffectInstance(Effects.field_76440_q, 100), 12.0f);
        double d0 = p_82196_1_.func_226278_cu_();
        double d1 = p_82196_1_.func_226277_ct_() - this.func_226277_ct_();
        double d2 = d0 - snowballentity.func_226278_cu_();
        double d3 = p_82196_1_.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        snowballentity.func_70186_c(d1, d2 + (double)f, d3, 1.6f, 1.0f);
        this.func_184185_a((SoundEvent)SoundEventInit.MUTANT_HUSK_THROW_SAND.get(), this.func_70599_aP(), this.func_70647_i());
        this.field_70170_p.func_217376_c((Entity)snowballentity);
    }

    private void strongKnockback(Entity p_213688_1_) {
        double d0 = p_213688_1_.func_226277_ct_() - this.func_226277_ct_();
        double d1 = p_213688_1_.func_226281_cx_() - this.func_226281_cx_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_213688_1_.func_70024_g(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    class RoarGoal
    extends Goal {
        public RoarGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantHuskEntity.this.func_70638_az() != null && MutantHuskEntity.this.getRoarTicks() == 0 && MutantHuskEntity.this.field_70146_Z.nextInt(MutantHuskEntity.this.getRemainingLives() <= 1 ? 300 : 1000) == 0;
        }

        public boolean func_75253_b() {
            return MutantHuskEntity.this.func_70638_az() != null && MutantHuskEntity.this.getRoarTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantHuskEntity.this.setRoarTicks(100);
        }

        public void func_75246_d() {
            MutantHuskEntity mob = MutantHuskEntity.this;
            LivingEntity livingentity = MutantHuskEntity.this.func_70638_az();
            double d0 = Math.min(livingentity.func_226278_cu_(), MutantHuskEntity.this.func_226278_cu_());
            double d1 = Math.max(livingentity.func_226278_cu_(), MutantHuskEntity.this.func_226278_cu_()) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(livingentity.func_226281_cx_() - MutantHuskEntity.this.func_226281_cx_()), (double)(livingentity.func_226277_ct_() - MutantHuskEntity.this.func_226277_ct_()));
            mob.func_70661_as().func_75499_g();
            if (mob.getRoarTicks() == 80) {
                for (Entity entity : MutantHuskEntity.this.field_70170_p.func_175647_a(LivingEntity.class, MutantHuskEntity.this.func_174813_aQ().func_186662_g(20.0), ALIVE)) {
                    if (entity != MutantHuskEntity.this && !(entity instanceof ZombieEntity)) {
                        entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)MutantHuskEntity.this), 6.0f);
                        if (entity instanceof LivingEntity) {
                            if ((double)mob.func_70032_d(entity) < 7.5) {
                                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76438_s, 300, 1));
                                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 1));
                            }
                            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1));
                        }
                    }
                    MutantHuskEntity.this.strongKnockback(entity);
                }
                mob.func_184185_a((SoundEvent)SoundEventInit.MUTANT_HUSK_ROAR.get(), mob.func_70599_aP() * 3.0f, mob.func_70647_i());
                for (int l = 0; l < 3 + MutantHuskEntity.this.field_70146_Z.nextInt(7); ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = l * 2;
                    this.createSeismicWave(MutantHuskEntity.this.func_226277_ct_() - 15.0 + (double)MutantHuskEntity.this.field_70146_Z.nextInt(30), MutantHuskEntity.this.func_226281_cx_() - 15.0 + (double)MutantHuskEntity.this.field_70146_Z.nextInt(30), d0, d1, f, 100 + MutantHuskEntity.this.field_70146_Z.nextInt(100));
                }
            }
        }

        private void createSeismicWave(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = MutantHuskEntity.this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)MutantHuskEntity.this.field_70170_p, blockpos1, Direction.UP)) continue;
                if (!MutantHuskEntity.this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = MutantHuskEntity.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)MutantHuskEntity.this.field_70170_p, blockpos)).func_197766_b()) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                MutantHuskEntity.this.field_70170_p.func_217376_c((Entity)new SeismicWaveEntity(MutantHuskEntity.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)MutantHuskEntity.this, SeismicWaveEntity.WaveType.SUMMON_HUSK));
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantHuskEntity.this.setRoarTicks(0);
        }
    }

    class ThrowSandGoal
    extends Goal {
        public ThrowSandGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantHuskEntity.this.func_70638_az() != null && MutantHuskEntity.this.func_70032_d((Entity)MutantHuskEntity.this.func_70638_az()) >= 10.0f && MutantHuskEntity.this.getThrowSandTicks() == 0 && MutantHuskEntity.this.field_70146_Z.nextInt(100) == 0;
        }

        public boolean func_75253_b() {
            return MutantHuskEntity.this.func_70638_az() != null && MutantHuskEntity.this.getThrowSandTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantHuskEntity.this.setThrowSandTicks(50);
            MutantHuskEntity.this.func_184185_a((SoundEvent)SoundEventInit.MUTANT_HUSK_ATTACK.get(), MutantHuskEntity.this.func_70599_aP(), MutantHuskEntity.this.func_70647_i());
        }

        public void func_75246_d() {
            MutantHuskEntity mob = MutantHuskEntity.this;
            mob.func_70661_as().func_75499_g();
            if (mob.getThrowSandTicks() == 25) {
                mob.performRangedAttack(mob.func_70638_az(), 20.0f);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantHuskEntity.this.setThrowSandTicks(0);
        }
    }

    class SlamGroundGoal
    extends Goal {
        private final EntityPredicate vexCountTargeting = new EntityPredicate().func_221013_a(50.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();

        public SlamGroundGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantHuskEntity.this.func_70638_az() != null && MutantHuskEntity.this.func_70032_d((Entity)MutantHuskEntity.this.func_70638_az()) < 9.0f && MutantHuskEntity.this.getAttackTicks() == 0 && MutantHuskEntity.this.nextSlamTimer <= 0;
        }

        public boolean func_75253_b() {
            return MutantHuskEntity.this.func_70638_az() != null && MutantHuskEntity.this.getAttackTicks() > 0;
        }

        public void func_75249_e() {
            if (MutantHuskEntity.this.field_70146_Z.nextInt(7) != 0) {
                MutantHuskEntity.this.setAttackTicks(40);
                MutantHuskEntity.this.func_184185_a((SoundEvent)SoundEventInit.MUTANT_HUSK_ATTACK.get(), MutantHuskEntity.this.func_70599_aP(), MutantHuskEntity.this.func_70647_i());
            } else {
                MutantHuskEntity.this.nextSlamTimer = 60;
                this.func_75251_c();
            }
        }

        public void func_75246_d() {
            LivingEntity livingentity = MutantHuskEntity.this.func_70638_az();
            double d0 = Math.min(livingentity.func_226278_cu_(), MutantHuskEntity.this.func_226278_cu_());
            double d1 = Math.max(livingentity.func_226278_cu_(), MutantHuskEntity.this.func_226278_cu_()) + 1.0;
            float f = (float)MathHelper.func_181159_b((double)(livingentity.func_226281_cx_() - MutantHuskEntity.this.func_226281_cx_()), (double)(livingentity.func_226277_ct_() - MutantHuskEntity.this.func_226277_ct_()));
            MutantHuskEntity.this.func_70661_as().func_75499_g();
            MutantHuskEntity.this.field_70749_g.func_75651_a((Entity)livingentity, 30.0f, 30.0f);
            if (MutantHuskEntity.this.getAttackTicks() == 12) {
                for (int l = 0; l < 16; ++l) {
                    double d2 = 1.25 * (double)(l + 1);
                    int j = l * 2;
                    this.createSeismicWave(MutantHuskEntity.this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)f) * d2, MutantHuskEntity.this.func_226281_cx_() + (double)MathHelper.func_76126_a((float)f) * d2, d0, d1, f, j);
                }
                MutantHuskEntity.this.field_70170_p.func_184148_a(null, MutantHuskEntity.this.func_226277_ct_(), MutantHuskEntity.this.func_226278_cu_(), MutantHuskEntity.this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, 0.8f + MutantHuskEntity.this.field_70146_Z.nextFloat() * 0.4f);
            }
        }

        private void createSeismicWave(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
            BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = MutantHuskEntity.this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)MutantHuskEntity.this.field_70170_p, blockpos1, Direction.UP)) continue;
                if (!MutantHuskEntity.this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = MutantHuskEntity.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)MutantHuskEntity.this.field_70170_p, blockpos)).func_197766_b()) {
                    d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)p_190876_5_) - 1);
            if (flag) {
                MutantHuskEntity.this.field_70170_p.func_217376_c((Entity)new SeismicWaveEntity(MutantHuskEntity.this.field_70170_p, p_190876_1_, (double)blockpos.func_177956_o() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)MutantHuskEntity.this, SeismicWaveEntity.WaveType.HUSK));
            }
        }

        public void func_75251_c() {
            MutantHuskEntity.this.setAttackTicks(0);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(MutantHuskEntity p_i50577_2_) {
            super((CreatureEntity)p_i50577_2_, 1.0, false);
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return this.field_75441_b.func_213311_cf() * 1.0f * this.field_75441_b.func_213311_cf() * 1.0f + p_179512_1_.func_213311_cf();
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            this.func_234039_g_();
        }
    }

    class ThrowMobGoal
    extends Goal {
        public ThrowMobGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantHuskEntity.this.func_70638_az() != null && MutantHuskEntity.this.func_70032_d((Entity)MutantHuskEntity.this.func_70638_az()) <= 5.0f && MutantHuskEntity.this.getThrowMobTicks() == 0 && (MutantHuskEntity.this.field_70146_Z.nextInt(100) == 0 || MutantHuskEntity.this.nextSlamTimer > 0);
        }

        public boolean func_75253_b() {
            return MutantHuskEntity.this.func_70638_az() != null && MutantHuskEntity.this.getThrowMobTicks() > 0;
        }

        public void func_75246_d() {
            MutantHuskEntity mob = MutantHuskEntity.this;
            LivingEntity target = MutantHuskEntity.this.func_70638_az();
            System.out.print("\r\n" + mob.getThrowMobTicks());
            mob.func_70661_as().func_75499_g();
            if (mob.getThrowMobTicks() < 18) {
                mob.field_70749_g.func_220679_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                mob.setThrowMobTicks(mob.getThrowMobTicks() + 1);
                if (mob.getThrowMobTicks() == 6 && mob.func_70032_d((Entity)MutantHuskEntity.this.func_70638_az()) <= 5.0f) {
                    mob.func_184185_a((SoundEvent)SoundEventInit.MUTANT_HUSK_ATTACK.get(), mob.func_70599_aP(), mob.func_70647_i());
                    double d0 = target.func_226277_ct_() - mob.func_226277_ct_();
                    double d1 = target.func_226281_cx_() - mob.func_226281_cx_();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    target.field_70133_I = true;
                    target.func_213317_d(target.func_213322_ci().func_72441_c(d0 / d2, 0.75, d1 / d2).func_186678_a(2.5));
                } else if (mob.getThrowMobTicks() == 17) {
                    Vector3d vector3d = new Vector3d(target.func_226277_ct_() - mob.func_226277_ct_(), 1.25 + (target.func_226278_cu_() - mob.func_226278_cu_()), target.func_226281_cx_() - mob.func_226281_cx_()).func_186678_a(0.125);
                    mob.func_213317_d(vector3d);
                }
            } else if (mob.getThrowMobTicks() == 18 && (double)mob.func_70032_d((Entity)target) < 3.5 && mob.func_70032_d((Entity)MutantHuskEntity.this.func_70638_az()) <= 6.0f) {
                Advancement adv = ServerLifecycleHooks.getCurrentServer().func_191949_aK().func_192778_a(new ResourceLocation("mutantmore:mutantmore/husk_smash"));
                if (target instanceof ServerPlayerEntity && adv != null) {
                    System.out.print(adv);
                    ((ServerPlayerEntity)target).func_192039_O().func_192750_a(adv, "smashed");
                }
                mob.func_184185_a((SoundEvent)SoundEventInit.MUTANT_HUSK_GRUNT.get(), mob.func_70599_aP(), mob.func_70647_i());
                mob.setThrowMobTicks(19);
                double d0 = target.func_226277_ct_() - mob.func_226277_ct_();
                double d1 = target.func_226281_cx_() - mob.func_226281_cx_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                mob.func_70652_k((Entity)target);
                if (target instanceof PlayerEntity && target.func_184585_cz()) {
                    ((PlayerEntity)target).func_184811_cZ().func_185145_a(target.func_184607_cu().func_77973_b(), 120);
                    target.func_184602_cy();
                    target.field_70170_p.func_72960_a((Entity)target, (byte)30);
                }
                target.field_70133_I = true;
                target.func_70024_g(d0 / d2 * 2.0, -1.0, d1 / d2 * 2.0);
            } else if (mob.getThrowMobTicks() >= 19 && mob.getThrowMobTicks() < 24) {
                mob.setThrowMobTicks(mob.getThrowMobTicks() + 1);
            } else if (mob.getThrowMobTicks() >= 24 && mob.func_233570_aj_()) {
                mob.setThrowMobTicks(0);
                this.func_75251_c();
            }
            if (mob.getThrowMobTicks() >= 18 && mob.func_233570_aj_()) {
                mob.setThrowMobTicks(0);
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantHuskEntity.this.setThrowMobTicks(0);
        }
    }
}

