/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.init.ItemInit;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MutantShulkerBoxEntity
extends CreatureEntity
implements IAnimatable {
    public static final DataParameter<Integer> OPEN_TICKS = EntityDataManager.func_187226_a(MutantShulkerBoxEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(MutantShulkerBoxEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final EntityPredicate vexCountTargeting = new EntityPredicate().func_221013_a(50.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public LivingEntity entityToFollow = null;
    public int trapCooldown = 0;

    public MutantShulkerBoxEntity(EntityType<? extends MutantShulkerBoxEntity> p_i50210_1_, World p_i50210_2_) {
        super(p_i50210_1_, p_i50210_2_);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.isFlying() && this.entityToFollow != null) {
            Vector3d vector3d = new Vector3d(this.entityToFollow.func_226277_ct_() - this.func_226277_ct_(), 10.0 + (this.entityToFollow.func_226278_cu_() - this.func_226278_cu_()), this.entityToFollow.func_226281_cx_() - this.func_226281_cx_()).func_186678_a((double)0.05f);
            this.func_213317_d(vector3d);
            if (this.func_226278_cu_() < this.entityToFollow.func_226278_cu_() + 2.0) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.25, 0.0));
            } else if (this.func_226278_cu_() > this.entityToFollow.func_226278_cu_() + 2.0) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.25, 0.0));
            }
        }
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof LivingEntity)) continue;
            ((LivingEntity)passenger).func_195064_c(new EffectInstance(Effects.field_76429_m, 3, 255, false, false));
        }
        if (this.getOpenTicks() == 1) {
            this.func_184185_a(SoundEvents.field_191262_fB, 1.0f, 1.0f);
        }
        for (LivingEntity capturedMob : this.field_70170_p.func_217374_a(LivingEntity.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_72314_b(5.0, 0.0, 5.0))) {
            if (!(capturedMob instanceof PlayerEntity) && capturedMob != null && this.func_184188_bt().size() <= 0 && (double)capturedMob.func_213305_a((Pose)this.func_213283_Z()).field_220315_a < 1.25 && (double)capturedMob.func_213305_a((Pose)this.func_213283_Z()).field_220316_b < 2.25) {
                if (capturedMob == this.field_70170_p.func_217374_a(LivingEntity.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_72314_b(5.0, 0.0, 5.0)).get(0) && this.getOpenTicks() < 20) {
                    this.setOpenTicks(this.getOpenTicks() + 1);
                }
                if (this.trapCooldown > 0 || !((double)this.func_70032_d((Entity)capturedMob) <= 2.5) || capturedMob.func_213453_ef() || capturedMob.func_184218_aH()) continue;
                capturedMob.func_184220_m((Entity)this);
                this.func_184185_a(SoundEvents.field_187789_eW, 1.0f, 1.0f);
                continue;
            }
            if (capturedMob != this.field_70170_p.func_217374_a(LivingEntity.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_72314_b(5.0, 0.0, 5.0)).get(0) || this.func_184188_bt().size() <= 0) continue;
            this.trapCooldown = 60;
            if (this.getOpenTicks() > 0) {
                this.setOpenTicks(-10);
                this.func_184185_a(SoundEvents.field_191261_fA, 1.0f, 1.0f);
                continue;
            }
            if (this.getOpenTicks() >= 0) continue;
            this.setOpenTicks(this.getOpenTicks() + 1);
        }
        if (this.trapCooldown > 0) {
            --this.trapCooldown;
        }
        if (this.field_70170_p.func_217374_a(LivingEntity.class, this.vexCountTargeting, (LivingEntity)this, this.func_174813_aQ().func_72314_b(5.0, 0.0, 5.0)).size() == 0 && this.getOpenTicks() > 0) {
            this.setOpenTicks(-10);
            this.func_184185_a(SoundEvents.field_191261_fA, 1.0f, 1.0f);
        }
        if (this.getOpenTicks() < 0) {
            this.setOpenTicks(this.getOpenTicks() + 1);
        }
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        this.func_184185_a(SoundEvents.field_187785_eU, 1.0f, 1.0f);
        return false;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public void func_70108_f(Entity p_70108_1_) {
        super.func_70108_f(p_70108_1_);
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        if (!p_230254_1_.func_213453_ef() && p_230254_1_.func_184586_b(p_230254_2_).func_190926_b() && this.func_184188_bt().size() > 0) {
            this.entityToFollow = !this.isFlying() ? p_230254_1_ : null;
            this.func_184185_a(SoundEvents.field_191262_fB, 1.0f, 1.0f);
            this.setFlying(!this.isFlying());
            return ActionResultType.SUCCESS;
        }
        if (p_230254_1_.func_213453_ef() && p_230254_1_.func_184586_b(p_230254_2_).func_190926_b()) {
            this.func_70106_y();
            if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                this.func_184185_a(SoundEvents.field_191261_fA, 1.0f, 1.0f);
                ItemStack itemstack = new ItemStack((IItemProvider)ItemInit.MUTANT_SHULKER_BOX.get());
                if (this.func_145818_k_()) {
                    itemstack.func_200302_a(this.func_200201_e());
                }
                this.func_199701_a_(itemstack);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187785_eU;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187785_eU;
    }

    protected int func_70682_h(int p_70682_1_) {
        return p_70682_1_;
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70623_bb() {
    }

    protected boolean func_225511_J_() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OPEN_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74757_a("Flying", this.isFlying());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setFlying(p_70037_1_.func_74767_n("Flying"));
    }

    public int getOpenTicks() {
        return (Integer)this.field_70180_af.func_187225_a(OPEN_TICKS);
    }

    public void setOpenTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(OPEN_TICKS, (Object)p_189794_1_);
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean p_189794_1_) {
        this.field_70180_af.func_187227_b(FLYING, (Object)p_189794_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.isFlying()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_box_fly", Boolean.valueOf(true)));
        } else if (this.getOpenTicks() > 0 && this.getOpenTicks() < 20) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_box_open", Boolean.valueOf(true)));
        } else if (this.getOpenTicks() >= 20) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_box_open_idle", Boolean.valueOf(true)));
        } else if (this.getOpenTicks() < 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_box_close", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_box_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 0.1).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233819_b_, 0.0);
    }
}

