/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.init.DamageSourceInit;
import com.alexander.mutantmore.init.ItemInit;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class MutantShulkerEntity
extends MonsterEntity
implements IAnimatable {
    public static final DataParameter<Integer> ATTACK_TICKS = EntityDataManager.func_187226_a(MutantShulkerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SHOOT_TICKS = EntityDataManager.func_187226_a(MutantShulkerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> PEEK_TICKS = EntityDataManager.func_187226_a(MutantShulkerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> OUT_TICKS = EntityDataManager.func_187226_a(MutantShulkerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SPIN_TICKS = EntityDataManager.func_187226_a(MutantShulkerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> TELEPORT_TICKS = EntityDataManager.func_187226_a(MutantShulkerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int knockKnockCount = 0;
    public int knockKnockRefreshTicks = 0;
    public boolean killed = false;

    public MutantShulkerEntity(EntityType<? extends MutantShulkerEntity> p_i50189_1_, World p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.field_70138_W = 1.0f;
    }

    public void func_174812_G() {
        super.func_174812_G();
        this.killed = true;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SpinGoal());
        this.field_70714_bg.func_75776_a(0, (Goal)new EmergeGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnvilCrushGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new ShootGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new PeekGoal());
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true){

            public boolean func_75250_a() {
                return super.func_75250_a() && (MutantShulkerEntity.this.isPeeking() || !MutantShulkerEntity.this.isClosed());
            }
        });
    }

    public void func_70624_b(LivingEntity p_70624_1_) {
        if (p_70624_1_ == null) {
            this.setOutTicks(0);
        }
        super.func_70624_b(p_70624_1_);
    }

    public boolean func_70687_e(EffectInstance p_70687_1_) {
        return p_70687_1_.func_188419_a() == Effects.field_188424_y ? false : super.func_70687_e(p_70687_1_);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (!this.killed && this.isClosed() && !this.isPeeking()) {
            if (p_70097_1_ instanceof EntityDamageSource && ((EntityDamageSource)p_70097_1_).func_76364_f() instanceof ServerPlayerEntity) {
                ++this.knockKnockCount;
                this.knockKnockRefreshTicks = 40;
                Advancement adv = ServerLifecycleHooks.getCurrentServer().func_191949_aK().func_192778_a(new ResourceLocation("mutantmore:mutantmore/knock_knock"));
                if (adv != null && this.knockKnockCount >= 5) {
                    System.out.print(adv);
                    ((ServerPlayerEntity)((EntityDamageSource)p_70097_1_).func_76364_f()).func_192039_O().func_192750_a(adv, "knocked");
                }
            }
            this.func_184185_a(SoundEvents.field_187785_eU, this.func_70599_aP(), this.func_70647_i());
            return false;
        }
        if (p_70097_1_ instanceof IndirectEntityDamageSource && ((IndirectEntityDamageSource)p_70097_1_).func_76346_g() == this) {
            return false;
        }
        if (this.isPeeking() && !this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(5) == 0) {
            this.setOutTicks(16);
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public boolean func_241845_aY() {
        return this.isClosed();
    }

    public boolean func_70104_M() {
        return !this.isClosed();
    }

    public boolean hasEmerged() {
        return this.getOutTicks() == 1;
    }

    public boolean isClosed() {
        return this.getOutTicks() <= 0;
    }

    public boolean isPeeking() {
        return this.getPeekTicks() > 0 || this.getTeleportTicks() > 0 || this.getShootTicks() > 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACK_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(PEEK_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(SHOOT_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(OUT_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(SPIN_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(TELEPORT_TICKS, (Object)0);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.isClosed() && !this.isPeeking() && this.field_70173_aa % 20 == 0) {
            this.func_70691_i(2.0f);
        }
        if (this.killed) {
            this.func_174812_G();
        }
        if (this.knockKnockRefreshTicks > 0) {
            --this.knockKnockRefreshTicks;
        }
        if (this.knockKnockRefreshTicks == 0 && this.knockKnockCount > 0) {
            this.knockKnockCount = 0;
        }
        System.out.print("\r\n" + this.getOutTicks());
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && !this.hasEmerged() && this.field_70146_Z.nextInt(500) == 0) {
            this.setOutTicks(16);
        }
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        if (this.getPeekTicks() > 0) {
            this.setPeekTicks(this.getPeekTicks() - 1);
        }
        if (this.getShootTicks() > 0) {
            this.setShootTicks(this.getShootTicks() - 1);
        }
        if (this.getTeleportTicks() > 0) {
            this.setTeleportTicks(this.getTeleportTicks() - 1);
        }
    }

    public int getAttackTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_TICKS);
    }

    public void setAttackTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(ATTACK_TICKS, (Object)p_189794_1_);
    }

    public int getPeekTicks() {
        return (Integer)this.field_70180_af.func_187225_a(PEEK_TICKS);
    }

    public void setPeekTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(PEEK_TICKS, (Object)p_189794_1_);
    }

    public int getShootTicks() {
        return (Integer)this.field_70180_af.func_187225_a(SHOOT_TICKS);
    }

    public void setShootTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(SHOOT_TICKS, (Object)p_189794_1_);
    }

    public int getOutTicks() {
        return (Integer)this.field_70180_af.func_187225_a(OUT_TICKS);
    }

    public void setOutTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(OUT_TICKS, (Object)p_189794_1_);
    }

    public int getSpinTicks() {
        return (Integer)this.field_70180_af.func_187225_a(SPIN_TICKS);
    }

    public void setSpinTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(SPIN_TICKS, (Object)p_189794_1_);
    }

    public int getTeleportTicks() {
        return (Integer)this.field_70180_af.func_187225_a(TELEPORT_TICKS);
    }

    public void setTeleportTicks(int p_189794_1_) {
        this.field_70180_af.func_187227_b(TELEPORT_TICKS, (Object)p_189794_1_);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233823_f_, 18.0);
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        int i = MathHelper.func_76123_f((float)(p_225503_1_ - 1.0f));
        if (i > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            for (Entity entity : list) {
                entity.func_70097_a(DamageSourceInit.fallingMob((LivingEntity)this, (Entity)this), (float)Math.min(MathHelper.func_76141_d((float)((float)i * 6.0f)), 40));
            }
        }
        return false;
    }

    protected float func_70647_i() {
        return super.func_70647_i() / 1.25f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187773_eO;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187781_eS;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187783_eT;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187775_eP;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(this.getStepSound(), 0.15f, 0.75f);
    }

    public int func_70641_bl() {
        return 1;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (this.field_70725_aQ > 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_idle", Boolean.valueOf(true)));
        } else if (this.getOutTicks() > 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_out", Boolean.valueOf(true)));
        } else if (this.getSpinTicks() > 11) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_ready_spin", Boolean.valueOf(true)));
        } else if (this.getSpinTicks() == 11) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_spin", Boolean.valueOf(true)));
        } else if (this.getSpinTicks() < 11 && this.getSpinTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_in", Boolean.valueOf(true)));
        } else if (this.getAttackTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_bite", Boolean.valueOf(true)));
        } else if (this.getTeleportTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_teleport", Boolean.valueOf(true)));
        } else if (this.getShootTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_shoot", Boolean.valueOf(true)));
        } else if (this.getPeekTicks() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_peek", Boolean.valueOf(true)));
        } else if (this.hasEmerged()) {
            if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_walk", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_out_idle", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_shulker_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 60) {
            this.func_199703_a((IItemProvider)ItemInit.MUTANT_SHULKER_BOX.get());
            this.func_70106_y();
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected boolean teleport() {
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
            double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vector3d vector3d = new Vector3d(this.func_226277_ct_() - p_70816_1_.func_226277_ct_(), this.func_226283_e_(0.5) - p_70816_1_.func_226280_cw_(), this.func_226281_cx_() - p_70816_1_.func_226281_cx_());
        vector3d = vector3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72450_a * 16.0;
        double d2 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(16) - 8) - vector3d.field_72448_b * 16.0;
        double d3 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vector3d.field_72449_c * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.func_174814_R()) {
                this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187791_eX, this.func_184176_by(), 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187791_eX, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    class AnvilCrushGoal
    extends Goal {
        public AnvilCrushGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantShulkerEntity.this.func_70638_az() != null && MutantShulkerEntity.this.getTeleportTicks() == 0 && MutantShulkerEntity.this.field_70146_Z.nextInt(MutantShulkerEntity.this.isClosed() ? 100 : 300) == 0;
        }

        public boolean func_75253_b() {
            return MutantShulkerEntity.this.func_70638_az() != null && (MutantShulkerEntity.this.getTeleportTicks() > 0 || MutantShulkerEntity.this.func_233570_aj_());
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantShulkerEntity.this.setTeleportTicks(20);
            MutantShulkerEntity.this.func_184185_a(SoundEvents.field_187791_eX, MutantShulkerEntity.this.func_70599_aP(), MutantShulkerEntity.this.func_70647_i());
        }

        public void func_75246_d() {
            MutantShulkerEntity mob = MutantShulkerEntity.this;
            mob.func_70661_as().func_75499_g();
            if (mob.getTeleportTicks() == 10) {
                mob.func_70634_a(mob.func_70638_az().func_226277_ct_(), mob.func_70638_az().func_226278_cu_() + 5.0, mob.func_70638_az().func_226281_cx_());
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantShulkerEntity.this.setTeleportTicks(0);
            MutantShulkerEntity.this.setOutTicks(0);
        }
    }

    class SpinGoal
    extends Goal {
        private final EntityPredicate targeting = new EntityPredicate().func_221013_a(50.0).func_221014_c().func_221010_e().func_221008_a().func_221011_b();

        public SpinGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantShulkerEntity.this.func_70638_az() != null && MutantShulkerEntity.this.hasEmerged() && MutantShulkerEntity.this.getSpinTicks() == 0 && MutantShulkerEntity.this.field_70146_Z.nextInt(300) == 0;
        }

        public boolean func_75253_b() {
            return MutantShulkerEntity.this.func_70638_az() != null && MutantShulkerEntity.this.hasEmerged() && MutantShulkerEntity.this.getSpinTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantShulkerEntity.this.setSpinTicks(41);
        }

        public void func_75246_d() {
            MutantShulkerEntity mob = MutantShulkerEntity.this;
            LivingEntity target = MutantShulkerEntity.this.func_70638_az();
            mob.func_70671_ap().func_220679_a(target.func_226277_ct_(), target.func_226280_cw_(), target.func_226281_cx_());
            mob.func_70661_as().func_75499_g();
            if (mob.getSpinTicks() > 11) {
                mob.setSpinTicks(mob.getSpinTicks() - 1);
                if (mob.getSpinTicks() == 26) {
                    mob.func_213317_d(mob.func_213322_ci().func_72441_c(0.0, 1.0, 0.0));
                }
            } else if (mob.getSpinTicks() == 11) {
                List mobs;
                Vector3d vector3d = new Vector3d(target.func_226277_ct_() - mob.func_226277_ct_(), 10.0 + (target.func_226278_cu_() - mob.func_226278_cu_()), target.func_226281_cx_() - mob.func_226281_cx_()).func_186678_a((double)0.025f);
                mob.func_213317_d(vector3d);
                if (mob.func_226278_cu_() < target.func_226278_cu_() + 7.0) {
                    mob.func_213317_d(mob.func_213322_ci().func_72441_c(0.0, 0.75, 0.0));
                } else if (mob.func_226278_cu_() > target.func_226278_cu_() + 7.0) {
                    mob.func_213317_d(mob.func_213322_ci().func_72441_c(0.0, -0.75, 0.0));
                }
                if (mob.field_70146_Z.nextBoolean() && (mobs = mob.field_70170_p.func_217374_a(LivingEntity.class, this.targeting, (LivingEntity)mob, mob.func_174813_aQ().func_186662_g(25.0))).size() > 0) {
                    mob.field_70170_p.func_217376_c((Entity)new ShulkerBulletEntity(mob.field_70170_p, (LivingEntity)mob, (Entity)mobs.get(mob.field_70146_Z.nextInt(mobs.size())), Direction.Axis.func_239634_a_((Random)mob.field_70146_Z)));
                }
                if (mob.field_70146_Z.nextInt(200) == 0) {
                    mob.setSpinTicks(10);
                }
            } else if (mob.getSpinTicks() < 11 && mob.getSpinTicks() > 0) {
                mob.setSpinTicks(mob.getSpinTicks() - 1);
            } else if (mob.getSpinTicks() == 0) {
                mob.setOutTicks(0);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantShulkerEntity.this.setSpinTicks(0);
            MutantShulkerEntity.this.setOutTicks(0);
        }
    }

    class EmergeGoal
    extends Goal {
        public EmergeGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantShulkerEntity.this.getOutTicks() == 16;
        }

        public boolean func_75253_b() {
            return MutantShulkerEntity.this.getOutTicks() > 1;
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public void func_75246_d() {
            MutantShulkerEntity mob = MutantShulkerEntity.this;
            mob.func_70661_as().func_75499_g();
            if (mob.getOutTicks() > 1) {
                mob.setOutTicks(mob.getOutTicks() - 1);
            }
            if (mob.getOutTicks() == 5) {
                mob.func_184185_a(SoundEvents.field_187787_eV, mob.func_70599_aP(), mob.func_70647_i());
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    class PeekGoal
    extends Goal {
        public PeekGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantShulkerEntity.this.isClosed() && MutantShulkerEntity.this.getPeekTicks() == 0 && (MutantShulkerEntity.this.field_70146_Z.nextInt(150) == 0 || MutantShulkerEntity.this.knockKnockCount >= 5);
        }

        public boolean func_75253_b() {
            return MutantShulkerEntity.this.isClosed() && MutantShulkerEntity.this.getPeekTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantShulkerEntity.this.setPeekTicks(30);
        }

        public void func_75246_d() {
            MutantShulkerEntity mob = MutantShulkerEntity.this;
            mob.func_70661_as().func_75499_g();
            if (mob.getPeekTicks() == 27) {
                mob.func_184185_a(SoundEvents.field_187787_eV, mob.func_70599_aP(), mob.func_70647_i());
            } else if (mob.getPeekTicks() == 7) {
                mob.func_184185_a(SoundEvents.field_187779_eR, mob.func_70599_aP(), mob.func_70647_i());
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantShulkerEntity.this.setPeekTicks(0);
        }
    }

    class ShootGoal
    extends Goal {
        public ShootGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return MutantShulkerEntity.this.func_70638_az() != null && MutantShulkerEntity.this.isClosed() && MutantShulkerEntity.this.getShootTicks() == 0 && MutantShulkerEntity.this.field_70146_Z.nextInt(50) == 0;
        }

        public boolean func_75253_b() {
            return MutantShulkerEntity.this.func_70638_az() != null && MutantShulkerEntity.this.isClosed() && MutantShulkerEntity.this.getShootTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            MutantShulkerEntity.this.setShootTicks(20);
        }

        public void func_75246_d() {
            MutantShulkerEntity mob = MutantShulkerEntity.this;
            mob.func_70661_as().func_75499_g();
            if (mob.getShootTicks() == 18) {
                mob.func_184185_a(SoundEvents.field_187787_eV, mob.func_70599_aP(), mob.func_70647_i());
            } else if (mob.getShootTicks() == 15) {
                mob.func_184185_a(SoundEvents.field_187789_eW, mob.func_70599_aP(), mob.func_70647_i());
                mob.field_70170_p.func_217376_c((Entity)new ShulkerBulletEntity(mob.field_70170_p, (LivingEntity)mob, (Entity)mob.func_70638_az(), Direction.Axis.func_239634_a_((Random)mob.field_70146_Z)));
            } else if (mob.getShootTicks() == 8) {
                mob.func_184185_a(SoundEvents.field_187779_eR, mob.func_70599_aP(), mob.func_70647_i());
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            MutantShulkerEntity.this.setPeekTicks(0);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(MutantShulkerEntity p_i50577_2_) {
            super((CreatureEntity)p_i50577_2_, 1.0, false);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && MutantShulkerEntity.this.hasEmerged();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && MutantShulkerEntity.this.hasEmerged();
        }

        protected double func_179512_a(LivingEntity p_179512_1_) {
            return this.field_75441_b.func_213311_cf() * 2.0f * this.field_75441_b.func_213311_cf() * 2.0f + p_179512_1_.func_213311_cf();
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            double d0 = this.func_179512_a(p_190102_1_);
            if (p_190102_2_ <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)p_190102_1_);
            } else if (p_190102_2_ <= d0 * 1.5) {
                if (this.func_234040_h_()) {
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 30 && MutantShulkerEntity.this.getAttackTicks() <= 0) {
                    MutantShulkerEntity.this.setAttackTicks(20);
                    MutantShulkerEntity.this.func_184185_a(SoundEvents.field_191242_bl, MutantShulkerEntity.this.func_70599_aP(), MutantShulkerEntity.this.func_70647_i());
                }
            } else {
                this.func_234039_g_();
            }
        }
    }
}

