/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.init.EntityTypeInit;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class SeismicWaveEntity
extends Entity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 2;
    private boolean clientSideAttackStarted;
    private LivingEntity owner;
    private UUID ownerUUID;
    private WaveType waveType = WaveType.ZOMBIE;

    public SeismicWaveEntity(EntityType<? extends SeismicWaveEntity> p_i50170_1_, World p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    protected SeismicWaveEntity(World p_i47276_1_, double p_i47276_2_, double p_i47276_4_, double p_i47276_6_, float p_i47276_8_, int p_i47276_9_, LivingEntity p_i47276_10_, WaveType waveType) {
        this((EntityType<? extends SeismicWaveEntity>)((EntityType)EntityTypeInit.SEISMIC_WAVE.get()), p_i47276_1_);
        this.warmupDelayTicks = p_i47276_9_;
        this.waveType = waveType;
        this.setOwner(p_i47276_10_);
        this.field_70177_z = p_i47276_8_ * 57.295776f;
        this.func_70107_b(p_i47276_2_, p_i47276_4_, p_i47276_6_);
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return this.waveType == WaveType.HUSK ? EntitySize.func_220314_b((float)3.0f, (float)0.2f) : super.func_213305_a(p_213305_1_);
    }

    protected void func_70088_a() {
    }

    public void setOwner(@Nullable LivingEntity p_190549_1_) {
        this.owner = p_190549_1_;
        this.ownerUUID = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void func_70037_a(CompoundNBT p_70037_1_) {
        this.warmupDelayTicks = p_70037_1_.func_74762_e("Warmup");
        if (p_70037_1_.func_186855_b("Owner")) {
            this.ownerUUID = p_70037_1_.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74768_a("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            p_213281_1_.func_186854_a("Owner", this.ownerUUID);
        }
    }

    public void func_70071_h_() {
        BlockState blockstate;
        BlockPos pos;
        int k;
        int j;
        int l;
        int i;
        super.func_70071_h_();
        System.out.print("\r\n" + (Object)((Object)this.waveType));
        this.field_70170_p.func_72960_a((Entity)this, (byte)this.waveType.id);
        this.func_213323_x_();
        if (this.field_70170_p.field_72995_K && this.waveType.isSummonSpot && this.field_70173_aa % 10 == 0) {
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187571_bR, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f, false);
            }
            for (i = 0; i < 20; ++i) {
                l = MathHelper.func_76128_c((double)this.func_226277_ct_());
                pos = new BlockPos(l, j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
                blockstate = this.field_70170_p.func_180495_p(pos);
                if (blockstate.isAir((IBlockReader)this.field_70170_p, pos)) continue;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 1) {
                    if (!this.func_174814_R() && this.waveType.isSummonSpot) {
                        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187571_bR, this.func_184176_by(), 1.0f, 0.5f, false);
                    }
                    for (i = 0; i < 20; ++i) {
                        l = MathHelper.func_76128_c((double)this.func_226277_ct_());
                        pos = new BlockPos(l, j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_()));
                        blockstate = this.field_70170_p.func_180495_p(pos);
                        if (blockstate.isAir((IBlockReader)this.field_70170_p, pos)) continue;
                        this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.lifeTicks == 1) {
                if (this.waveType.isSummonSpot) {
                    this.summonZombie(this.waveType.summonType);
                } else {
                    for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
                        this.dealDamageTo(livingentity);
                    }
                }
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)46);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.func_70106_y();
            }
        }
    }

    private void dealDamageTo(LivingEntity p_190551_1_) {
        LivingEntity livingentity = this.getOwner();
        if (p_190551_1_.func_70089_S() && !p_190551_1_.func_190530_aW() && p_190551_1_ != livingentity) {
            if (livingentity == null) {
                p_190551_1_.func_70097_a(DamageSource.field_188406_j, this.waveType.damage);
            } else {
                if (livingentity.func_184191_r((Entity)p_190551_1_)) {
                    return;
                }
                p_190551_1_.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)livingentity), this.waveType.damage);
            }
        }
    }

    public void summonZombie(EntityType type) {
        if (!this.field_70170_p.field_72995_K) {
            ServerWorld serverworld = (ServerWorld)this.field_70170_p;
            MobEntity vexentity = (MobEntity)type.func_200721_a(this.field_70170_p);
            vexentity.func_174828_a(this.func_233580_cy_(), 0.0f, 0.0f);
            vexentity.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(this.func_233580_cy_()), SpawnReason.MOB_SUMMONED, (ILivingEntityData)null, (CompoundNBT)null);
            if (this.getOwner() != null && this.getOwner() instanceof MobEntity) {
                vexentity.func_70624_b(((MobEntity)this.getOwner()).func_70638_az());
                if (this.getOwner().func_96124_cp() != null) {
                    Scoreboard scoreboard = this.field_70170_p.func_96441_U();
                    scoreboard.func_197901_a(vexentity.func_195047_I_(), scoreboard.func_96508_e(this.getOwner().func_96124_cp().func_96661_b()));
                }
            }
            serverworld.func_242417_l((Entity)vexentity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        super.func_70103_a(p_70103_1_);
        if (p_70103_1_ == 0) {
            this.waveType = WaveType.ZOMBIE;
        } else if (p_70103_1_ == 1) {
            this.waveType = WaveType.HUSK;
        } else if (p_70103_1_ == 2) {
            this.waveType = WaveType.FROZEN_ZOMBIE;
        } else if (p_70103_1_ == 3) {
            this.waveType = WaveType.JUNGLE_ZOMBIE;
        } else if (p_70103_1_ == 4) {
            this.waveType = WaveType.SUMMON_ZOMBIE;
        } else if (p_70103_1_ == 5) {
            this.waveType = WaveType.SUMMON_HUSK;
        } else if (p_70103_1_ == 6) {
            this.waveType = WaveType.SUMMON_FROZEN_ZOMBIE;
        } else if (p_70103_1_ == 7) {
            this.waveType = WaveType.SUMMON_JUNGLE_ZOMBIE;
        } else if (p_70103_1_ == 46) {
            this.clientSideAttackStarted = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float p_190550_1_) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - p_190550_1_) / 20.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    static enum WaveType {
        ZOMBIE(0, false, 7.5f, EntityType.field_200725_aD),
        HUSK(1, false, 12.0f, EntityType.field_200763_C),
        FROZEN_ZOMBIE(2, false, 7.5f, EntityType.field_200725_aD),
        JUNGLE_ZOMBIE(3, false, 7.5f, EntityType.field_200725_aD),
        SUMMON_ZOMBIE(4, true, 7.5f, EntityType.field_200725_aD),
        SUMMON_HUSK(5, true, 12.0f, EntityType.field_200763_C),
        SUMMON_FROZEN_ZOMBIE(6, true, 7.5f, EntityType.field_200725_aD),
        SUMMON_JUNGLE_ZOMBIE(7, true, 7.5f, EntityType.field_200725_aD);

        public int id;
        public boolean isSummonSpot;
        public float damage;
        public EntityType summonType;

        private WaveType(int id, boolean isSummonSpot, float damage, EntityType summonType) {
            this.id = id;
            this.isSummonSpot = isSummonSpot;
            this.damage = damage;
            this.summonType = summonType;
        }
    }
}

