/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.ItemInit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class WitherBodyPartEntity
extends Entity {
    private static final DataParameter<Byte> PART = EntityDataManager.func_187226_a(WitherBodyPartEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private final boolean yawPositive;
    private final boolean pitchPositive;
    private double velocityX;
    private double velocityY;
    private double velocityZ;
    private int despawnTimer;

    public WitherBodyPartEntity(EntityType<? extends WitherBodyPartEntity> p_i50189_1_, World p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.field_70127_C = this.field_70125_A = this.field_70146_Z.nextFloat() * 360.0f;
        this.field_70126_B = this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.yawPositive = this.field_70146_Z.nextBoolean();
        this.pitchPositive = this.field_70146_Z.nextBoolean();
    }

    protected WitherBodyPartEntity(World world, MobEntity owner, int part) {
        this((EntityType<? extends WitherBodyPartEntity>)((EntityType)EntityTypeInit.WITHER_BODY_PART.get()), world);
        this.setPart(part);
        this.func_225653_b_(owner.func_226277_ct_(), owner.func_226278_cu_() + (double)(3.2f * (0.25f + this.field_70146_Z.nextFloat() * 0.5f)), owner.func_226281_cx_());
        this.func_241209_g_(owner.func_223314_ad());
    }

    protected WitherBodyPartEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this((EntityType<? extends WitherBodyPartEntity>)((EntityType)EntityTypeInit.WITHER_BODY_PART.get()), world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PART, (Object)0);
    }

    public int getPart() {
        return ((Byte)this.field_70180_af.func_187225_a(PART)).byteValue();
    }

    private void setPart(int part) {
        this.field_70180_af.func_187227_b(PART, (Object)((byte)part));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)this.getItemByPart());
    }

    public boolean func_70104_M() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, 0.045, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.96));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.7));
        }
        if (!this.field_70122_E && this.field_213328_B == Vector3d.field_186680_a) {
            this.field_70125_A += 10.0f * (float)(this.yawPositive ? 1 : -1);
            this.field_70177_z += 15.0f * (float)(this.pitchPositive ? 1 : -1);
            for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), this::canHarm)) {
                entity.func_241209_g_(this.func_223314_ad() / 20);
                entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this), 4.0f + (float)this.field_70146_Z.nextInt(4));
            }
        }
        if (!this.field_70170_p.field_72995_K && ++this.despawnTimer >= 6000) {
            this.func_70106_y();
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.func_70089_S()) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a((IItemProvider)this.getItemByPart()).func_174868_q();
                }
                this.func_70106_y();
            }
            player.func_184609_a(hand);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    private boolean canHarm(Entity entity) {
        return entity.func_241845_aY() && entity.func_200600_R() != EntityTypeInit.MUTANT_WITHER_SKELETON.get();
    }

    public Item getItemByPart() {
        int part = this.getPart();
        if (part == 0) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_PELVIS.get();
        }
        if (part >= 1 && part < 19) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_RIB.get();
        }
        if (part == 19) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_SKULL.get();
        }
        if (part >= 21 && part < 29) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_LIMB.get();
        }
        if (part == 29 || part == 30) {
            return (Item)ItemInit.MUTANT_WITHER_SKELETON_SHOULDER_PAD.get();
        }
        return (Item)ItemInit.MUTANT_WITHER_SKELETON_PELVIS.get();
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74774_a("Part", (byte)this.getPart());
        compound.func_74777_a("DespawnTimer", (short)this.despawnTimer);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setPart(compound.func_74771_c("Part"));
        this.despawnTimer = compound.func_74765_d("DespawnTimer");
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

