/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.gui.screen;

import com.alexander.mutantmore.entities.RodlingEntity;
import com.alexander.mutantmore.init.ItemInit;
import com.alexander.mutantmore.packets.MutantMorePacketHandler;
import com.alexander.mutantmore.packets.RodlingCheckerPacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class RodlingCheckerScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mutantmore", "textures/gui/rodling_checker.png");
    private final int xSize = 176;
    private final int ySize = 166;
    private int guiX;
    private int guiY;
    private final RodlingEntity rodling;
    private boolean canRideOnShoulder;
    private boolean canBurnBlocks;
    private boolean alwaysShowName;

    public RodlingCheckerScreen(RodlingEntity creeperMinion) {
        super(creeperMinion.func_145748_c_());
        this.rodling = creeperMinion;
    }

    protected void func_231160_c_() {
        this.canBurnBlocks = this.rodling.canBurnBlocks();
        this.alwaysShowName = this.rodling.alwaysShowName();
        this.canRideOnShoulder = this.rodling.canShoulderSit();
        this.guiX = (this.field_230708_k_ - this.xSize) / 2;
        this.guiY = (this.field_230709_l_ - this.ySize) / 2;
        int buttonWidth = this.xSize / 2 - 10;
        this.func_230480_a_((Widget)new Button(this.guiX + 8, this.guiY + this.ySize - 78, buttonWidth * 2 + 4, 20, this.canBurnBlocks(), button -> {
            this.canBurnBlocks = !this.canBurnBlocks;
            MutantMorePacketHandler.INSTANCE.sendToServer((Object)new RodlingCheckerPacket(this.rodling, 0, this.canBurnBlocks));
            button.func_238482_a_(this.canBurnBlocks());
        }));
        this.func_230480_a_((Widget)new Button(this.guiX + 8, this.guiY + this.ySize - 54, buttonWidth * 2 + 4, 20, this.alwaysShowName(), button -> {
            this.alwaysShowName = !this.alwaysShowName;
            MutantMorePacketHandler.INSTANCE.sendToServer((Object)new RodlingCheckerPacket(this.rodling, 1, this.alwaysShowName));
            button.func_238482_a_(this.alwaysShowName());
        }));
        this.func_230480_a_((Widget)new Button(this.guiX + 8, this.guiY + this.ySize - 30, buttonWidth * 2 + 4, 20, this.canRideOnShoulder(), button -> {
            this.canRideOnShoulder = !this.canRideOnShoulder;
            MutantMorePacketHandler.INSTANCE.sendToServer((Object)new RodlingCheckerPacket(this.rodling, 2, this.canRideOnShoulder));
            button.func_238482_a_(this.canRideOnShoulder());
        }));
        if (!this.rodling.func_152114_e((LivingEntity)this.field_230706_i_.field_71439_g)) {
            for (Widget widget : this.field_230710_m_) {
                widget.field_230693_o_ = false;
            }
        }
    }

    public void func_231023_e_() {
        if (!this.rodling.func_70089_S()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
    }

    public void func_231175_as__() {
        if (this.rodling != null) {
            this.rodling.func_184185_a(SoundEvents.field_187837_fU, 1.0f, 1.0f);
        }
        super.func_231175_as__();
    }

    private ITextComponent alwaysShowName() {
        return new TranslationTextComponent(RodlingCheckerScreen.format("show_name", new Object[0]) + ": " + I18n.func_135052_a((String)(this.alwaysShowName ? "options.on" : "options.off"), (Object[])new Object[0]));
    }

    private ITextComponent canBurnBlocks() {
        return new TranslationTextComponent(RodlingCheckerScreen.format("burns_blocks", new Object[0]) + ": " + I18n.func_135052_a((String)(this.canBurnBlocks ? "options.on" : "options.off"), (Object[])new Object[0]));
    }

    private ITextComponent canRideOnShoulder() {
        return new TranslationTextComponent(RodlingCheckerScreen.format("ride_on_shoulder", new Object[0]) + ": " + I18n.func_135052_a((String)(this.canRideOnShoulder ? "options.on" : "options.off"), (Object[])new Object[0]));
    }

    public void func_230430_a_(MatrixStack stack, int screenX, int screenY, float elapsedPartialTicks) {
        this.func_230446_a_(stack);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.field_71446_o.func_110577_a(TEXTURE);
        this.func_238474_b_(stack, this.guiX, this.guiY, 0, 0, this.xSize, this.ySize);
        int health = (int)(this.rodling.func_110143_aJ() * 150.0f / this.rodling.func_110138_aP());
        this.func_238474_b_(stack, this.guiX + 13, this.guiY + 16, 0, 166, health, 6);
        int fireballStrength = (int)((float)this.rodling.getFireballStrength() * 150.0f / 10.0f);
        this.func_238474_b_(stack, this.guiX + 13, this.guiY + 27, 0, 174, fireballStrength, 6);
        this.field_230712_o_.func_238421_b_(stack, this.field_230704_d_.getString(), (float)(this.guiX + 13), (float)(this.guiY + 5), 0x404040);
        this.field_230712_o_.func_238421_b_(stack, RodlingCheckerScreen.format("health", new Object[0]), (float)(this.guiX + 15), (float)(this.guiY + 45), 0x404040);
        this.field_230712_o_.func_238421_b_(stack, RodlingCheckerScreen.format("fireball_strength", new Object[0]), (float)(this.guiX + 15), (float)(this.guiY + 63), 0x404040);
        StringBuilder sb = new StringBuilder();
        sb.append(this.rodling.func_110143_aJ() / 2.0f).append(" / ").append(this.rodling.func_110138_aP() / 2.0f);
        RodlingCheckerScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)sb.toString(), (int)(this.guiX + this.xSize / 2 + 45), (int)(this.guiY + 45), (int)0xFFFFFF);
        StringBuilder sb1 = new StringBuilder();
        sb1.append(this.rodling.getFireballStrength()).append(" / ").append(10);
        RodlingCheckerScreen.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)sb1.toString(), (int)(this.guiX + this.xSize / 2 + 45), (int)(this.guiY + 63), (int)0xFFFFFF);
        super.func_230430_a_(stack, screenX, screenY, elapsedPartialTicks);
    }

    public boolean func_231177_au__() {
        return false;
    }

    private static String format(String key, Object ... parameters) {
        return I18n.func_135052_a((String)("gui." + ((Item)ItemInit.RODLING_CHECKER.get()).getRegistryName().toString().replace(":", ".").replace("item.", "") + "." + key), (Object[])parameters);
    }
}

