/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.items;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WitherSkeletonHelmetItem
extends ArmorItem {
    private final Block block;
    private final Block wallBlock;
    @OnlyIn(value=Dist.CLIENT)
    private BipedModel<?> mutantSkeletonArmor;

    public WitherSkeletonHelmetItem(Block block, Block wallBlock, IArmorMaterial material, EquipmentSlotType slot, Item.Properties properties) {
        super(material, slot, properties);
        this.block = block;
        this.wallBlock = wallBlock;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (this.field_77881_a == EquipmentSlotType.HEAD) {
            player.func_195064_c(new EffectInstance(Effects.field_76422_e, -1, 0, false, false));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<?> getMutantWitherSkeletonArmour() {
        if (this.mutantSkeletonArmor == null) {
            this.mutantSkeletonArmor = new BipedModel(1.0f);
            this.mutantSkeletonArmor.field_78116_c = new ModelRenderer(this.mutantSkeletonArmor, 0, 0);
            this.mutantSkeletonArmor.field_78116_c.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.5f);
            ModelRenderer jaw = new ModelRenderer(this.mutantSkeletonArmor, 32, 0);
            jaw.func_228301_a_(-4.0f, -3.0f, -8.0f, 8.0f, 3.0f, 8.0f, 0.7f);
            jaw.func_78793_a(0.0f, -0.2f, 3.5f);
            jaw.field_78795_f = 0.19817477f;
            this.mutantSkeletonArmor.field_78116_c.func_78792_a(jaw);
            ModelRenderer horns = new ModelRenderer(this.mutantSkeletonArmor, 56, 19);
            horns.func_228301_a_(-6.5f, -11.0f, -8.0f, 2.0f, 11.0f, 2.0f, 0.0f);
            horns.func_228301_a_(4.5f, -11.0f, -8.0f, 2.0f, 11.0f, 2.0f, 0.0f);
            horns.func_78793_a(0.0f, -9.0f, 5.0f);
            horns.field_78795_f = 1.003564f;
            this.mutantSkeletonArmor.field_78116_c.func_78792_a(horns);
            this.mutantSkeletonArmor.field_178720_f = new ModelRenderer(this.mutantSkeletonArmor);
        }
        return this.mutantSkeletonArmor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)(armorSlot == EquipmentSlotType.HEAD && this.getMutantWitherSkeletonArmour() != null ? this.getMutantWitherSkeletonArmour() : null);
    }

    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        ActionResultType actionresulttype = this.place(new BlockItemUseContext(p_195939_1_));
        return !actionresulttype.func_226246_a_() && this.func_219971_r() ? this.func_77659_a(p_195939_1_.func_195991_k(), p_195939_1_.func_195999_j(), p_195939_1_.func_221531_n()).func_188397_a() : actionresulttype;
    }

    public ActionResultType place(BlockItemUseContext p_195942_1_) {
        if (!p_195942_1_.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        BlockItemUseContext blockitemusecontext = this.updatePlacementContext(p_195942_1_);
        if (blockitemusecontext == null) {
            return ActionResultType.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockitemusecontext);
        if (blockstate == null) {
            return ActionResultType.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.func_195995_a();
        World world = blockitemusecontext.func_195991_k();
        PlayerEntity playerentity = blockitemusecontext.func_195999_j();
        ItemStack itemstack = blockitemusecontext.func_195996_i();
        BlockState blockstate1 = world.func_180495_p(blockpos);
        Block block = blockstate1.func_177230_c();
        if (block == blockstate.func_177230_c()) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, world, itemstack, blockstate1);
            this.updateCustomBlockEntityTag(blockpos, world, playerentity, itemstack, blockstate1);
            block.func_180633_a(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.getSoundType((IWorldReader)world, blockpos, (Entity)p_195942_1_.func_195999_j());
        world.func_184133_a(playerentity, blockpos, this.getPlaceSound(blockstate1, world, blockpos, p_195942_1_.func_195999_j()), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (playerentity == null || !playerentity.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    @Deprecated
    protected SoundEvent getPlaceSound(BlockState p_219983_1_) {
        return p_219983_1_.func_215695_r().func_185841_e();
    }

    protected SoundEvent getPlaceSound(BlockState state, World world, BlockPos pos, PlayerEntity entity) {
        return state.getSoundType((IWorldReader)world, pos, (Entity)entity).func_185841_e();
    }

    @Nullable
    public BlockItemUseContext updatePlacementContext(BlockItemUseContext p_219984_1_) {
        return p_219984_1_;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos p_195943_1_, World p_195943_2_, @Nullable PlayerEntity p_195943_3_, ItemStack p_195943_4_, BlockState p_195943_5_) {
        return WitherSkeletonHelmetItem.updateCustomBlockEntityTag(p_195943_2_, p_195943_3_, p_195943_1_, p_195943_4_);
    }

    @Nullable
    protected BlockState getPlacementState(BlockItemUseContext p_195945_1_) {
        BlockState blockstate = this.wallBlock.func_196258_a(p_195945_1_);
        BlockState blockstate1 = null;
        World iworldreader = p_195945_1_.func_195991_k();
        BlockPos blockpos = p_195945_1_.func_195995_a();
        for (Direction direction : p_195945_1_.func_196009_e()) {
            BlockState blockstate2;
            if (direction == Direction.UP) continue;
            BlockState blockState = blockstate2 = direction == Direction.DOWN ? this.getBlock().func_196258_a(p_195945_1_) : blockstate;
            if (blockstate2 == null || !blockstate2.func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
            blockstate1 = blockstate2;
            break;
        }
        return blockstate1 != null && iworldreader.func_226663_a_(blockstate1, blockpos, ISelectionContext.func_216377_a()) ? blockstate1 : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos p_219985_1_, World p_219985_2_, ItemStack p_219985_3_, BlockState p_219985_4_) {
        BlockState blockstate = p_219985_4_;
        CompoundNBT compoundnbt = p_219985_3_.func_77978_p();
        if (compoundnbt != null) {
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("BlockStateTag");
            StateContainer statecontainer = p_219985_4_.func_177230_c().func_176194_O();
            for (String s : compoundnbt1.func_150296_c()) {
                Property property = statecontainer.func_185920_a(s);
                if (property == null) continue;
                String s1 = compoundnbt1.func_74781_a(s).func_150285_a_();
                blockstate = WitherSkeletonHelmetItem.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != p_219985_4_) {
            p_219985_2_.func_180501_a(p_219985_1_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState p_219988_0_, Property<T> p_219988_1_, String p_219988_2_) {
        return p_219988_1_.func_185929_b(p_219988_2_).map(p_219986_2_ -> (BlockState)p_219988_0_.func_206870_a(p_219988_1_, p_219986_2_)).orElse(p_219988_0_);
    }

    protected boolean canPlace(BlockItemUseContext p_195944_1_, BlockState p_195944_2_) {
        PlayerEntity playerentity = p_195944_1_.func_195999_j();
        ISelectionContext iselectioncontext = playerentity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)playerentity);
        return (!this.mustSurvive() || p_195944_2_.func_196955_c((IWorldReader)p_195944_1_.func_195991_k(), p_195944_1_.func_195995_a())) && p_195944_1_.func_195991_k().func_226663_a_(p_195944_2_, p_195944_1_.func_195995_a(), iselectioncontext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockItemUseContext p_195941_1_, BlockState p_195941_2_) {
        return p_195941_1_.func_195991_k().func_180501_a(p_195941_1_.func_195995_a(), p_195941_2_, 11);
    }

    public static boolean updateCustomBlockEntityTag(World p_179224_0_, @Nullable PlayerEntity p_179224_1_, BlockPos p_179224_2_, ItemStack p_179224_3_) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = p_179224_0_.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        CompoundNBT compoundnbt = p_179224_3_.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && (tileentity = p_179224_0_.func_175625_s(p_179224_2_)) != null) {
            if (!(p_179224_0_.field_72995_K || !tileentity.func_183000_F() || p_179224_1_ != null && p_179224_1_.func_195070_dx())) {
                return false;
            }
            CompoundNBT compoundnbt1 = tileentity.func_189515_b(new CompoundNBT());
            CompoundNBT compoundnbt2 = compoundnbt1.func_74737_b();
            compoundnbt1.func_197643_a(compoundnbt);
            compoundnbt1.func_74768_a("x", p_179224_2_.func_177958_n());
            compoundnbt1.func_74768_a("y", p_179224_2_.func_177956_o());
            compoundnbt1.func_74768_a("z", p_179224_2_.func_177952_p());
            if (!compoundnbt1.equals((Object)compoundnbt2)) {
                tileentity.func_230337_a_(p_179224_0_.func_180495_p(p_179224_2_), compoundnbt1);
                tileentity.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public String func_77658_a() {
        return this.getBlock().func_149739_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<ITextComponent> p_77624_3_, ITooltipFlag p_77624_4_) {
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
        this.getBlock().func_190948_a(p_77624_1_, (IBlockReader)p_77624_2_, p_77624_3_, p_77624_4_);
    }

    public Block getBlock() {
        return this.getBlockRaw() == null ? null : (Block)this.getBlockRaw().delegate.get();
    }

    private Block getBlockRaw() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> p_195946_1_, Item p_195946_2_) {
        p_195946_1_.put(this.getBlock(), p_195946_2_);
        p_195946_1_.put(this.wallBlock, p_195946_2_);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> blockToItemMap, Item itemIn) {
        blockToItemMap.remove(this.getBlock());
        blockToItemMap.remove(this.wallBlock);
    }
}

