/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.models.entity;

import com.alexander.mutantmore.entities.MutantBlazeEntity;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class MutantBlazeModel
extends AnimatedGeoModel {
    public ResourceLocation getAnimationFileLocation(Object entity) {
        return new ResourceLocation("mutantmore", "animations/mutant_blaze.animation.json");
    }

    public ResourceLocation getModelLocation(Object entity) {
        return new ResourceLocation("mutantmore", "geo/mutant_blaze.geo.json");
    }

    public ResourceLocation getTextureLocation(Object entity) {
        return new ResourceLocation("mutantmore", "textures/entities/mutant_blaze.png");
    }

    public void setLivingAnimations(IAnimatable entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone mutantBlaze = this.getAnimationProcessor().getBone("mutantBlaze");
        MutantBlazeEntity entityIn = (MutantBlazeEntity)entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (entityIn.getChargeTicks() > 0 && (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f)) {
            mutantBlaze.setRotationX(mutantBlaze.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            mutantBlaze.setRotationY(mutantBlaze.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

