/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.models.entity;

import com.alexander.mutantmore.config.MutantConfig;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class MutantHuskModel
extends AnimatedGeoModel {
    public ResourceLocation getAnimationFileLocation(Object entity) {
        return new ResourceLocation("mutantmore", "animations/mutant_husk.animation.json");
    }

    public ResourceLocation getModelLocation(Object entity) {
        return new ResourceLocation("mutantmore", "geo/mutant_husk.geo.json");
    }

    public ResourceLocation getTextureLocation(Object entity) {
        return (Boolean)MutantConfig.mutant_husk_cacti.get() != false ? new ResourceLocation("mutantmore", "textures/entities/mutant_husk.png") : new ResourceLocation("mutantmore", "textures/entities/mutant_husk_cactusless.png");
    }

    public void setLivingAnimations(IAnimatable entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations(entity, uniqueID, customPredicate);
        IBone head = this.getAnimationProcessor().getBone("head");
        LivingEntity entityIn = (LivingEntity)entity;
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (extraData.headPitch != 0.0f || extraData.netHeadYaw != 0.0f) {
            head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

