/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.entity;

import com.girafi.waddles.Waddles;
import com.girafi.waddles.init.PenguinRegistry;
import com.girafi.waddles.init.WaddlesSounds;
import com.girafi.waddles.utils.ConfigurationHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTables;

public class EntityAdeliePenguin
extends AnimalEntity {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX});
    public short rotationFlipper;
    private boolean moveFlipper = false;

    public EntityAdeliePenguin(EntityType<? extends EntityAdeliePenguin> adelie, World world) {
        super(PenguinRegistry.ADELIE_PENGUIN, world);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new EntityAIExtinguishFire());
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, PolarBearEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(5, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, EntityAdeliePenguin.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.16);
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? WaddlesSounds.ADELIE_BABY_AMBIENT : WaddlesSounds.ADELIE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return WaddlesSounds.ADELIE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WaddlesSounds.ADELIE_DEATH;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70161_v != this.field_70166_s && this.moveFlipper) {
            this.rotationFlipper = (short)(this.rotationFlipper + 1);
        }
    }

    protected int func_70693_a(PlayerEntity player) {
        if (((Boolean)ConfigurationHandler.GENERAL.dropExp.get()).booleanValue()) {
            return super.func_70693_a(player);
        }
        return 0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && TEMPTATION_ITEMS.test(stack);
    }

    @Nullable
    public ResourceLocation func_184647_J() {
        if (((Boolean)ConfigurationHandler.GENERAL.dropFish.get()).booleanValue()) {
            return Waddles.LOOT_ENTITIES_PENGUIN_FISH;
        }
        return LootTables.field_186419_a;
    }

    @Nonnull
    public EntityAdeliePenguin createChild(@Nonnull AgeableEntity ageable) {
        return (EntityAdeliePenguin)Objects.requireNonNull(PenguinRegistry.ADELIE_PENGUIN.func_200721_a(this.field_70170_p));
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.func_70631_g_() ? 0.5f : 0.9f;
    }

    public boolean func_213380_a(IWorld world, @Nonnull SpawnReason spawnReason) {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        Material material = world.func_180495_p(pos.func_177977_b()).func_185904_a();
        return world.func_201669_a(pos, 0) > 8 && (material == Material.field_151588_w || material == Material.field_151598_x) || super.func_213380_a(world, spawnReason);
    }

    private class EntityAIExtinguishFire
    extends PanicGoal {
        EntityAIExtinguishFire() {
            super((CreatureEntity)EntityAdeliePenguin.this, 2.0);
        }

        public boolean func_75250_a() {
            return (EntityAdeliePenguin.this.func_70631_g_() || EntityAdeliePenguin.this.func_70027_ad()) && super.func_75250_a();
        }
    }
}

