/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.init;

import com.girafi.waddles.entity.EntityAdeliePenguin;
import com.girafi.waddles.utils.BiomeDictionaryHelper;
import com.girafi.waddles.utils.ConfigurationHandler;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="waddles", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PenguinRegistry {
    private static List<EntityType> entities = Lists.newArrayList();
    private static List<Item> spawnEggs = Lists.newArrayList();
    public static final EntityType<EntityAdeliePenguin> ADELIE_PENGUIN = PenguinRegistry.createEntity(EntityAdeliePenguin.class, EntityAdeliePenguin::new, 0.4f, 0.95f, 0, 0xFFFFFF);

    private static <T extends Entity> EntityType<T> createEntity(Class<T> entityClass, EntityType.IFactory<T> factory, float width, float height, int eggPrimary, int eggSecondary) {
        ResourceLocation location = new ResourceLocation("waddles", PenguinRegistry.classToString(entityClass));
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.CREATURE).func_220321_a(width, height).setTrackingRange(64).setUpdateInterval(1).func_206830_a(location.toString());
        entity.setRegistryName(location);
        entities.add(entity);
        SpawnEggItem spawnEgg = new SpawnEggItem(entity, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        spawnEgg.setRegistryName(new ResourceLocation("waddles", PenguinRegistry.classToString(entityClass) + "_spawn_egg"));
        spawnEggs.add((Item)spawnEgg);
        return entity;
    }

    private static String classToString(Class<? extends Entity> entityClass) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", "");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerPenguins(RegistryEvent.Register<EntityType<?>> event) {
        for (EntityType entity : entities) {
            Preconditions.checkNotNull((Object)entity.getRegistryName(), (Object)"registryName");
            event.getRegistry().register((IForgeRegistryEntry)entity);
        }
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        for (Item spawnEgg : spawnEggs) {
            Preconditions.checkNotNull((Object)spawnEgg.getRegistryName(), (Object)"registryName");
            event.getRegistry().register((IForgeRegistryEntry)spawnEgg);
        }
    }

    public static void addSpawn() {
        ArrayList spawnableBiomes = Lists.newArrayList();
        List<BiomeDictionary.Type> includeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigurationHandler.SPAWN.include.get()));
        List<BiomeDictionary.Type> excludeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigurationHandler.SPAWN.exclude.get()));
        if (!includeList.isEmpty()) {
            for (BiomeDictionary.Type type : includeList) {
                for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)type)) {
                    if (biome.func_76747_a(EntityClassification.CREATURE).isEmpty()) continue;
                    spawnableBiomes.add(biome);
                }
            }
            if (!excludeList.isEmpty()) {
                for (BiomeDictionary.Type type : excludeList) {
                    Set excludeBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
                    for (Biome biome : excludeBiomes) {
                        spawnableBiomes.remove(biome);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Do not leave the BiomeDictionary type inclusion list empty. If you wish to disable spawning of an entity, set the weight to 0 instead.");
        }
        for (Biome biome : spawnableBiomes) {
            biome.func_201866_a(EntityClassification.CREATURE, new Biome.SpawnListEntry(ADELIE_PENGUIN, ((Integer)ConfigurationHandler.SPAWN.weight.get()).intValue(), ((Integer)ConfigurationHandler.SPAWN.min.get()).intValue(), ((Integer)ConfigurationHandler.SPAWN.max.get()).intValue()));
        }
    }
}

