/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.corpse.Config;
import de.maxhenkel.corpse.commands.HistoryCommand;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.entities.CorpseRenderer;
import de.maxhenkel.corpse.events.DeathEvents;
import de.maxhenkel.corpse.events.KeyEvents;
import de.maxhenkel.corpse.gui.CorpseContainerFactory;
import de.maxhenkel.corpse.gui.ScreenManager;
import de.maxhenkel.corpse.net.MessageOpenHistory;
import de.maxhenkel.corpse.net.MessageRequestDeathHistory;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import de.maxhenkel.corpse.net.MessageSwitchInventoryPage;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="corpse")
@Mod.EventBusSubscriber
public class Main {
    public static final String MODID = "corpse";
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_DEATH_HISTORY;
    public static SimpleChannel SIMPLE_CHANNEL;
    public static EntityType<CorpseEntity> CORPSE_ENTITY_TYPE;
    public static ContainerType CONTAINER_TYPE_CORPSE;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientStart());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    @SubscribeEvent
    public void serverLoad(FMLServerStartingEvent event) {
        HistoryCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
        SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "default"), () -> "1.0.0", s -> true, s -> true);
        SIMPLE_CHANNEL.registerMessage(0, MessageSwitchInventoryPage.class, MessageSwitchInventoryPage::toBytes, buf -> new MessageSwitchInventoryPage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(1, MessageOpenHistory.class, MessageOpenHistory::toBytes, buf -> new MessageOpenHistory().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(2, MessageShowCorpseInventory.class, MessageShowCorpseInventory::toBytes, buf -> new MessageShowCorpseInventory().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(3, MessageRequestDeathHistory.class, MessageRequestDeathHistory::toBytes, buf -> new MessageRequestDeathHistory().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.clientSetup();
        KEY_DEATH_HISTORY = new KeyBinding("key.death_history", 85, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_DEATH_HISTORY);
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        RenderingRegistry.registerEntityRenderingHandler(CORPSE_ENTITY_TYPE, CorpseRenderer::new);
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        CORPSE_ENTITY_TYPE = EntityType.Builder.func_220322_a(CorpseEntity::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(128).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).func_220321_a(2.0f, 0.5f).setCustomClientFactory((spawnEntity, world) -> new CorpseEntity((World)world)).func_206830_a("corpse:corpse");
        CORPSE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register(CORPSE_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        CONTAINER_TYPE_CORPSE = new ContainerType((ContainerType.IFactory)new CorpseContainerFactory());
        CONTAINER_TYPE_CORPSE.setRegistryName(new ResourceLocation(MODID, MODID));
        event.getRegistry().register((IForgeRegistryEntry)CONTAINER_TYPE_CORPSE);
    }
}

