/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import de.maxhenkel.corpse.Config;
import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.entities.CorpseInventoryBaseEntity;
import de.maxhenkel.corpse.gui.ScreenManager;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CorpseEntity
extends CorpseInventoryBaseEntity {
    private static final DataParameter<Optional<UUID>> ID = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> DEATH_ID = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final AxisAlignedBB NULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final UUID NULL_UUID = new UUID(0L, 0L);
    private AxisAlignedBB boundingBox = NULL_AABB;
    private int emptyAge;

    public CorpseEntity(EntityType type, World world) {
        super(type, world);
        this.field_70156_m = true;
        this.emptyAge = -1;
    }

    public CorpseEntity(World world) {
        this((EntityType)Main.CORPSE_ENTITY_TYPE, world);
    }

    public static CorpseEntity createFromDeath(PlayerEntity player, Death death) {
        CorpseEntity corpse = new CorpseEntity(player.field_70170_p);
        corpse.setCorpseUUID(death.getPlayerUUID());
        corpse.setDeathUUID(death.getId());
        corpse.setCorpseName(death.getPlayerName());
        corpse.setItems(death.getItems());
        corpse.func_70107_b(death.getPosX(), Math.max(death.getPosY(), 0.0), death.getPosZ());
        corpse.setCorpseRotation(player.field_70177_z);
        return corpse;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.35f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.recalculateBoundingBox();
        this.setCorpseAge(this.getCorpseAge() + 1);
        if (!this.func_189652_ae()) {
            double yMotion = 0.0;
            Vec3d motion = this.func_213322_ci();
            if (this.func_208600_a(FluidTags.field_206959_a) || this.func_208600_a(FluidTags.field_206960_b)) {
                yMotion = motion.field_72448_b < 0.0 ? motion.field_72448_b + (motion.field_72448_b < 0.03 ? 0.01 : 0.0) : motion.field_72448_b + (motion.field_72448_b < 0.03 ? 5.0E-4 : 0.0);
            } else if (this.func_226278_cu_() > 0.0) {
                yMotion = Math.max(-2.0, motion.field_72448_b - 0.0625);
            }
            this.func_213293_j(this.func_213322_ci().field_72450_a * 0.75, yMotion, this.func_213322_ci().field_72449_c * 0.75);
            if (this.func_226278_cu_() < 0.0) {
                this.func_70634_a(this.func_226277_ct_(), 0.0, this.func_226281_cx_());
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if ((Integer)Config.SERVER.corpseForceDespawnTime.get() > 0 && this.getCorpseAge() > (Integer)Config.SERVER.corpseForceDespawnTime.get()) {
            this.func_70106_y();
            return;
        }
        if (this.func_191420_l() && this.emptyAge < 0) {
            this.emptyAge = this.getCorpseAge();
        } else if (this.func_191420_l() && this.getCorpseAge() - this.emptyAge >= (Integer)Config.SERVER.corpseDespawnTime.get()) {
            this.func_70106_y();
        }
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && player instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            if (((Boolean)Config.SERVER.onlyOwnerAccess.get()).booleanValue()) {
                boolean isOp = playerMP.func_211513_k(playerMP.field_71133_b.func_110455_j());
                if (isOp || playerMP.func_110124_au().equals(this.getCorpseUUID())) {
                    ScreenManager.openCorpseGUI((ServerPlayerEntity)player, this);
                } else if (((Boolean)Config.SERVER.skeletonAccess.get()).booleanValue() && this.isSkeleton()) {
                    ScreenManager.openCorpseGUI((ServerPlayerEntity)player, this);
                }
            } else {
                ScreenManager.openCorpseGUI((ServerPlayerEntity)player, this);
            }
        }
        return true;
    }

    public boolean isSkeleton() {
        return this.getCorpseAge() >= (Integer)Config.SERVER.corpseSkeletonTime.get();
    }

    public void recalculateBoundingBox() {
        Direction facing = this.field_70180_af == null ? Direction.NORTH : Direction.func_176733_a((double)this.getCorpseRotation());
        this.boundingBox = new AxisAlignedBB(this.func_226277_ct_() - (facing.func_82601_c() != 0 ? 1.0 : 0.5), this.func_226278_cu_(), this.func_226281_cx_() - (facing.func_82599_e() != 0 ? 1.0 : 0.5), this.func_226277_ct_() + (facing.func_82601_c() != 0 ? 1.0 : 0.5), this.func_226278_cu_() + 0.5, this.func_226281_cx_() + (facing.func_82599_e() != 0 ? 1.0 : 0.5));
    }

    public ITextComponent func_145748_c_() {
        String name = this.getCorpseName();
        if (name == null || name.trim().isEmpty()) {
            return super.func_145748_c_();
        }
        return new TranslationTextComponent("entity.corpse.corpse_of", new Object[]{this.getCorpseName()});
    }

    public boolean func_90999_ad() {
        return false;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.boundingBox;
    }

    public void func_174826_a(AxisAlignedBB boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        this.recalculateBoundingBox();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public UUID getCorpseUUID() {
        Optional uuid = (Optional)this.field_70180_af.func_187225_a(ID);
        if (uuid.isPresent()) {
            return (UUID)uuid.get();
        }
        return NULL_UUID;
    }

    public void setCorpseUUID(UUID uuid) {
        if (uuid == null) {
            this.field_70180_af.func_187227_b(ID, Optional.of(NULL_UUID));
        } else {
            this.field_70180_af.func_187227_b(ID, Optional.of(uuid));
        }
    }

    public UUID getDeathUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(DEATH_ID)).orElse(null);
    }

    public void setDeathUUID(UUID uuid) {
        if (uuid == null) {
            this.field_70180_af.func_187227_b(DEATH_ID, Optional.empty());
        } else {
            this.field_70180_af.func_187227_b(DEATH_ID, Optional.of(uuid));
        }
    }

    public String getCorpseName() {
        return (String)this.field_70180_af.func_187225_a(NAME);
    }

    public void setCorpseName(String name) {
        this.field_70180_af.func_187227_b(NAME, (Object)name);
    }

    public float getCorpseRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setCorpseRotation(float rotation) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rotation));
        this.recalculateBoundingBox();
    }

    public int getCorpseAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    public void setCorpseAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ID, Optional.of(NULL_UUID));
        this.field_70180_af.func_187214_a(DEATH_ID, Optional.empty());
        this.field_70180_af.func_187214_a(NAME, (Object)"");
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        UUID deathID;
        super.func_213281_b(compound);
        UUID uuid = this.getCorpseUUID();
        if (uuid != null) {
            compound.func_74772_a("IDMost", uuid.getMostSignificantBits());
            compound.func_74772_a("IDLeast", uuid.getLeastSignificantBits());
        }
        if ((deathID = this.getDeathUUID()) != null) {
            compound.func_74772_a("DeathIDMost", deathID.getMostSignificantBits());
            compound.func_74772_a("DeathIDLeast", deathID.getLeastSignificantBits());
        }
        compound.func_74778_a("Name", this.getCorpseName());
        compound.func_74776_a("Rotation", this.getCorpseRotation());
        compound.func_74768_a("Age", this.getCorpseAge());
        if (this.emptyAge >= 0) {
            compound.func_74768_a("EmptyAge", this.emptyAge);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("IDMost") && compound.func_74764_b("IDLeast")) {
            this.setCorpseUUID(new UUID(compound.func_74763_f("IDMost"), compound.func_74763_f("IDLeast")));
        }
        if (compound.func_74764_b("DeathIDMost") && compound.func_74764_b("DeathIDLeast")) {
            this.setDeathUUID(new UUID(compound.func_74763_f("DeathIDMost"), compound.func_74763_f("DeathIDLeast")));
        }
        this.setCorpseName(compound.func_74779_i("Name"));
        this.setCorpseRotation(compound.func_74760_g("Rotation"));
        this.setCorpseAge(compound.func_74762_e("Age"));
        if (compound.func_74764_b("EmptyAge")) {
            this.emptyAge = compound.func_74762_e("EmptyAge");
        }
    }
}

