/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import de.maxhenkel.corpse.entities.CorpseEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class CorpseInventoryBaseEntity
extends Entity
implements IInventory {
    private static final DataParameter<Integer> INVENTORY_SIZE = EntityDataManager.func_187226_a(CorpseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected IInventory inventory;

    public CorpseInventoryBaseEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    private IInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new Inventory(this.getFittingInventorySize((Integer)this.field_70180_af.func_187225_a(INVENTORY_SIZE)));
        }
        return this.inventory;
    }

    private int getFittingInventorySize(int size) {
        if (size < 54) {
            size = 54;
        }
        if (size % 54 != 0) {
            size += 54 - size % 54;
        }
        return size;
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.field_70180_af.func_187227_b(INVENTORY_SIZE, (Object)items.size());
        for (int i = 0; i < this.func_70302_i_() && i < items.size(); ++i) {
            this.func_70299_a(i, (ItemStack)items.get(i));
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INVENTORY_SIZE, (Object)54);
    }

    protected void func_70037_a(CompoundNBT compound) {
        int size = compound.func_74762_e("InventorySize");
        ListNBT nbttaglist = compound.func_150295_c("Inventory", 10);
        this.inventory = new Inventory(size);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74762_e("Slot");
            if (j < 0 || j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Slot", i);
            this.func_70301_a(i).func_77955_b(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        compound.func_218657_a("Inventory", (INBT)nbttaglist);
        compound.func_74768_a("InventorySize", this.func_70302_i_());
    }

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.getInventory().func_191420_l();
    }

    public ItemStack func_70301_a(int index) {
        return this.getInventory().func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.getInventory().func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.getInventory().func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.getInventory().func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    public void func_70296_d() {
        this.getInventory().func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.getInventory().func_70300_a(player);
    }

    public void func_174889_b(PlayerEntity player) {
        this.getInventory().func_174889_b(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.getInventory().func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.getInventory().func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.getInventory().func_174888_l();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

