/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.libloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LibLoaderChained {
    static final Logger log = LogManager.getLogger((String)"LibLoader");
    static final boolean DISABLE_VALIDATION = Boolean.parseBoolean(System.getProperty("LibLoader.disableValidation", "false"));
    static final AtomicBoolean inited = new AtomicBoolean();

    public static void init() {
        if (!inited.compareAndSet(false, true)) {
            return;
        }
        File mods = new File(System.getProperty("LibLoader.modsFolder", "mods/"));
        File libraries = new File(System.getProperty("LibLoader.librariesFolder", "libraries/"));
        File cachedLibsFile = new File(libraries, "libloader cached libs.txt");
        List<File> libs = null;
        if (!Boolean.parseBoolean(System.getProperty("LibLoader.anyChanges", "true"))) {
            libs = LibLoaderChained.loadCachedLibs(cachedLibsFile);
        }
        if (libs == null) {
            File[] files = mods.listFiles();
            if (files == null) {
                throw new FileNotFoundException(mods.getAbsolutePath());
            }
            List<File> searchFiles = Collections.synchronizedList(new ArrayList<File>(Arrays.asList(files)));
            ConcurrentHashMap newLibs = new ConcurrentHashMap();
            ConcurrentHashMap allLibs = new ConcurrentHashMap();
            while (true) {
                newLibs.clear();
                searchFiles.parallelStream().forEach(it -> {
                    if (!it.getName().toLowerCase().endsWith(".jar")) {
                        return;
                    }
                    LibLoaderChained.loadLibraries(it, allLibs, newLibs);
                });
                if (newLibs.isEmpty()) break;
                searchFiles.clear();
                newLibs.values().parallelStream().forEach(lib -> searchFiles.add(lib.save(libraries)));
            }
            log.info("Found libs:\n" + allLibs.values().toString().replace(", ", "\n"));
            ConcurrentHashMap hashToFile = new ConcurrentHashMap();
            allLibs.values().parallelStream().forEach(lib -> hashToFile.put(lib.sha512hash, lib.getFile(libraries)));
            libs = new ArrayList(hashToFile.values());
            libs.sort(Comparator.comparing(File::getPath));
        }
        if (libs.isEmpty()) {
            return;
        }
        LaunchClassLoader classLoader = (LaunchClassLoader)LibLoaderChained.class.getClassLoader();
        List<URL> currentUrls = Arrays.asList(classLoader.getURLs());
        if (currentUrls.size() != 2) {
            log.info("Current LaunchClassLoader URLs:\n" + currentUrls.toString().replace(", ", "\n"));
        }
        for (File lib2 : libs) {
            classLoader.addURL(lib2.toURI().toURL());
        }
        LibLoaderChained.saveCachedLibs(cachedLibsFile, libs);
    }

    private static List<File> loadCachedLibs(File cachedLibsFile) {
        ArrayList<File> cachedLibs = new ArrayList<File>();
        try {
            for (String path : Files.readAllLines(cachedLibsFile.toPath(), Charset.forName("UTF-8"))) {
                File file = new File(path);
                if (!file.exists()) {
                    return null;
                }
                cachedLibs.add(file);
            }
        }
        catch (IOException ignored) {
            return null;
        }
        return cachedLibs;
    }

    private static void saveCachedLibs(File cachedLibsFile, List<File> cachedLibs) {
        StringBuilder sb = new StringBuilder();
        cachedLibs.forEach(it -> sb.append(it.getPath()).append('\n'));
        try {
            Files.write(cachedLibsFile.toPath(), sb.toString().getBytes(Charset.forName("UTF-8")), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            System.err.println("Failed to store cached libs");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadLibraries(File source, ConcurrentHashMap<String, Library> libraries, ConcurrentHashMap<String, Library> libraries2) {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(source));){
            ZipEntry e;
            while ((e = zis.getNextEntry()) != null) {
                String group;
                if (!e.getName().equals("META-INF/MANIFEST.MF")) continue;
                Manifest manifest = new Manifest(zis);
                int i = 0;
                Attributes main = manifest.getMainAttributes();
                while ((group = main.getValue("LibLoader-group" + i)) != null) {
                    String name = main.getValue("LibLoader-name" + i);
                    String classifier = main.getValue("LibLoader-classifier" + i);
                    String version = main.getValue("LibLoader-version" + i);
                    String sha512hash = main.getValue("LibLoader-sha512hash" + i);
                    if (sha512hash == null) {
                        ++i;
                        continue;
                    }
                    String url = main.getValue("LibLoader-url" + i);
                    String file = main.getValue("LibLoader-file" + i);
                    String buildTime = main.getValue("LibLoader-buildTime" + i);
                    Library lib = new Library(group, name, classifier, new Version(version), sha512hash, url, file, buildTime, source);
                    ConcurrentHashMap<String, Library> concurrentHashMap = libraries;
                    synchronized (concurrentHashMap) {
                        Library oldLib = libraries.get(lib.getKey());
                        if (oldLib == null || lib.compareTo(oldLib) > 0) {
                            libraries.put(lib.getKey(), lib);
                            libraries2.put(lib.getKey(), lib);
                        }
                    }
                    ++i;
                }
                return;
            }
        }
    }

    static class Version
    implements Comparable<Version> {
        final int[] parts;
        final String suffix;

        Version(String version) {
            if (version == null) {
                throw new IllegalArgumentException("Version can not be null");
            }
            int dash = (version = version.trim()).indexOf(45);
            if (dash != -1) {
                this.suffix = version.substring(dash + 1).trim();
                version = version.substring(0, dash);
            } else {
                this.suffix = null;
            }
            if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
                throw new IllegalArgumentException("Invalid version format. Should consist of digits and dots with optional suffix after -. Got '" + version + "'");
            }
            this.parts = Arrays.stream(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
        }

        @Override
        public int compareTo(Version that) {
            if (that == null) {
                return 1;
            }
            if (this == that) {
                return 0;
            }
            int length = Math.max(this.parts.length, that.parts.length);
            for (int i = 0; i < length; ++i) {
                int thatPart;
                int thisPart = i < this.parts.length ? this.parts[i] : 0;
                int n = thatPart = i < that.parts.length ? that.parts[i] : 0;
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            String a = this.suffix;
            String b = that.suffix;
            if (Objects.equals(a, b)) {
                return 0;
            }
            int s = Integer.compare(this.suffixInt(), that.suffixInt());
            if (s != 0) {
                return s;
            }
            if (a == null) {
                return -1;
            }
            return a.compareTo(b);
        }

        int suffixInt() {
            if (this.suffix == null) {
                return 0;
            }
            switch (this.suffix.toLowerCase().trim()) {
                case "alpha": {
                    return -3;
                }
                case "beta": 
                case "snapshot": {
                    return -2;
                }
                case "": {
                    return 0;
                }
            }
            return -1;
        }

        public String toString() {
            return String.join((CharSequence)".", Arrays.stream(this.parts).mapToObj(String::valueOf)::iterator) + (this.suffix == null ? "" : '-' + this.suffix);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            return this == that || that != null && this.getClass() == that.getClass() && this.compareTo((Version)that) == 0;
        }
    }

    static class Library
    implements Comparable<Library> {
        final String group;
        final String name;
        final String classifier;
        final Version version;
        final String sha512hash;
        final String url;
        final String file;
        final String buildTime;
        final transient File source;
        transient String calculatedHash = null;

        Library(String group, String name, String classifier, Version version, String sha512hash, String url, String file, String buildTime, File source) {
            this.group = group;
            this.name = name;
            this.classifier = classifier;
            this.version = version;
            this.sha512hash = sha512hash;
            this.url = url;
            this.file = file;
            this.buildTime = buildTime;
            this.source = source;
        }

        static String sha512(File f) {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] hash = digest.digest(Files.readAllBytes(f.toPath()));
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }

        static InputStream openStream(URL url) {
            URLConnection con = url.openConnection();
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            return con.getInputStream();
        }

        String getPath() {
            if (this.version.suffixInt() < 0) {
                return this.group.replace('.', '/') + '/' + this.name + '-' + this.version + '-' + this.sha512hash.substring(0, 16) + '/' + this.name + '-' + this.version + (this.classifier == null ? "" : '-' + this.classifier) + ".jar";
            }
            return this.group.replace('.', '/') + '/' + this.name + '-' + this.version + '/' + this.name + '-' + this.version + (this.classifier == null ? "" : '-' + this.classifier) + ".jar";
        }

        String getKey() {
            return this.group + '.' + this.name;
        }

        void validateHash(File jarPath) {
            block4: {
                String hash;
                if (!jarPath.exists()) {
                    throw new FileNotFoundException("Couldn't extract/download library " + this);
                }
                this.calculatedHash = hash = Library.sha512(jarPath);
                if (hash.equals(this.sha512hash)) break block4;
                Error error = new Error("Wrong hash for library " + this + "\nExpected " + this.sha512hash + ", got " + hash);
                if (DISABLE_VALIDATION) {
                    error.printStackTrace();
                    break block4;
                }
                throw error;
            }
        }

        File save(File extractionDir) {
            File jarPath = this.getFile(extractionDir);
            if (!jarPath.exists() || !DISABLE_VALIDATION && !Library.sha512(jarPath).equals(this.sha512hash)) {
                jarPath.getParentFile().mkdirs();
                if (this.file != null) {
                    try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.source));){
                        ZipEntry e;
                        while ((e = zis.getNextEntry()) != null) {
                            if (!e.getName().equals(this.file)) continue;
                            Files.copy(zis, jarPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                } else if (this.url != null) {
                    log.info("Downloading library " + this.toString() + " from " + this.url + ". Expected hash: " + this.sha512hash);
                    try (InputStream is = Library.openStream(new URL(this.url));){
                        Files.copy(is, jarPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                } else {
                    throw new Error("No way to acquire dependency: " + this);
                }
            }
            this.validateHash(jarPath);
            return jarPath;
        }

        File getFile(File extractionDir) {
            return new File(extractionDir, this.getPath());
        }

        @Override
        public int compareTo(Library o) {
            int c = this.version.compareTo(o.version);
            if (c != 0) {
                return c;
            }
            return Long.compare(Long.parseLong(this.buildTime), Long.parseLong(o.buildTime));
        }

        public String toString() {
            return this.group + '.' + this.name + (this.classifier == null ? "" : '-' + this.classifier) + '-' + this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Library)) {
                return false;
            }
            Library other = (Library)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$group = this.group;
            String other$group = other.group;
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$classifier = this.classifier;
            String other$classifier = other.classifier;
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            Version this$version = this.version;
            Version other$version = other.version;
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            String this$sha512hash = this.sha512hash;
            String other$sha512hash = other.sha512hash;
            if (this$sha512hash == null ? other$sha512hash != null : !this$sha512hash.equals(other$sha512hash)) {
                return false;
            }
            String this$url = this.url;
            String other$url = other.url;
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$file = this.file;
            String other$file = other.file;
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            String this$buildTime = this.buildTime;
            String other$buildTime = other.buildTime;
            return !(this$buildTime == null ? other$buildTime != null : !this$buildTime.equals(other$buildTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Library;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $group = this.group;
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $classifier = this.classifier;
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            Version $version = this.version;
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            String $sha512hash = this.sha512hash;
            result = result * 59 + ($sha512hash == null ? 43 : $sha512hash.hashCode());
            String $url = this.url;
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $file = this.file;
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            String $buildTime = this.buildTime;
            result = result * 59 + ($buildTime == null ? 43 : $buildTime.hashCode());
            return result;
        }
    }
}

