/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import mod.azure.doom.client.models.projectiles.BFGBallModel;
import mod.azure.doom.entity.projectiles.BFGEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoProjectilesRenderer;

public class BFGCellRender
extends GeoProjectilesRenderer<BFGEntity> {
    private static final RenderType BEAM = RenderType.m_110476_((ResourceLocation)new ResourceLocation("doom", "textures/entity/projectiles/bfg_beam.png"));

    public BFGCellRender(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (AnimatedGeoModel)new BFGBallModel());
    }

    public RenderType getRenderType(BFGEntity animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)this.m_5478_((Entity)animatable));
    }

    protected int getBlockLightLevel(BFGEntity entityIn, BlockPos partialTicks) {
        return 15;
    }

    public void render(GeoModel model, BFGEntity animatable, float partialTicks, RenderType type, PoseStack matrixStackIn, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.render(model, (Object)animatable, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        float f = BFGCellRender.getY(animatable, partialTicks);
        LivingEntity target = animatable.getTargetedEntity();
        if (target != null) {
            float f3 = (float)target.m_20185_();
            float f4 = (float)target.m_20186_();
            float f5 = (float)target.m_20189_();
            float f6 = (float)((double)f3 - animatable.m_20185_());
            float f7 = (float)((double)f4 - animatable.m_20186_());
            float f8 = (float)((double)f5 - animatable.m_20189_());
            matrixStackIn.m_85837_((double)f6, (double)f7, (double)f8);
            BFGCellRender.renderCrystalBeams(-f6, -f7 + f, -f8, partialTicks, animatable.f_19797_, matrixStackIn, renderTypeBuffer, packedLightIn);
        }
    }

    public void renderEarly(BFGEntity animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        super.renderEarly((Entity)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
        stackIn.m_85841_(animatable.f_19797_ > 2 ? 1.0f : 0.0f, animatable.f_19797_ > 2 ? 1.0f : 0.0f, animatable.f_19797_ > 2 ? 1.0f : 0.0f);
    }

    public static void renderCrystalBeams(float p_229059_0_, float p_229059_1_, float p_229059_2_, float p_229059_3_, int p_229059_4_, PoseStack p_229059_5_, MultiBufferSource p_229059_6_, int p_229059_7_) {
        float f = Mth.m_14116_((float)(p_229059_0_ * p_229059_0_ + p_229059_2_ * p_229059_2_));
        float f1 = Mth.m_14116_((float)(p_229059_0_ * p_229059_0_ + p_229059_1_ * p_229059_1_ + p_229059_2_ * p_229059_2_));
        p_229059_5_.m_85836_();
        p_229059_5_.m_85837_(0.0, 1.0, 0.0);
        p_229059_5_.m_85845_(Vector3f.f_122225_.m_122270_((float)(-Math.atan2(p_229059_2_, p_229059_0_)) - 1.5707964f));
        p_229059_5_.m_85845_(Vector3f.f_122223_.m_122270_((float)(-Math.atan2(f, p_229059_1_)) - 1.5707964f));
        VertexConsumer ivertexbuilder = p_229059_6_.m_6299_(BEAM);
        float f2 = 0.0f - ((float)p_229059_4_ + p_229059_3_) * 0.01f;
        float f3 = Mth.m_14116_((float)(p_229059_0_ * p_229059_0_ + p_229059_1_ * p_229059_1_ + p_229059_2_ * p_229059_2_)) / 32.0f - ((float)p_229059_4_ + p_229059_3_) * 0.01f;
        float f4 = 0.0f;
        float f5 = 0.75f;
        float f6 = 0.0f;
        PoseStack.Pose matrixstack$entry = p_229059_5_.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        for (int j = 1; j <= 8; ++j) {
            float f7 = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float f8 = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / 8.0f)) * 0.75f;
            float f9 = (float)j / 8.0f;
            ivertexbuilder.m_85982_(matrix4f, f4 * 0.2f, f5 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_229059_7_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            ivertexbuilder.m_85982_(matrix4f, f4, f5, f1).m_6122_(255, 255, 255, 255).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(p_229059_7_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            ivertexbuilder.m_85982_(matrix4f, f7, f8, f1).m_6122_(255, 255, 255, 255).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(p_229059_7_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            ivertexbuilder.m_85982_(matrix4f, f7 * 0.2f, f8 * 0.2f, 0.0f).m_6122_(0, 0, 0, 255).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_229059_7_).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        p_229059_5_.m_85849_();
    }

    public static float getY(BFGEntity p_229051_0_, float p_229051_1_) {
        float f = (float)p_229051_0_.f_19797_ + p_229051_1_;
        float f1 = Mth.m_14031_((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }
}

