/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity;

import java.util.UUID;
import mod.azure.doom.entity.tileentity.TickingLightEntity;
import mod.azure.doom.util.registry.DoomBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.network.NetworkHooks;

public class DemonEntity
extends PathfinderMob
implements NeutralMob {
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(DemonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(DemonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private UUID targetUuid;
    private BlockPos lightBlockPos = null;

    protected DemonEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_19811_ = false;
        this.f_21364_ = (int)this.m_21233_();
    }

    public static boolean passPeacefulAndYCheck(EntityType<? extends DemonEntity> config, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (reason != MobSpawnType.CHUNK_GENERATION && reason != MobSpawnType.NATURAL) {
            return !world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50451_);
        }
        return !world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50451_);
    }

    public boolean m_203441_(FluidState state) {
        return state.m_205070_(FluidTags.f_13132_);
    }

    public int getAttckingState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setAttackingState(int time) {
        this.f_19804_.m_135381_(STATE, (Object)time);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.targetUuid;
    }

    public void m_6925_(UUID target) {
        this.targetUuid = target;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    protected boolean m_8028_() {
        return true;
    }

    public void performRangedAttack(LivingEntity target, float pullProgress) {
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, 0.25f, this.m_6100_());
        }
    }

    public void spawnLightSource(Entity entity, boolean isInWaterBlock) {
        if (this.lightBlockPos == null) {
            this.lightBlockPos = this.findFreeSpace(entity.f_19853_, entity.m_20183_(), 2);
            if (this.lightBlockPos == null) {
                return;
            }
            entity.f_19853_.m_46597_(this.lightBlockPos, ((Block)DoomBlocks.TICKING_LIGHT_BLOCK.get()).m_49966_());
        } else if (this.checkDistance(this.lightBlockPos, entity.m_20183_(), 2)) {
            BlockEntity blockEntity = entity.f_19853_.m_7702_(this.lightBlockPos);
            if (blockEntity instanceof TickingLightEntity) {
                ((TickingLightEntity)blockEntity).refresh(isInWaterBlock ? 20 : 0);
            } else {
                this.lightBlockPos = null;
            }
        } else {
            this.lightBlockPos = null;
        }
    }

    private boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB, int distance) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= distance && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= distance && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= distance;
    }

    private BlockPos findFreeSpace(Level world, BlockPos blockPos, int maxDistance) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[maxDistance * 2 + 1];
        offsets[0] = 0;
        for (int i = 2; i <= maxDistance * 2; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals(DoomBlocks.TICKING_LIGHT_BLOCK)) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 35) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return source == DamageSource.f_19310_ || source == DamageSource.f_19307_ || source == DamageSource.f_19305_ ? false : super.m_6469_(source, amount);
    }
}

