/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.ai.goal;

import java.util.EnumSet;
import java.util.SplittableRandom;
import mod.azure.doom.entity.attack.AbstractRangedAttack;
import mod.azure.doom.entity.tierboss.IconofsinEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Explosion;

public class IconAttackGoal
extends Goal {
    private final IconofsinEntity entity;
    private double moveSpeedAmp = 1.0;
    private int attackTime = -1;
    private int summonTime = -1;
    private AbstractRangedAttack attack;

    public IconAttackGoal(IconofsinEntity mob, AbstractRangedAttack attack, double moveSpeedAmpIn) {
        this.entity = mob;
        this.moveSpeedAmp = moveSpeedAmpIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attack = attack;
    }

    public boolean m_8036_() {
        return this.entity.m_5448_() != null;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.entity.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.m_21561_(false);
        this.entity.setAttackingState(0);
        this.attackTime = -1;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.entity.m_5448_();
        if (livingentity != null) {
            ++this.attackTime;
            this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            this.entity.m_21573_().m_5624_((Entity)livingentity, this.moveSpeedAmp);
            SplittableRandom random = new SplittableRandom();
            int randomAttack = random.nextInt(0, 4);
            if (this.attackTime == 1) {
                this.entity.setAttackingState(0);
                ++this.summonTime;
            }
            if (this.attackTime == 4) {
                if (this.summonTime == 10) {
                    this.entity.spawnWave(random.nextInt(0, 11), livingentity);
                    this.summonTime = -300;
                }
                if (randomAttack == 1) {
                    for (int i = 1; i < 5; ++i) {
                        float f1 = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.entity.m_20189_()), (double)(livingentity.m_20185_() - this.entity.m_20185_())) + (float)i * (float)Math.PI * 0.4f;
                        for (int y = 0; y < 5; ++y) {
                            this.entity.spawnFlames(livingentity.m_20185_() + (double)Mth.m_14089_((float)f1) * livingentity.m_217043_().m_188500_() * 1.5, livingentity.m_20189_() + (double)Mth.m_14031_((float)f1) * livingentity.m_217043_().m_188500_() * 1.5, Math.min(livingentity.m_20186_(), livingentity.m_20186_()), Math.max(livingentity.m_20186_(), livingentity.m_20186_()) + 1.0, f1, 0);
                        }
                    }
                    boolean isInsideWaterBlock = this.entity.f_19853_.m_46801_(this.entity.m_20183_());
                    this.entity.spawnLightSource((Entity)this.entity, isInsideWaterBlock);
                    if ((double)this.entity.m_21223_() < (double)this.entity.m_21233_() * 0.5) {
                        this.entity.setAttackingState(6);
                    } else {
                        this.entity.setAttackingState(5);
                    }
                } else if (randomAttack == 2) {
                    this.attack.shoot();
                    boolean isInsideWaterBlock = this.entity.f_19853_.m_46801_(this.entity.m_20183_());
                    this.entity.spawnLightSource((Entity)this.entity, isInsideWaterBlock);
                    if ((double)this.entity.m_21223_() < (double)this.entity.m_21233_() * 0.5) {
                        this.entity.setAttackingState(2);
                    } else {
                        this.entity.setAttackingState(1);
                    }
                } else {
                    if ((double)this.entity.m_21223_() < (double)this.entity.m_21233_() * 0.5) {
                        this.entity.setAttackingState(4);
                    } else {
                        this.entity.setAttackingState(3);
                    }
                    this.entity.m_7327_((Entity)livingentity);
                    this.entity.f_19853_.m_46518_((Entity)this.entity, livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 3.0f, false, Explosion.BlockInteraction.BREAK);
                    livingentity.f_19802_ = 0;
                }
            }
            if (this.attackTime == 8) {
                this.entity.setAttackingState(0);
            }
            if (this.attackTime >= 25) {
                this.attackTime = -15;
            }
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.entity.m_20205_() * 2.0f * this.entity.m_20205_() * 2.0f + attackTarget.m_20205_();
    }
}

