/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.ai.goal;

import java.util.EnumSet;
import mod.azure.doom.entity.attack.AbstractRangedAttack;
import mod.azure.doom.entity.projectiles.entity.BarenBlastEntity;
import mod.azure.doom.entity.tierheavy.MancubusEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MancubusFireAttackGoal
extends Goal {
    private final MancubusEntity entity;
    private int attackTime = -1;
    private AbstractRangedAttack attack;

    public MancubusFireAttackGoal(MancubusEntity mob, AbstractRangedAttack attack) {
        this.entity = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attack = attack;
    }

    public boolean m_8036_() {
        return this.entity.m_5448_() != null;
    }

    public void m_8056_() {
        super.m_8056_();
        this.entity.m_21561_(true);
        this.entity.m_21573_().m_26573_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.m_21561_(false);
        this.entity.setAttackingState(0);
        this.attackTime = -1;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.entity.m_5448_();
        if (livingentity != null) {
            boolean inLineOfSight = this.entity.m_21574_().m_148306_((Entity)livingentity);
            ++this.attackTime;
            this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            Level world = this.entity.f_19853_;
            Vec3 vector3d = this.entity.m_20252_(1.0f);
            double d = Math.min(livingentity.m_20186_(), this.entity.m_20186_());
            double e1 = Math.max(livingentity.m_20186_(), this.entity.m_20186_()) + 1.0;
            float f2 = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.entity.m_20189_()), (double)(livingentity.m_20185_() - this.entity.m_20185_()));
            double f = livingentity.m_20185_() - (this.entity.m_20185_() + vector3d.f_82479_ * 2.0);
            double g = livingentity.m_20227_(0.5) - (0.5 + this.entity.m_20227_(0.5));
            double h = livingentity.m_20189_() - (this.entity.m_20189_() + vector3d.f_82481_ * 2.0);
            BarenBlastEntity fireballEntity = new BarenBlastEntity(this.entity.f_19853_, (LivingEntity)this.entity, f, g, h, 6.0f);
            if (inLineOfSight) {
                if ((double)this.entity.m_20270_((Entity)livingentity) < 3.0) {
                    this.entity.m_21573_().m_26573_();
                    this.entity.m_21563_().m_24946_(livingentity.m_20185_(), livingentity.m_20188_(), livingentity.m_20189_());
                    if (this.attackTime == 1) {
                        this.entity.setAttackingState(0);
                    }
                    if (this.attackTime == 4) {
                        for (int j = 0; j < 5; ++j) {
                            float h2 = f2 + (float)j * (float)Math.PI * 0.4f;
                            this.entity.spawnFlames(this.entity.m_20185_() + (double)Mth.m_14089_((float)h2) * 1.5, this.entity.m_20189_() + (double)Mth.m_14031_((float)h2) * 1.5, d, e1, h2, 0);
                        }
                        boolean isInsideWaterBlock = this.entity.f_19853_.m_46801_(this.entity.m_20183_());
                        this.entity.spawnLightSource((Entity)this.entity, isInsideWaterBlock);
                        this.entity.setAttackingState(3);
                    }
                    if (this.attackTime >= 8) {
                        this.attackTime = -15;
                        this.entity.setAttackingState(0);
                    }
                } else if ((double)this.entity.m_20270_((Entity)livingentity) < 13.0 && (double)this.entity.m_20270_((Entity)livingentity) > 3.0) {
                    this.entity.m_21573_().m_26573_();
                    this.entity.m_21563_().m_24946_(livingentity.m_20185_(), livingentity.m_20188_(), livingentity.m_20189_());
                    if (this.attackTime == 1) {
                        this.entity.setAttackingState(0);
                    }
                    if (this.attackTime == 4) {
                        this.entity.m_5496_(SoundEvents.f_11936_, 1.0f, 1.0f);
                        this.attack.shoot();
                        boolean isInsideWaterBlock = this.entity.f_19853_.m_46801_(this.entity.m_20183_());
                        this.entity.spawnLightSource((Entity)this.entity, isInsideWaterBlock);
                        this.entity.setAttackingState(2);
                    }
                    if (this.attackTime >= 8) {
                        this.attackTime = -15;
                        this.entity.setAttackingState(0);
                    }
                } else {
                    this.entity.m_21573_().m_26573_();
                    this.entity.m_21563_().m_24946_(livingentity.m_20185_(), livingentity.m_20188_(), livingentity.m_20189_());
                    if (this.attackTime == 1) {
                        this.entity.setAttackingState(0);
                    }
                    if (this.attackTime == 4) {
                        fireballEntity.m_6034_(this.entity.m_20185_() + vector3d.f_82479_ * 2.0, this.entity.m_20227_(0.5) + 0.5, this.entity.m_20189_() + vector3d.f_82481_ * 2.0);
                        world.m_7967_((Entity)fireballEntity);
                        boolean isInsideWaterBlock = this.entity.f_19853_.m_46801_(this.entity.m_20183_());
                        this.entity.spawnLightSource((Entity)this.entity, isInsideWaterBlock);
                        this.entity.setAttackingState(1);
                    }
                    if (this.attackTime >= 8) {
                        this.attackTime = -15;
                        this.entity.setAttackingState(0);
                        this.entity.m_21573_().m_5624_((Entity)livingentity, 1.0);
                    }
                }
            }
        }
    }
}

