/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.ai.goal;

import java.util.EnumSet;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.attack.AbstractRangedAttack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class RangedStrafeAttackGoal
extends Goal {
    private final DemonEntity entity;
    public double moveSpeedAmp = 1.0;
    public int attackCooldown;
    public int visibleTicksDelay;
    private float maxAttackDistance = 20.0f;
    private int strafeTicks = 20;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int statecheck;
    private AbstractRangedAttack attack;
    private boolean multiShot = false;
    private int multiShotCount = 0;
    private int multiShotTickDelay = 0;
    private boolean multiShooting = false;
    private int multiShotsLeft = 0;
    private int multiShotTicker = 0;

    public RangedStrafeAttackGoal(DemonEntity mob, AbstractRangedAttack attack, double moveSpeedAmpIn, int attackCooldownIn, int visibleTicksDelay, int strafeTicks, float maxAttackDistanceIn, int state) {
        this.entity = mob;
        this.moveSpeedAmp = moveSpeedAmpIn;
        this.attackCooldown = -15;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attack = attack;
        this.visibleTicksDelay = 0;
        this.strafeTicks = strafeTicks;
        this.statecheck = state;
    }

    public RangedStrafeAttackGoal(DemonEntity mob, AbstractRangedAttack attack, int attackCooldownIn) {
        this.entity = mob;
        this.attackCooldown = attackCooldownIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attack = attack;
    }

    public RangedStrafeAttackGoal(DemonEntity mob, AbstractRangedAttack attack, double moveSpeedAmpIn, int state) {
        this.entity = mob;
        this.moveSpeedAmp = moveSpeedAmpIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attack = attack;
        this.statecheck = state;
    }

    public RangedStrafeAttackGoal setMultiShot(int count, int tickDelay) {
        this.multiShot = true;
        this.multiShotCount = count;
        this.multiShotTickDelay = tickDelay;
        return this;
    }

    public boolean tickMultiShot() {
        if (this.multiShotsLeft > 0 && this.multiShotTicker == 0) {
            --this.multiShotsLeft;
            if (this.multiShotsLeft == 0) {
                this.finishMultiShot();
            }
            this.multiShotTicker = this.multiShotTickDelay;
            return true;
        }
        --this.multiShotTicker;
        return false;
    }

    public void beginMultiShooting() {
        this.multiShooting = true;
        this.multiShotsLeft = this.multiShotCount - 1;
        this.multiShotTicker = this.multiShotTickDelay;
    }

    public void finishMultiShot() {
        this.multiShooting = false;
        this.multiShotsLeft = 0;
    }

    public void setAttackCooldown(int attackCooldownIn) {
        this.attackCooldown = attackCooldownIn;
    }

    public boolean m_8036_() {
        return this.entity.m_5448_() != null;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.entity.m_21573_().m_26571_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.entity.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.m_21561_(false);
        this.entity.setAttackingState(0);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.m_5810_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.entity.m_5448_();
        if (livingentity != null) {
            this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            double distanceToTargetSq = this.entity.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            boolean inLineOfSight = this.entity.m_21574_().m_148306_((Entity)livingentity);
            if (inLineOfSight != this.seeTime > 0) {
                this.seeTime = 0;
            }
            if (inLineOfSight) {
                ++this.seeTime;
            } else {
                if (this.multiShot) {
                    this.finishMultiShot();
                }
                --this.seeTime;
            }
            if (distanceToTargetSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.entity.m_21573_().m_5624_((Entity)livingentity, (double)0.95f);
                this.entity.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= this.strafeTicks) {
                if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distanceToTargetSq > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distanceToTargetSq < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            } else {
                this.entity.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            }
            ++this.attackTime;
            if (this.multiShooting) {
                if (this.tickMultiShot()) {
                    this.attack.shoot();
                }
                return;
            }
            if (this.attackTime == 1) {
                this.entity.setAttackingState(this.statecheck);
            }
            if (this.attackTime == 4) {
                if (this.tickMultiShot()) {
                    this.attack.shoot();
                    boolean isInsideWaterBlock = this.entity.f_19853_.m_46801_(this.entity.m_20183_());
                    this.entity.spawnLightSource((Entity)this.entity, isInsideWaterBlock);
                } else {
                    this.attack.shoot();
                    boolean isInsideWaterBlock = this.entity.f_19853_.m_46801_(this.entity.m_20183_());
                    this.entity.spawnLightSource((Entity)this.entity, isInsideWaterBlock);
                }
            }
            if (this.attackTime >= 8) {
                this.entity.setAttackingState(0);
                this.attackTime = -15;
            }
        }
    }
}

