/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.ai.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import mod.azure.doom.entity.DemonEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class ThrowItemGoal
extends Goal {
    private final Mob mob;
    private final DemonEntity rangedAttackMob;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;

    public ThrowItemGoal(DemonEntity mob, double mobSpeed) {
        this.rangedAttackMob = mob;
        this.mob = mob;
        this.speedModifier = mobSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.rangedAttackMob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.rangedAttackMob.m_21561_(false);
        this.rangedAttackMob.setAttackingState(0);
        this.attackTime = -1;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.rangedAttackMob.m_5448_();
        if (livingentity != null) {
            boolean inLineOfSight = this.rangedAttackMob.m_21574_().m_148306_((Entity)livingentity);
            double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            double d1 = this.getAttackReachSqr(livingentity);
            ++this.attackTime;
            this.rangedAttackMob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (inLineOfSight) {
                if ((double)this.rangedAttackMob.m_20270_((Entity)livingentity) >= 5.0) {
                    this.rangedAttackMob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    if (this.attackTime == 4) {
                        this.rangedAttackMob.setAttackingState(1);
                        this.rangedAttackMob.m_21573_().m_26573_();
                        float f = (float)Math.sqrt(d0) / 100.0f;
                        float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)100.0f);
                        this.rangedAttackMob.performRangedAttack(this.target, f1);
                        livingentity.f_19802_ = 0;
                    }
                    if (this.attackTime >= 8) {
                        this.attackTime = -15;
                        this.rangedAttackMob.setAttackingState(0);
                    }
                } else {
                    this.rangedAttackMob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    this.rangedAttackMob.m_20225_(true);
                    if (this.attackTime == 4) {
                        this.rangedAttackMob.setAttackingState(1);
                        this.rangedAttackMob.m_21573_().m_26573_();
                        if (d0 <= d1) {
                            this.rangedAttackMob.m_7327_((Entity)livingentity);
                        }
                        livingentity.f_19802_ = 0;
                    }
                    if (this.attackTime >= 8) {
                        this.attackTime = -15;
                        this.rangedAttackMob.setAttackingState(0);
                    }
                }
            }
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.rangedAttackMob.m_20205_() * 1.25f * this.rangedAttackMob.m_20205_() * 1.25f + attackTarget.m_20205_();
    }
}

