/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.projectiles;

import java.util.List;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.tierboss.IconofsinEntity;
import mod.azure.doom.entity.tileentity.TickingLightEntity;
import mod.azure.doom.util.registry.DoomBlocks;
import mod.azure.doom.util.registry.DoomEntities;
import mod.azure.doom.util.registry.DoomItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class ArgentBoltEntity
extends AbstractArrow {
    protected int timeInAir;
    protected boolean inAir;
    private int ticksInAir;
    public static final EntityDataAccessor<Boolean> PARTICLE = SynchedEntityData.m_135353_(ArgentBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity shooter;
    private BlockPos lightBlockPos = null;
    private int idleTicks = 0;
    public SoundEvent hitSound = this.m_7239_();

    public ArgentBoltEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
    }

    public ArgentBoltEntity(Level world, LivingEntity shooter) {
        super((EntityType)DoomEntities.ARGENT_BOLT.get(), shooter, world);
        this.shooter = shooter;
    }

    protected void m_6901_() {
        ++this.ticksInAir;
        if (this.f_19797_ >= 40) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        if (!(living instanceof Player) && !(living instanceof IconofsinEntity)) {
            living.m_20334_(0.0, 0.0, 0.0);
            living.f_19802_ = 0;
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.ticksInAir = 0;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("life", (short)this.ticksInAir);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksInAir = compound.m_128448_("life");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARTICLE, (Object)false);
    }

    public boolean useParticle() {
        return (Boolean)this.f_19804_.m_135370_(PARTICLE);
    }

    public void setParticle(boolean spin) {
        this.f_19804_.m_135381_(PARTICLE, (Object)spin);
    }

    public void m_8119_() {
        int idleOpt = 100;
        this.idleTicks = this.m_20184_().m_82556_() < 0.01 ? ++this.idleTicks : 0;
        if (idleOpt <= 0 || this.idleTicks < idleOpt) {
            super.m_8119_();
        }
        boolean isInsideWaterBlock = this.f_19853_.m_46801_(this.m_20183_());
        this.spawnLightSource(isInsideWaterBlock);
        boolean flag = this.m_36797_();
        Vec3 vector3d = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = vector3d.m_165924_();
            this.f_19857_ = (float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875);
            this.f_19858_ = (float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875);
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (this.f_19797_ >= 600) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.inAir && !flag) {
            this.m_6901_();
            ++this.timeInAir;
        } else {
            Vec3 vector3d3;
            this.timeInAir = 0;
            Vec3 vector3d2 = this.m_20182_();
            BlockHitResult raytraceresult = this.f_19853_.m_45547_(new ClipContext(vector3d2, vector3d3 = vector3d2.m_82549_(vector3d), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                vector3d3 = raytraceresult.m_82450_();
            }
            while (this.m_6084_()) {
                EntityHitResult entityraytraceresult = this.m_6351_(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                    Entity entity1 = this.m_37282_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                    this.m_6532_((HitResult)raytraceresult);
                    this.f_19812_ = true;
                }
                if (entityraytraceresult == null || this.m_36796_() <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.m_20184_();
            double d3 = vector3d.f_82479_;
            double d4 = vector3d.f_82480_;
            double d0 = vector3d.f_82481_;
            double d5 = this.m_20185_() + d3;
            double d1 = this.m_20186_() + d4;
            double d2 = this.m_20189_() + d0;
            double f1 = vector3d.m_165924_();
            this.f_19857_ = flag ? (float)(Mth.m_14136_((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(Mth.m_14136_((double)d3, (double)d0) * 57.2957763671875);
            this.f_19858_ = (float)(Mth.m_14136_((double)d4, (double)f1) * 57.2957763671875);
            this.f_19858_ = ArgentBoltEntity.m_37273_((float)this.f_19860_, (float)this.m_146909_());
            this.f_19857_ = ArgentBoltEntity.m_37273_((float)this.f_19859_, (float)this.m_146908_());
            float f2 = 0.99f;
            this.m_20256_(vector3d.m_82490_((double)f2));
            if (!this.m_20068_() && !flag) {
                Vec3 vector3d4 = this.m_20184_();
                this.m_20334_(vector3d4.f_82479_, vector3d4.f_82480_ - (double)0.05f, vector3d4.f_82481_);
            }
            this.m_6034_(d5, d1, d2);
            this.m_20101_();
            if (this.f_19853_.m_5776_()) {
                this.f_19853_.m_6493_((ParticleOptions)(this.useParticle() ? ParticleTypes.f_123792_ : ParticleTypes.f_123747_), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnLightSource(boolean isInWaterBlock) {
        if (this.lightBlockPos == null) {
            this.lightBlockPos = this.findFreeSpace(this.f_19853_, this.m_20183_(), 2);
            if (this.lightBlockPos == null) {
                return;
            }
            this.f_19853_.m_46597_(this.lightBlockPos, ((Block)DoomBlocks.TICKING_LIGHT_BLOCK.get()).m_49966_());
        } else if (this.checkDistance(this.lightBlockPos, this.m_20183_(), 2)) {
            BlockEntity blockEntity = this.f_19853_.m_7702_(this.lightBlockPos);
            if (blockEntity instanceof TickingLightEntity) {
                ((TickingLightEntity)blockEntity).refresh(isInWaterBlock ? 20 : 0);
            } else {
                this.lightBlockPos = null;
            }
        } else {
            this.lightBlockPos = null;
        }
    }

    private boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB, int distance) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= distance && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= distance && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= distance;
    }

    private BlockPos findFreeSpace(Level world, BlockPos blockPos, int maxDistance) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[maxDistance * 2 + 1];
        offsets[0] = 0;
        for (int i = 2; i <= maxDistance * 2; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals(DoomBlocks.TICKING_LIGHT_BLOCK.get())) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }

    public ItemStack m_7941_() {
        return new ItemStack((ItemLike)DoomItems.ARGENT_BOLT.get());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_20068_() {
        return !this.m_20069_();
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        super.m_8060_(p_230299_1_);
        if (!this.f_19853_.m_5776_()) {
            if (this.useParticle()) {
                if (this.f_19797_ >= 46) {
                    this.explode();
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else {
                this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 1.5f, Explosion.BlockInteraction.NONE);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        this.m_36740_(SoundEvents.f_11677_);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.useParticle()) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123756_);
            areaeffectcloudentity.m_19712_(6.0f);
            areaeffectcloudentity.m_19734_(1);
            areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.5f);
        }
        super.m_142687_(reason);
    }

    protected void explode() {
        double xn = Mth.m_14107_((double)(this.m_20185_() - 5.0));
        double xp = Mth.m_14107_((double)(this.m_20185_() + 7.0));
        double yn = Mth.m_14107_((double)(this.m_20186_() - 5.0));
        double yp = Mth.m_14107_((double)(this.m_20186_() + 7.0));
        double zn = Mth.m_14107_((double)(this.m_20189_() - 5.0));
        double zp = Mth.m_14107_((double)(this.m_20189_() + 7.0));
        List list = this.f_19853_.m_45933_((Entity)this, new AABB(xn, yn, zn, xp, yp, zp));
        Vec3 vec3d = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        for (int x = 0; x < list.size(); ++x) {
            Entity entity = (Entity)list.get(x);
            double y = Mth.m_14116_((float)((float)entity.m_20238_(vec3d))) / 6.0f;
            if (!(entity instanceof LivingEntity) || !(y <= 1.0)) continue;
            entity.m_6469_(DamageSource.m_19344_((Player)((Player)this.shooter)), ((Double)DoomConfig.SERVER.argent_bolt_damage.get()).floatValue());
        }
    }

    public void m_36740_(SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11677_;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        DamageSource damagesource;
        Entity entity1;
        Entity entity = entityHitResult.m_82443_();
        if (!(entityHitResult.m_6662_() == HitResult.Type.ENTITY && entityHitResult.m_82443_().m_7306_(entity) || this.f_19853_.f_46443_)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if ((entity1 = this.m_37282_()) == null) {
            damagesource = DamageSource.m_19346_((AbstractArrow)this, (Entity)this);
        } else {
            damagesource = DamageSource.m_19346_((AbstractArrow)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(entity);
            }
        }
        if (entity.m_6469_(damagesource, ((Double)DoomConfig.SERVER.argent_bolt_damage.get()).floatValue())) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.f_19853_.f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                    this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 1.5f, Explosion.BlockInteraction.NONE);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
                this.m_7761_(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity1).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
            }
        } else if (!this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        Entity entity = this.m_37282_();
        if (!(result.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)result).m_82443_().m_7306_(entity) || this.f_19853_.f_46443_)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

