/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.projectiles;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.tierambient.GoreNestEntity;
import mod.azure.doom.entity.tierboss.ArchMakyrEntity;
import mod.azure.doom.entity.tierboss.GladiatorEntity;
import mod.azure.doom.entity.tierboss.IconofsinEntity;
import mod.azure.doom.entity.tierboss.MotherDemonEntity;
import mod.azure.doom.entity.tileentity.TickingLightEntity;
import mod.azure.doom.util.registry.DoomBlocks;
import mod.azure.doom.util.registry.DoomEntities;
import mod.azure.doom.util.registry.DoomItems;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BFGEntity
extends AbstractArrow
implements IAnimatable {
    protected int timeInAir;
    protected boolean inAir;
    private int ticksInAir;
    private static final EntityDataAccessor<Integer> TARGET_ENTITY = SynchedEntityData.m_135353_(BFGEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity targetedEntity;
    private LivingEntity shooter;
    private BlockPos lightBlockPos = null;
    private int idleTicks = 0;
    Random rand = new Random();
    List<? extends String> whitelistEntries;
    int randomIndex;
    ResourceLocation randomElement1;
    EntityType<?> randomElement;
    private AnimationFactory factory;
    public SoundEvent hitSound;

    public BFGEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
        this.whitelistEntries = (List)DoomConfig.SERVER.bfg_damage_mob_whitelist.get();
        this.randomIndex = this.rand.nextInt(this.whitelistEntries.size());
        this.randomElement1 = new ResourceLocation(this.whitelistEntries.get(this.randomIndex));
        this.randomElement = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.randomElement1);
        this.factory = GeckoLibUtil.createFactory((IAnimatable)this);
        this.hitSound = this.m_7239_();
    }

    public BFGEntity(Level world, LivingEntity shooter) {
        super((EntityType)DoomEntities.BFG_CELL.get(), shooter, world);
        this.whitelistEntries = (List)DoomConfig.SERVER.bfg_damage_mob_whitelist.get();
        this.randomIndex = this.rand.nextInt(this.whitelistEntries.size());
        this.randomElement1 = new ResourceLocation(this.whitelistEntries.get(this.randomIndex));
        this.randomElement = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.randomElement1);
        this.factory = GeckoLibUtil.createFactory((IAnimatable)this);
        this.hitSound = this.m_7239_();
        this.shooter = shooter;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_6901_() {
        ++this.ticksInAir;
        if (this.f_19797_ >= 40) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public DamageSource getDamageSource() {
        return DamageSource.m_19346_((AbstractArrow)this, (Entity)this);
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        if (!(living instanceof Player) && !(living instanceof IconofsinEntity)) {
            living.m_20334_(0.0, 0.0, 0.0);
            living.f_19802_ = 0;
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.ticksInAir = 0;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("life", (short)this.ticksInAir);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksInAir = compound.m_128448_("life");
    }

    public void m_8119_() {
        int idleOpt = 100;
        this.idleTicks = this.m_20184_().m_82556_() < 0.01 ? ++this.idleTicks : 0;
        if (idleOpt <= 0 || this.idleTicks < idleOpt) {
            super.m_8119_();
        }
        boolean isInsideWaterBlock = this.f_19853_.m_46801_(this.m_20183_());
        this.spawnLightSource(isInsideWaterBlock);
        if (this.f_19797_ >= 80) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(24.0, 24.0, 24.0);
        this.m_20193_().m_45933_((Entity)this, aabb).forEach(e -> {
            Entity listEntity = this.randomElement.m_141992_(e);
            if (!(e instanceof Player) && !(e instanceof EnderDragon) && !(e instanceof GoreNestEntity) && !(e instanceof IconofsinEntity) && !(e instanceof ArchMakyrEntity) && !(e instanceof GladiatorEntity) && !(e instanceof MotherDemonEntity) && (e instanceof Monster || e instanceof Slime || e instanceof Phantom || e instanceof DemonEntity || e instanceof Shulker || e instanceof Hoglin || e == listEntity) && e.m_6084_()) {
                e.m_6469_(DamageSource.m_19373_((LivingEntity)this.shooter), ((Double)DoomConfig.SERVER.bfgball_damage_aoe.get()).floatValue());
                this.setTargetedEntity(e.m_19879_());
            }
            if (e instanceof EnderDragon && e.m_6084_()) {
                ((EnderDragon)e).f_31080_.m_6469_(DamageSource.m_19344_((Player)((Player)this.shooter)), ((Double)DoomConfig.SERVER.bfgball_damage_dragon.get()).floatValue() * 0.3f);
                this.setTargetedEntity(e.m_19879_());
            }
            if ((e instanceof IconofsinEntity || e instanceof ArchMakyrEntity || e instanceof GladiatorEntity || e instanceof MotherDemonEntity) && e.m_6084_()) {
                e.m_6469_(DamageSource.m_19344_((Player)((Player)this.shooter)), ((Double)DoomConfig.SERVER.bfgball_damage_aoe.get()).floatValue() * 0.1f);
            }
        });
    }

    private void spawnLightSource(boolean isInWaterBlock) {
        if (this.lightBlockPos == null) {
            this.lightBlockPos = this.findFreeSpace(this.f_19853_, this.m_20183_(), 2);
            if (this.lightBlockPos == null) {
                return;
            }
            this.f_19853_.m_46597_(this.lightBlockPos, ((Block)DoomBlocks.TICKING_LIGHT_BLOCK.get()).m_49966_());
        } else if (this.checkDistance(this.lightBlockPos, this.m_20183_(), 2)) {
            BlockEntity blockEntity = this.f_19853_.m_7702_(this.lightBlockPos);
            if (blockEntity instanceof TickingLightEntity) {
                ((TickingLightEntity)blockEntity).refresh(isInWaterBlock ? 20 : 0);
            } else {
                this.lightBlockPos = null;
            }
        } else {
            this.lightBlockPos = null;
        }
    }

    private boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB, int distance) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= distance && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= distance && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= distance;
    }

    private BlockPos findFreeSpace(Level world, BlockPos blockPos, int maxDistance) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[maxDistance * 2 + 1];
        offsets[0] = 0;
        for (int i = 2; i <= maxDistance * 2; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals(DoomBlocks.TICKING_LIGHT_BLOCK.get())) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_20068_() {
        return !this.m_20069_();
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        super.m_8060_(p_230299_1_);
        this.m_36740_((SoundEvent)DoomSounds.BFG_HIT.get());
    }

    public void m_36740_(SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)DoomSounds.BFG_HIT.get();
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        if (!this.f_19853_.f_46443_) {
            this.doDamage();
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 1.0f, (Boolean)DoomConfig.SERVER.enable_block_breaking.get() != false ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.m_5496_((SoundEvent)DoomSounds.BFG_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        Entity entity = this.m_37282_();
        if (result.m_6662_() != HitResult.Type.ENTITY || !((EntityHitResult)result).m_82443_().m_7306_(entity)) {
            if (!this.f_19853_.f_46443_) {
                this.doDamage();
                this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 1.0f, (Boolean)DoomConfig.SERVER.enable_block_breaking.get() != false ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            this.m_5496_((SoundEvent)DoomSounds.BFG_HIT.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        }
    }

    public void doDamage() {
        AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(24.0, 24.0, 24.0);
        this.m_20193_().m_45933_((Entity)this, aabb).forEach(e -> {
            Entity listEntity = this.randomElement.m_141992_(e);
            if (!(e instanceof Player || e instanceof EnderDragon || e instanceof GoreNestEntity || e instanceof IconofsinEntity || e instanceof ArchMakyrEntity || e instanceof GladiatorEntity || e instanceof MotherDemonEntity || !(e instanceof Monster) && !(e instanceof Slime) && !(e instanceof Phantom) && !(e instanceof DemonEntity) && !(e instanceof Shulker) && !(e instanceof Hoglin) && e != listEntity)) {
                e.m_6469_(DamageSource.m_19344_((Player)((Player)this.shooter)), ((Double)DoomConfig.SERVER.bfgball_damage.get()).floatValue());
                this.setTargetedEntity(e.m_19879_());
                if (!this.f_19853_.f_46443_) {
                    List list1 = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0));
                    AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(e.f_19853_, e.m_20185_(), e.m_20186_(), e.m_20189_());
                    areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123767_);
                    areaeffectcloudentity.m_19712_(3.0f);
                    areaeffectcloudentity.m_19734_(10);
                    if (!list1.isEmpty()) {
                        for (LivingEntity livingentity : list1) {
                            double d0 = this.m_20280_((Entity)livingentity);
                            if (!(d0 < 16.0)) continue;
                            areaeffectcloudentity.m_6034_(e.m_20185_(), e.m_20188_(), e.m_20189_());
                        }
                    }
                    e.f_19853_.m_7967_((Entity)areaeffectcloudentity);
                }
            }
            if (e instanceof EnderDragon && e.m_6084_()) {
                ((EnderDragon)e).f_31080_.m_6469_(DamageSource.m_19344_((Player)((Player)this.shooter)), ((Double)DoomConfig.SERVER.bfgball_damage_dragon.get()).floatValue() * 0.3f);
            }
            if ((e instanceof IconofsinEntity || e instanceof ArchMakyrEntity || e instanceof GladiatorEntity || e instanceof MotherDemonEntity) && e.m_6084_()) {
                e.m_6469_(DamageSource.m_19344_((Player)((Player)this.shooter)), ((Double)DoomConfig.SERVER.bfgball_damage.get()).floatValue() * 0.1f);
            }
        });
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)DoomItems.BFG_CELL.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ENTITY, (Object)0);
    }

    private void setTargetedEntity(int entityId) {
        this.f_19804_.m_135381_(TARGET_ENTITY, (Object)entityId);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ENTITY) != 0;
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ENTITY)).intValue());
            if (!(entity instanceof ServerPlayer) && entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.getAttackTarget();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (TARGET_ENTITY.equals(key)) {
            this.targetedEntity = null;
        }
    }

    @Nullable
    public LivingEntity getAttackTarget() {
        return this.targetedEntity;
    }
}

