/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.projectiles.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.util.registry.DoomEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DoomFireEntity
extends Entity
implements IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 75;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private float damage;

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public DoomFireEntity(EntityType<DoomFireEntity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public DoomFireEntity(Level worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn, float damage) {
        this((EntityType<DoomFireEntity>)((EntityType)DoomEntities.FIRING.get()), worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        this.f_19857_ = p_i47276_8_ * 57.295776f;
        this.m_6034_(x, y, z);
        this.damage = damage;
    }

    protected void m_8097_() {
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.explode();
        super.m_142687_(reason);
    }

    protected void explode() {
        this.f_19853_.m_45933_((Entity)this, new AABB(this.m_20183_().m_7494_()).m_82400_(8.0)).forEach(e -> this.doDamage(this, (Entity)e));
    }

    private void doDamage(Entity user, Entity target) {
        if (target instanceof LivingEntity) {
            if (target instanceof DemonEntity) {
                return;
            }
            target.f_19802_ = 0;
            target.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)((LivingEntity)target)), this.damage);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (--this.warmupDelayTicks < 0) {
            if (!this.sentSpikeEvent) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        if (this.m_6084_() && this.f_19853_.m_8055_(this.m_20183_().m_7494_()).m_60795_()) {
            this.f_19853_.m_46597_(this.m_20183_().m_7494_(), BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)this.m_20183_().m_7494_()));
        }
        this.f_19853_.m_45933_((Entity)this, new AABB(this.m_20183_().m_7494_()).m_82400_(1.0)).forEach(e -> {
            if (e.m_6084_() && !(e instanceof DemonEntity)) {
                e.m_6469_(DamageSource.m_19340_((Entity)e, (LivingEntity)this.getCaster()), this.damage);
                e.m_7311_(60);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float partialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - partialTicks) / 20.0f;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return source == DamageSource.f_19310_ || source == DamageSource.f_19307_ || source == DamageSource.f_19305_ ? false : super.m_6469_(source, amount);
    }
}

