/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.projectiles.entity;

import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.entity.tileentity.TickingLightEntity;
import mod.azure.doom.util.registry.DoomBlocks;
import mod.azure.doom.util.registry.DoomEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class FireProjectile
extends AbstractHurtingProjectile {
    protected int timeInAir;
    protected boolean inAir;
    private int ticksInAir;
    private float directHitDamage = 2.0f;
    private BlockPos lightBlockPos = null;
    private int idleTicks = 0;

    public FireProjectile(EntityType<FireProjectile> entitytype, Level world) {
        super(entitytype, world);
    }

    public FireProjectile(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, float directHitDamage) {
        super((EntityType)DoomEntities.FIRE_MOB.get(), shooter, accelX, accelY, accelZ, worldIn);
        this.directHitDamage = directHitDamage;
    }

    public FireProjectile(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType)DoomEntities.FIRE_MOB.get(), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.ticksInAir = 0;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("life", (short)this.ticksInAir);
    }

    public void setDirectHitDamage(float directHitDamage) {
        this.directHitDamage = directHitDamage;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_20068_() {
        return false;
    }

    public void m_8119_() {
        int idleOpt = 100;
        this.idleTicks = this.m_20184_().m_82556_() < 0.01 ? ++this.idleTicks : 0;
        if (idleOpt <= 0 || this.idleTicks < idleOpt) {
            super.m_8119_();
        }
        ++this.ticksInAir;
        if (this.ticksInAir >= 40) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        boolean isInsideWaterBlock = this.f_19853_.m_46801_(this.m_20183_());
        this.spawnLightSource(isInsideWaterBlock);
        if (this.f_19853_.m_5776_()) {
            double x = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            double z = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, x, this.m_20186_(), z, 0.0, 0.0, 0.0);
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, x, this.m_20186_(), z, 0.0, 0.0, 0.0);
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        BlockPos blockpos;
        Entity entity;
        super.m_8060_(blockHitResult);
        if (!this.f_19853_.f_46443_ && (!((entity = this.m_37282_()) instanceof Mob) || ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) && this.f_19853_.m_46859_(blockpos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_()))) {
            this.f_19853_.m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos));
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (!this.f_19853_.f_46443_) {
            Entity entity = entityHitResult.m_82443_();
            Entity entity1 = this.m_37282_();
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (entity1 instanceof LivingEntity && !(entity instanceof DemonEntity)) {
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)((LivingEntity)entity1)), this.directHitDamage);
                entity.m_20254_(15);
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    private void spawnLightSource(boolean isInWaterBlock) {
        if (this.lightBlockPos == null) {
            this.lightBlockPos = this.findFreeSpace(this.f_19853_, this.m_20183_(), 2);
            if (this.lightBlockPos == null) {
                return;
            }
            this.f_19853_.m_46597_(this.lightBlockPos, ((Block)DoomBlocks.TICKING_LIGHT_BLOCK.get()).m_49966_());
        } else if (this.checkDistance(this.lightBlockPos, this.m_20183_(), 2)) {
            BlockEntity blockEntity = this.f_19853_.m_7702_(this.lightBlockPos);
            if (blockEntity instanceof TickingLightEntity) {
                ((TickingLightEntity)blockEntity).refresh(isInWaterBlock ? 20 : 0);
            } else {
                this.lightBlockPos = null;
            }
        } else {
            this.lightBlockPos = null;
        }
    }

    private boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB, int distance) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= distance && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= distance && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= distance;
    }

    private BlockPos findFreeSpace(Level world, BlockPos blockPos, int maxDistance) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[maxDistance * 2 + 1];
        offsets[0] = 0;
        for (int i = 2; i <= maxDistance * 2; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals(DoomBlocks.TICKING_LIGHT_BLOCK.get())) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }

    public boolean m_6051_() {
        return false;
    }
}

