/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tierambient;

import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class TentacleEntity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public TentacleEntity(EntityType<TentacleEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.tentacle_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22282_, 0.0);
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 30) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate1(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller1", 0.0f, this::predicate1));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
    }

    public void m_147240_(double strength, double x, double z) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new AttackGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int m_5792_() {
        return 1;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    static class AttackGoal
    extends Goal {
        private final TentacleEntity entity;
        public int cooldown;

        public AttackGoal(TentacleEntity parentEntity) {
            this.entity = parentEntity;
        }

        public boolean m_8036_() {
            return this.entity.m_5448_() != null;
        }

        public void m_8056_() {
            this.cooldown = 0;
            this.entity.setAttackingState(0);
        }

        public void m_8041_() {
            super.m_8041_();
            this.entity.setAttackingState(0);
        }

        public void m_8037_() {
            LivingEntity livingentity = this.entity.m_5448_();
            if (livingentity != null) {
                this.entity.m_21391_((Entity)livingentity, 30.0f, 90.0f);
                AABB aabb2 = new AABB(this.entity.m_20183_()).m_82400_(2.0);
                if (this.entity.m_142582_((Entity)livingentity)) {
                    ++this.cooldown;
                    if (this.entity.m_20193_().m_45933_((Entity)this.entity, aabb2).contains(livingentity)) {
                        if (this.cooldown == 2) {
                            this.entity.m_20193_().m_45933_((Entity)this.entity, aabb2).forEach(e -> {
                                if (e instanceof LivingEntity) {
                                    e.m_6469_(DamageSource.m_19367_((Entity)this.entity, (Entity)livingentity), ((Double)DoomConfig.SERVER.tentacle_melee_damage.get()).floatValue());
                                    livingentity.f_19802_ = 0;
                                }
                            });
                            this.entity.setAttackingState(1);
                        }
                        if (this.cooldown >= 10) {
                            this.entity.setAttackingState(0);
                            this.cooldown = -5;
                        }
                    } else {
                        --this.cooldown;
                        this.entity.setAttackingState(0);
                    }
                } else if (this.cooldown > 0) {
                    --this.cooldown;
                    this.entity.setAttackingState(0);
                }
            }
        }
    }
}

