/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entity.tierheavy;

import java.util.EnumSet;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.DemonEntity;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Hellknight2016Entity
extends DemonEntity
implements IAnimatable,
IAnimationTickable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving() && !this.m_5912_() && this.f_19861_) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_5912_() && this.f_20924_ > 0.35f && (Integer)this.f_19804_.m_135370_(STATE) == 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (this.f_20924_ > 0.01f && this.f_19864_) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate1(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jumpattack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        AnimationController controller1 = new AnimationController((IAnimatable)this, "controller1", 0.0f, this::predicate1);
        controller.registerSoundListener(this::soundListener);
        controller1.registerSoundListener(this::soundListener);
        data.addAnimationController(controller);
        data.addAnimationController(controller1);
    }

    private <ENTITY extends IAnimatable> void soundListener(SoundKeyframeEvent<ENTITY> event) {
        if (event.sound.matches("walk") && this.f_19853_.m_5776_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DoomSounds.PINKY_STEP.get(), SoundSource.HOSTILE, 0.25f, 1.0f, true);
        }
        if (event.sound.matches("talk") && this.f_19853_.m_5776_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DoomSounds.HELLKNIGHT_AMBIENT.get(), SoundSource.HOSTILE, 0.25f, 1.0f, true);
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public Hellknight2016Entity(EntityType<? extends Hellknight2016Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AttackGoal(this, 1.5));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public int m_6056_() {
        return 99;
    }

    protected void m_8022_() {
        boolean flag = this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        super.m_8022_();
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 30) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        return 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, ((Double)DoomConfig.SERVER.hellknight2016_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DoomConfig.SERVER.hellknight2016_melee_damage.get()).doubleValue()).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.75f;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DoomSounds.HELLKNIGHT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DoomSounds.HELLKNIGHT_DEATH.get();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    public class AttackGoal
    extends Goal {
        private final Hellknight2016Entity entity;
        private final double speedModifier;
        private int attackTime;

        public AttackGoal(Hellknight2016Entity zombieIn, double speedIn) {
            this.entity = zombieIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.speedModifier = speedIn;
        }

        public boolean m_8036_() {
            return this.entity.m_5448_() != null;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.entity.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            this.entity.m_21561_(false);
            this.entity.setAttackingState(0);
            this.attackTime = -1;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.entity.m_5448_();
            if (livingentity != null) {
                boolean inLineOfSight = this.entity.m_21574_().m_148306_((Entity)livingentity);
                ++this.attackTime;
                this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                AABB aabb = new AABB(this.entity.m_20183_()).m_82400_(5.0);
                AABB aabb2 = new AABB(this.entity.m_20183_()).m_82400_(3.0);
                if (inLineOfSight) {
                    this.entity.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    if (this.entity.m_20193_().m_45933_((Entity)this.entity, aabb).contains(livingentity)) {
                        if (this.attackTime == 1) {
                            this.entity.setAttackingState(1);
                        }
                        if (this.attackTime == 4) {
                            Vec3 vec3d = this.entity.m_20184_();
                            Vec3 vec3d2 = new Vec3(livingentity.m_20185_() - this.entity.m_20185_(), 0.0, livingentity.m_20189_() - this.entity.m_20189_());
                            vec3d2 = vec3d2.m_82541_().m_82490_(0.4).m_82549_(vec3d.m_82490_(0.4));
                            this.entity.m_20334_(vec3d2.f_82479_, 0.5, vec3d2.f_82481_);
                            this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                        }
                        if (this.attackTime == 9) {
                            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.entity.f_19853_, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
                            areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123784_);
                            areaeffectcloudentity.m_19712_(3.0f);
                            areaeffectcloudentity.m_19734_(5);
                            areaeffectcloudentity.m_6034_(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
                            this.entity.m_20193_().m_45933_((Entity)this.entity, aabb2).forEach(e -> {
                                if (e instanceof LivingEntity) {
                                    e.m_6469_(DamageSource.m_19370_((LivingEntity)this.entity), ((Double)DoomConfig.SERVER.hellknight2016_melee_damage.get()).floatValue());
                                    this.entity.f_19853_.m_7967_((Entity)areaeffectcloudentity);
                                }
                            });
                            livingentity.f_19802_ = 0;
                        }
                        if (this.attackTime >= 13) {
                            this.attackTime = -5;
                            this.entity.setAttackingState(0);
                            this.entity.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                        }
                    }
                } else {
                    --this.attackTime;
                }
            }
        }
    }
}

