/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.item.powerup;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.azure.doom.DoomMod;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.util.registry.DoomItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class DaisyItem
extends Item {
    public DaisyItem() {
        super(new Item.Properties().m_41491_(DoomMod.DoomPowerUPItemGroup).m_41487_(1));
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"doom.daisy1.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
        tooltip.add((Component)Component.m_237115_((String)"doom.daisy2.text").m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag unused) {
        final ICurio curio = new ICurio(){

            public boolean canRightClickEquip() {
                return true;
            }

            public void onEquip(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof Player && ((Boolean)DoomConfig.SERVER.enable_daisy_effects.get()).booleanValue()) {
                    this.startPowers((Player)livingEntity);
                }
            }

            public void onUnequip(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof Player && ((Boolean)DoomConfig.SERVER.enable_daisy_effects.get()).booleanValue()) {
                    this.stopPowers((Player)livingEntity);
                }
            }

            private void startPowers(Player player) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10000000, 2));
            }

            private void stopPowers(Player player) {
                player.m_21195_(MobEffects.f_19596_);
            }

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    this.startPowers(player);
                }
            }

            public boolean canEquip(String identifier, LivingEntity entityLivingBase) {
                return !CuriosApi.getCuriosHelper().findFirstCurio(entityLivingBase, (Item)DoomItems.DAISY.get()).isPresent();
            }

            public ItemStack getStack() {
                return new ItemStack((ItemLike)DoomItems.DAISY.get());
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public static boolean isRingInCuriosSlot(ItemStack belt, LivingEntity player) {
        return CuriosApi.getCuriosHelper().findFirstCurio(player, belt.m_41720_()).isPresent();
    }
}

