/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.item.weapons;

import java.util.function.Consumer;
import mod.azure.doom.DoomMod;
import mod.azure.doom.client.Keybindings;
import mod.azure.doom.client.render.weapons.SSGRender;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.entity.projectiles.MeatHookEntity;
import mod.azure.doom.entity.projectiles.ShotgunShellEntity;
import mod.azure.doom.item.weapons.DoomBaseItem;
import mod.azure.doom.util.PlayerProperties;
import mod.azure.doom.util.enums.DoomTier;
import mod.azure.doom.util.packets.DoomPacketHandler;
import mod.azure.doom.util.packets.weapons.SSGLoadingPacket;
import mod.azure.doom.util.registry.DoomItems;
import mod.azure.doom.util.registry.DoomSounds;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SuperShotgun
extends DoomBaseItem {
    public SuperShotgun() {
        super(new Item.Properties().m_41491_(DoomMod.DoomWeaponItemGroup).m_41487_(1).m_41503_(53));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new SSGRender();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return DoomTier.SHOTGUN.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerentity = (Player)entityLiving;
            if (stack.m_41773_() < stack.m_41776_() - 2) {
                if (playerentity.m_21205_().m_41720_() instanceof SuperShotgun) {
                    playerentity.m_36335_().m_41524_((Item)this, 24);
                    if (!worldIn.f_46443_) {
                        ShotgunShellEntity abstractarrowentity = this.createArrow(worldIn, stack, (LivingEntity)playerentity);
                        abstractarrowentity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() + 1.0f, 0.0f, 3.0f, 1.0f);
                        abstractarrowentity.m_20068_();
                        worldIn.m_7967_((Entity)abstractarrowentity);
                        ShotgunShellEntity abstractarrowentity1 = this.createArrow(worldIn, stack, (LivingEntity)playerentity);
                        abstractarrowentity1.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_() - 1.0f, 0.0f, 3.0f, 1.0f);
                        abstractarrowentity1.m_20068_();
                        worldIn.m_7967_((Entity)abstractarrowentity1);
                        stack.m_41622_(2, entityLiving, p -> p.m_21190_(entityLiving.m_7655_()));
                        worldIn.m_6263_((Player)null, playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_(), (SoundEvent)DoomSounds.SUPER_SHOTGUN_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!worldIn.f_46443_) {
                            int id = GeckoLibUtil.guaranteeIDForStack((ItemStack)stack, (ServerLevel)((ServerLevel)worldIn));
                            PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerentity);
                            GeckoLibNetwork.syncAnimation((PacketDistributor.PacketTarget)target, (ISyncable)this, (int)id, (int)0);
                        }
                    }
                    boolean isInsideWaterBlock = playerentity.f_19853_.m_46801_(playerentity.m_20183_());
                    this.spawnLightSource((Entity)entityLiving, isInsideWaterBlock);
                }
            } else {
                worldIn.m_6263_((Player)null, playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_(), (SoundEvent)DoomSounds.EMPTY.get(), SoundSource.PLAYERS, 1.0f, 1.5f);
                ((PlayerProperties)playerentity).setHasMeatHook(false);
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21206_();
        if (stack.m_41773_() < stack.m_41776_() - 2 && !world.m_5776_() && stack.m_41720_() instanceof SuperShotgun) {
            player.m_36335_().m_41524_((Item)this, 5);
            if (!((PlayerProperties)player).hasMeatHook()) {
                MeatHookEntity hookshot = new MeatHookEntity(world, (LivingEntity)player);
                hookshot.setProperties(stack, (Double)DoomConfig.SERVER.max_meathook_distance.get(), 10.0, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f);
                hookshot.m_20088_().m_135381_(MeatHookEntity.FORCED_YAW, (Object)Float.valueOf(player.m_146908_()));
                world.m_7967_((Entity)hookshot);
            }
            ((PlayerProperties)player).setHasMeatHook(!((PlayerProperties)player).hasMeatHook());
        }
        return super.m_7203_(world, player, hand);
    }

    public ShotgunShellEntity createArrow(Level worldIn, ItemStack stack, LivingEntity shooter) {
        float j = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        ShotgunShellEntity arrowentity = new ShotgunShellEntity(worldIn, shooter, ((Double)DoomConfig.SERVER.shotgun_damage.get()).floatValue() + j * 2.0f);
        return arrowentity;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.f_46443_ && ((Player)entityIn).m_21205_().m_41720_() instanceof SuperShotgun) {
            while (Keybindings.RELOAD.m_90859_() && isSelected) {
                DoomPacketHandler.SUPERSHOTGUN.sendToServer((Object)new SSGLoadingPacket(itemSlot));
            }
        }
        if (((Player)entityIn).m_21205_().m_41720_() instanceof SuperShotgun && isSelected && ((PlayerProperties)entityIn).hasMeatHook()) {
            ((PlayerProperties)entityIn).setHasMeatHook(false);
        }
    }

    public static void reload(Player user, InteractionHand hand) {
        if (user.m_21120_(hand).m_41720_() instanceof SuperShotgun) {
            while (!user.m_7500_() && user.m_21120_(hand).m_41773_() != 0 && user.m_150109_().m_18947_((Item)DoomItems.SHOTGUN_SHELLS.get()) > 0) {
                SuperShotgun.removeAmmo((Item)DoomItems.SHOTGUN_SHELLS.get(), user);
                user.m_21120_(hand).m_41622_(-4, (LivingEntity)user, s -> user.m_21190_(hand));
                user.m_21120_(hand).m_41754_(3);
            }
        }
    }
}

