/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.recipes;

import mod.azure.doom.client.gui.weapons.DoomGunInventory;
import mod.azure.doom.util.registry.DoomRecipes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class GunTableRecipe
implements Recipe<DoomGunInventory>,
Comparable<GunTableRecipe> {
    public static ResourceLocation RECIPE_TYPE_ID = new ResourceLocation("doom", "guns");
    public final ResourceLocation id;
    public final Pair<Ingredient, Integer>[] ingredients;
    public final ItemStack output;

    public GunTableRecipe(ResourceLocation id, Pair<Ingredient, Integer>[] ingredients, ItemStack output) {
        this.id = id;
        this.ingredients = ingredients;
        this.output = output;
    }

    public boolean matches(DoomGunInventory inv, Level world) {
        for (int i = 0; i < 5; ++i) {
            ItemStack slotStack = inv.m_8020_(i);
            Pair<Ingredient, Integer> pair = this.ingredients[i];
            Ingredient ingredient = (Ingredient)pair.getLeft();
            int count = (Integer)pair.getRight();
            if (slotStack.m_41613_() >= count && ingredient.test(slotStack)) continue;
            return false;
        }
        return true;
    }

    public Ingredient getIngredientForSlot(int index) {
        return (Ingredient)this.ingredients[index].getLeft();
    }

    public int countRequired(int index) {
        return (Integer)this.ingredients[index].getRight();
    }

    public ItemStack assemble(DoomGunInventory inv) {
        return this.m_8043_().m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DoomRecipes.GUN_TABLE_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @Override
    public int compareTo(GunTableRecipe o) {
        Item outputThis = this.m_8043_().m_41720_();
        Item outputOther = o.m_8043_().m_41720_();
        return ForgeRegistries.ITEMS.getKey((Object)outputThis).compareTo(ForgeRegistries.ITEMS.getKey((Object)outputOther));
    }

    public static class Type
    implements RecipeType<GunTableRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "gun_table";
    }
}

