/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.util.enums;

import java.util.function.Supplier;
import mod.azure.doom.config.DoomConfig;
import mod.azure.doom.util.registry.DoomItems;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum DoomArmorMaterial implements ArmorMaterial
{
    DOOM_ARMOR("doomweapon:doom_armor", 500, new int[]{(Integer)DoomConfig.SERVER.doom_armor_head_stat.get(), (Integer)DoomConfig.SERVER.doom_armor_leggings_stat.get(), (Integer)DoomConfig.SERVER.doom_armor_chestplate_stat.get(), (Integer)DoomConfig.SERVER.doom_armor_boots_stat.get()}, 40, SoundEvents.f_11675_, ((Integer)DoomConfig.SERVER.doom_armor_toughness.get()).floatValue(), ((Integer)DoomConfig.SERVER.doom_armor_knockbackResistance.get()).floatValue(), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DoomItems.ARGENT_ENERGY.get()}));

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairMaterial;

    private DoomArmorMaterial(String nameIn, int maxDamageFactorIn, int[] damageReductionAmountsIn, int enchantabilityIn, SoundEvent equipSoundIn, float toughnessIn, float knockbackResistance, Supplier<Ingredient> repairMaterialSupplier) {
        this.name = nameIn;
        this.maxDamageFactor = maxDamageFactorIn;
        this.damageReductionAmountArray = damageReductionAmountsIn;
        this.enchantability = enchantabilityIn;
        this.soundEvent = equipSoundIn;
        this.toughness = toughnessIn;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = new LazyLoadedValue(repairMaterialSupplier);
    }

    public int m_7366_(EquipmentSlot slotIn) {
        return MAX_DAMAGE_ARRAY[slotIn.m_20749_()] * this.maxDamageFactor;
    }

    public int m_7365_(EquipmentSlot slotIn) {
        return this.damageReductionAmountArray[slotIn.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairMaterial.m_13971_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{5, 8, 10, 5};
    }
}

