/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.Extencion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class CargadorExtensiones {
    public static void cargarExtensionesProcesoApp(File archivoListaMods) {
        if (archivoListaMods == null || !archivoListaMods.isFile()) {
            return;
        }
        try (BufferedReader lector = new BufferedReader(new FileReader(archivoListaMods));){
            String rutaMod;
            while ((rutaMod = lector.readLine()) != null) {
                String nombreArchivo;
                File archivoMod;
                if ((rutaMod = rutaMod.trim()).isEmpty() || !(archivoMod = new File(rutaMod)).isFile() || !(nombreArchivo = archivoMod.getName().toLowerCase()).endsWith(".jar") && !nombreArchivo.endsWith(".fpm") && !nombreArchivo.endsWith(".cdext")) continue;
                CargadorExtensiones.procesarModParaExtension(archivoMod, "app");
            }
        }
        catch (IOException e) {
            CrashDetectorLogger.log("Error leyendo lista de mods para procesoApp: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void cargarExtensionesProcesoMonitor(File archivoListaMods) {
        if (archivoListaMods == null || !archivoListaMods.isFile()) {
            return;
        }
        try (BufferedReader lector = new BufferedReader(new FileReader(archivoListaMods));){
            String rutaMod;
            while ((rutaMod = lector.readLine()) != null) {
                String nombreArchivo;
                File archivoMod;
                if ((rutaMod = rutaMod.trim()).isEmpty() || !(archivoMod = new File(rutaMod)).isFile() || !(nombreArchivo = archivoMod.getName().toLowerCase()).endsWith(".jar") && !nombreArchivo.endsWith(".fpm") && !nombreArchivo.endsWith(".cdext")) continue;
                CargadorExtensiones.procesarModParaExtension(archivoMod, "monitor");
            }
        }
        catch (IOException e) {
            CrashDetectorLogger.log("Error leyendo lista de mods para procesoMonitor: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void procesarModParaExtension(File archivoMod, String tipoProceso) {
        try (JarFile archivoJar = new JarFile(archivoMod);){
            Manifest manifiesto = archivoJar.getManifest();
            if (manifiesto == null) {
                return;
            }
            Attributes atributos = manifiesto.getMainAttributes();
            String nombreClase = atributos.getValue("ExtencionCrashDetector");
            if (nombreClase == null || nombreClase.trim().isEmpty()) {
                return;
            }
            URL urlJar = archivoMod.toURI().toURL();
            URLClassLoader cargadorClases = null;
            try {
                cargadorClases = new URLClassLoader(new URL[]{urlJar}, CargadorExtensiones.class.getClassLoader());
                Class<?> claseExt = Class.forName(nombreClase, true, cargadorClases);
                if (!Extencion.class.isAssignableFrom(claseExt)) {
                    return;
                }
                Extencion extension = (Extencion)claseExt.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if ("app".equals(tipoProceso)) {
                    extension.procesoDelApp();
                } else {
                    extension.procesoDeLaMonitorizacionDePID();
                }
            }
            catch (Exception e) {
                String mensaje = "Error cargando extensi\u00f3n para " + ("app".equals(tipoProceso) ? "aplicaci\u00f3n" : "monitoreo") + " en mod: " + archivoMod.getName();
                CrashDetectorLogger.log(mensaje);
                e.printStackTrace();
            }
            finally {
                if (cargadorClases != null) {
                    try {
                        cargadorClases.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            CrashDetectorLogger.log("Error procesando mod: " + archivoMod.getName());
            e.printStackTrace();
        }
    }
}

