/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.CrashDetectorFCMC;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.ProxyLog4j2;
import com.asbestosstar.crashdetector.ProxySysOutSysErr;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.divisor.HolaMundoConsolaDivisidor;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class CargadoresComun {
    public static void init(Path[] carpetas_de_mods, CDOrigin origin) {
        HashSet<Path> paths = new HashSet<Path>();
        for (Path path : carpetas_de_mods) {
            paths.add(path);
        }
        CargadoresComun.init(paths, origin);
    }

    public static void init(Collection<Path> carpetas_de_mods, CDOrigin origin) {
        Statics.carpetas_de_mods.addAll(carpetas_de_mods);
        if (!Statics.cargador) {
            Statics.cargador = true;
            ProxySysOutSysErr.init();
            if (ProxyLog4j2.log4j2existe()) {
                ProxyLog4j2.init();
                LogManager.getLogger(HolaMundoConsolaDivisidor.class).log(Level.ERROR, HolaMundoConsolaDivisidor.HOLA_MUNDO);
            }
            if (!origin.equals(CDOrigin.FEATURECREEP)) {
                Statics.carpetas_de_mods.addAll(CrashDetectorFCMC.obtenerPathsDeMods());
            }
            MonitorDePID.main(new String[0]);
        }
    }

    public static class CDOrigin {
        public static CDOrigin FEATURECREEP = new CDOrigin();
        public static CDOrigin FABRICMC = new CDOrigin();
        public static CDOrigin MODLAUNCHER = new CDOrigin();
        public static CDOrigin FANCYMODLOADER = new CDOrigin();
        public static CDOrigin MANGOMODLOADER = new CDOrigin();
    }
}

