/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.Statics;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class Config {
    public static final String VALOR_POR_DEFECTO_SITO_DE_INFORMES = "https://asbestosstar.egoism.jp/crash_detector/crash_detector_servidor.rb";
    private static final String VALOR_POR_DEFECTO_COLOR_FONDO = "282828";
    private static final String VALOR_POR_DEFECTO_COLOR_TEXTO = "FFFFFF";
    private static final String VALOR_POR_DEFECTO_COLOR_BOTON = "46468C";
    private static final String VALOR_POR_DEFECTO_COLOR_CAJA_TEXTO = "3C3C3C";
    private static final String VALOR_POR_DEFECTO_COLOR_ENLACE = "56CCF2";
    private static final String VALOR_POR_DEFECTO_COLOR_DE_TITULOS_DE_CONSOLAS = "56CCF2";
    private static final String VALOR_POR_DEFECTO_COLOR_ERROR = "FF6347";
    private static final String VALOR_POR_DEFECTO_COLOR_ADVERTENCIA = "FFD700";
    private static final String VALOR_POR_DEFECTO_COLOR_INFO = "FFFFFF";
    private static final String VALOR_POR_DEFECTO_COLOR_TITULO = "56CCF2";
    public static final String HMCL_CARPETA = "";
    public static final String VALOR_POR_DEFECTO_API_DE_REGISTROS_SELECCIONADA = "SecureLogger";
    public static final String VALOR_POR_DEFECTO_SITIO_DE_REGISTROS_SELECCIONADO = "https://securelogger.net/save/log?";
    private static final boolean PROXY_SYSOUT_SYSERR = true;
    public static final String NOMBRE_CD = "CrashDetector";
    private static final String RUTA_ARCHIVO_CONFIG = Statics.carpeta.resolve("crashdetector_config.properties").toString();
    public static File archivoConfig = new File(RUTA_ARCHIVO_CONFIG);
    public Properties propiedadesConfig = new Properties();
    private static Config instancia;

    private Config() {
        if (archivoConfig.exists()) {
            try (FileReader lector = new FileReader(archivoConfig);){
                this.propiedadesConfig.load(lector);
            }
            catch (IOException e) {
                System.err.println("Error al leer el archivo de configuraci\u00f3n: " + e.getMessage());
            }
        } else {
            this.propiedadesConfig.setProperty("sito_de_informes", VALOR_POR_DEFECTO_SITO_DE_INFORMES);
            this.propiedadesConfig.setProperty("color_fondo", VALOR_POR_DEFECTO_COLOR_FONDO);
            this.propiedadesConfig.setProperty("color_texto", "FFFFFF");
            this.propiedadesConfig.setProperty("color_boton", VALOR_POR_DEFECTO_COLOR_BOTON);
            this.propiedadesConfig.setProperty("color_caja_texto", VALOR_POR_DEFECTO_COLOR_CAJA_TEXTO);
            this.propiedadesConfig.setProperty("color_enlace", "56CCF2");
            this.propiedadesConfig.setProperty("color_de_titulos_de_consolas", "56CCF2");
            this.propiedadesConfig.setProperty("color_error", VALOR_POR_DEFECTO_COLOR_ERROR);
            this.propiedadesConfig.setProperty("color_advertencia", VALOR_POR_DEFECTO_COLOR_ADVERTENCIA);
            this.propiedadesConfig.setProperty("color_info", "FFFFFF");
            this.propiedadesConfig.setProperty("color_titulo", "56CCF2");
            this.propiedadesConfig.setProperty("hmcl_carpeta", HMCL_CARPETA);
            this.propiedadesConfig.setProperty("api_de_registros_seleccionada", VALOR_POR_DEFECTO_API_DE_REGISTROS_SELECCIONADA);
            this.propiedadesConfig.setProperty("sitio_de_registros_seleccionado", VALOR_POR_DEFECTO_SITIO_DE_REGISTROS_SELECCIONADO);
            this.propiedadesConfig.setProperty("proxy_sysout_syserr", String.valueOf(true));
            this.propiedadesConfig.setProperty("nombre_cd", NOMBRE_CD);
            this.guardar();
        }
    }

    public static synchronized Config obtenerInstancia() {
        if (instancia == null) {
            instancia = new Config();
        }
        return instancia;
    }

    public void guardar() {
        archivoConfig.getParentFile().mkdirs();
        try (FileWriter escritor = new FileWriter(archivoConfig);){
            this.propiedadesConfig.store(escritor, "Configuraci\u00f3n de CrashDetectorMC");
        }
        catch (IOException e) {
            System.err.println("Error al crear el archivo de configuraci\u00f3n: " + e.getMessage());
        }
    }

    public String obtenerSitoDeInformes() {
        return this.propiedadesConfig.getProperty("sito_de_informes", VALOR_POR_DEFECTO_SITO_DE_INFORMES);
    }

    public String obtenerColorFondo() {
        return this.propiedadesConfig.getProperty("color_fondo", VALOR_POR_DEFECTO_COLOR_FONDO);
    }

    public String obtenerColorTexto() {
        return this.propiedadesConfig.getProperty("color_texto", "FFFFFF");
    }

    public String obtenerColorBoton() {
        return this.propiedadesConfig.getProperty("color_boton", VALOR_POR_DEFECTO_COLOR_BOTON);
    }

    public String obtenerColorCajaTexto() {
        return this.propiedadesConfig.getProperty("color_caja_texto", VALOR_POR_DEFECTO_COLOR_CAJA_TEXTO);
    }

    public String obtenerColorEnlace() {
        return this.propiedadesConfig.getProperty("color_enlace", "56CCF2");
    }

    public String obtenerColorDeTitulosDeConsolas() {
        return this.propiedadesConfig.getProperty("color_de_titulos_de_consolas", "56CCF2");
    }

    public String obtenerColorError() {
        return this.propiedadesConfig.getProperty("color_error", VALOR_POR_DEFECTO_COLOR_ERROR);
    }

    public String obtenerColorAdvertencia() {
        return this.propiedadesConfig.getProperty("color_advertencia", VALOR_POR_DEFECTO_COLOR_ADVERTENCIA);
    }

    public String obtenerColorInfo() {
        return this.propiedadesConfig.getProperty("color_info", "FFFFFF");
    }

    public String obtenerColorTitulo() {
        return this.propiedadesConfig.getProperty("color_titulo", "56CCF2");
    }

    public String obtenerApiSeleccionada() {
        return this.propiedadesConfig.getProperty("api_de_registros_seleccionada", VALOR_POR_DEFECTO_API_DE_REGISTROS_SELECCIONADA);
    }

    public String obtenerSitioDeRegistrosSeleccionado() {
        return this.propiedadesConfig.getProperty("sitio_de_registros_seleccionado", VALOR_POR_DEFECTO_SITIO_DE_REGISTROS_SELECCIONADO);
    }

    public void guardarColorFondo(String valor) {
        this.propiedadesConfig.setProperty("color_fondo", valor);
        this.guardar();
    }

    public void guardarColorTexto(String valor) {
        this.propiedadesConfig.setProperty("color_texto", valor);
        this.guardar();
    }

    public void guardarColorBoton(String valor) {
        this.propiedadesConfig.setProperty("color_boton", valor);
        this.guardar();
    }

    public void guardarColorCajaTexto(String valor) {
        this.propiedadesConfig.setProperty("color_caja_texto", valor);
        this.guardar();
    }

    public void guardarColorEnlace(String valor) {
        this.propiedadesConfig.setProperty("color_enlace", valor);
        this.guardar();
    }

    public void guardarColorDeTitulosDeConsolas(String valor) {
        this.propiedadesConfig.setProperty("color_de_titulos_de_consolas", valor);
        this.guardar();
    }

    public void guardarColorError(String valor) {
        this.propiedadesConfig.setProperty("color_error", valor);
        this.guardar();
    }

    public void guardarColorAdvertencia(String valor) {
        this.propiedadesConfig.setProperty("color_advertencia", valor);
        this.guardar();
    }

    public void guardarColorInfo(String valor) {
        this.propiedadesConfig.setProperty("color_info", valor);
        this.guardar();
    }

    public void guardarColorTitulo(String valor) {
        this.propiedadesConfig.setProperty("color_titulo", valor);
        this.guardar();
    }

    public void guardarApiSeleccionada(String valor) {
        this.propiedadesConfig.setProperty("api_de_registros_seleccionada", valor);
        this.guardar();
    }

    public void guardarSitioRegistrosSeleccionado(String valor) {
        this.propiedadesConfig.setProperty("sitio_de_registros_seleccionado", valor);
        this.guardar();
    }

    public void guardarSitioDeInformes(String valor) {
        this.propiedadesConfig.setProperty("sito_de_informes", valor);
        this.guardar();
    }

    public static Color convertirAColor(String color) throws IllegalArgumentException, NumberFormatException {
        if (color == null) {
            throw new IllegalArgumentException("El valor del color no puede ser nulo.");
        }
        String hex = color.trim();
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() != 6) {
            throw new IllegalArgumentException("Formato de color inv\u00e1lido (debe ser RRGGBB): " + color);
        }
        if (!hex.matches("^[0-9A-Fa-f]{6}$")) {
            throw new IllegalArgumentException("El color contiene caracteres no v\u00e1lidos: " + color);
        }
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return new Color(r, g, b);
    }

    public static String colorAHexHtml(Color c) {
        return Integer.toHexString(c.getRGB()).substring(2).toUpperCase();
    }

    public String obtenerCarpetaHMCL() {
        return this.propiedadesConfig.getProperty("hmcl_carpeta", HMCL_CARPETA);
    }

    public String guardarCarpetaHMCL(String string) {
        return this.propiedadesConfig.getProperty("hmcl_carpeta", string);
    }

    public boolean obtenerProxySysOutSysErr() {
        return Boolean.parseBoolean(this.propiedadesConfig.getProperty("proxy_sysout_syserr", String.valueOf(true)));
    }

    public void guardarProxySysOutSysErr(boolean valor) {
        this.propiedadesConfig.setProperty("proxy_sysout_syserr", String.valueOf(valor));
    }

    public void guardarNombreCD(String valor) {
        this.propiedadesConfig.setProperty("nombre_cd", valor);
        this.guardar();
    }

    public String obtenerNombreCD() {
        return this.propiedadesConfig.getProperty("nombre_cd", NOMBRE_CD);
    }
}

