/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class ConfigMundial {
    private static final boolean VALOR_POR_DEFECTO_TOKEN_DE_ACCESO = false;
    private static final boolean VALOR_POR_DEFECTO_ANONIMIZAR_REGISTROS = true;
    private static final boolean VALOR_POR_DEFECTO_CONSENTIMIENTO_LFPDPPP = false;
    private static final boolean VALOR_POR_DEFECTO_CONSOLA_DESARROLLO = false;
    private static final File ARCHIVO_CONFIG_MUNIDIAL = new File(System.getProperty("user.home"), "crash_detector/config_munidial.properties");
    private static ConfigMundial instancia;
    private final Properties propiedades = new Properties();

    private ConfigMundial() {
        if (ARCHIVO_CONFIG_MUNIDIAL.exists()) {
            try (FileReader lector = new FileReader(ARCHIVO_CONFIG_MUNIDIAL);){
                this.propiedades.load(lector);
            }
            catch (IOException e) {
                System.err.println("Error al leer la configuraci\u00f3n mundial: " + e.getMessage());
            }
        } else {
            this.propiedades.setProperty("habilitar_token_de_acceso_en_la_entrega_del_MonitorDePID", String.valueOf(false));
            this.propiedades.setProperty("anonimizar_registros", String.valueOf(true));
            this.propiedades.setProperty("consentimiento_lfpdppp", String.valueOf(false));
            this.propiedades.setProperty("consola_desarrollo", String.valueOf(false));
            this.guardar();
        }
    }

    public static synchronized ConfigMundial obtenerInstancia() {
        if (instancia == null) {
            instancia = new ConfigMundial();
        }
        return instancia;
    }

    public void guardar() {
        ARCHIVO_CONFIG_MUNIDIAL.getParentFile().mkdirs();
        try (FileWriter escritor = new FileWriter(ARCHIVO_CONFIG_MUNIDIAL);){
            this.propiedades.store(escritor, "Configuraci\u00f3n munidial de CrashDetector");
        }
        catch (IOException e) {
            System.err.println("Error al guardar la configuraci\u00f3n munidial: " + e.getMessage());
        }
    }

    public boolean obtenerHabilitarTokenDeAccesoEnLaEntregaDelMonitorDePID() {
        return Boolean.parseBoolean(this.propiedades.getProperty("habilitar_token_de_acceso_en_la_entrega_del_MonitorDePID", String.valueOf(false)));
    }

    public void guardarHabilitarTokenDeAccesoEnLaEntregaDelMonitorDePID(boolean valor) {
        this.propiedades.setProperty("habilitar_token_de_acceso_en_la_entrega_del_MonitorDePID", String.valueOf(valor));
        this.guardar();
    }

    public String obtenerIdioma() {
        String idioma = this.propiedades.getProperty("idioma");
        return idioma != null ? idioma.trim().toLowerCase() : null;
    }

    public void guardarIdioma(String codigo) {
        if (codigo == null) {
            this.propiedades.remove("idioma");
        } else {
            this.propiedades.setProperty("idioma", codigo.toLowerCase());
        }
        this.guardar();
    }

    public void borrarIdioma() {
        this.propiedades.remove("idioma");
        this.guardar();
    }

    public boolean esAnonimizarRegistros() {
        return Boolean.parseBoolean(this.propiedades.getProperty("anonimizar_registros", String.valueOf(true)));
    }

    public void guardarAnonimizarRegistros(boolean valor) {
        this.propiedades.setProperty("anonimizar_registros", String.valueOf(valor));
        this.guardar();
    }

    public boolean obtenerConsentimientoLFPDPPP() {
        return Boolean.parseBoolean(this.propiedades.getProperty("consentimiento_lfpdppp", String.valueOf(false)));
    }

    public void guardarConsentimientoLFPDPPP(boolean valor) {
        this.propiedades.setProperty("consentimiento_lfpdppp", String.valueOf(valor));
        this.guardar();
    }

    public boolean obtenerConsolaDesarrollo() {
        return Boolean.parseBoolean(this.propiedades.getProperty("consola_desarrollo", String.valueOf(false)));
    }

    public void guardarConsolaDesarrollo(boolean valor) {
        this.propiedades.setProperty("consola_desarrollo", String.valueOf(valor));
        this.guardar();
    }
}

