/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.ConfigMundial;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.anon.AnonimizadorDeRuta;
import com.asbestosstar.crashdetector.anon.AnonimizadordeRegistros;
import com.asbestosstar.crashdetector.api_sito_registro.APIdeSitioDeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.CrashDetectorPasteAPI;
import com.asbestosstar.crashdetector.api_sito_registro.DemasiadoGrande;
import com.asbestosstar.crashdetector.api_sito_registro.ErrorConPublicar;
import com.asbestosstar.crashdetector.api_sito_registro.LimteDeTasa;
import com.asbestosstar.crashdetector.api_sito_registro.MCLogsAPI;
import com.asbestosstar.crashdetector.api_sito_registro.NoAPIdeRegistro;
import com.asbestosstar.crashdetector.api_sito_registro.PastesDevAPI;
import com.asbestosstar.crashdetector.api_sito_registro.SecureLoggerAPI;
import com.asbestosstar.crashdetector.api_sito_registro.StikkedAPI;
import com.asbestosstar.crashdetector.divisor.DivisorDeArchivos;
import com.asbestosstar.crashdetector.divisor.HolaMundoConsolaDivisidor;
import com.asbestosstar.crashdetector.divisor.TLauncherConsolaDivisor;
import com.asbestosstar.crashdetector.gui.tipos.lectador.LectadorDeConsolasGUI;
import com.asbestosstar.crashdetector.gui.tipos.no_registro_lanzador.NoRegistroDeLauncherVShojo;
import com.asbestosstar.crashdetector.limpiador.LimpiadorDeRegistro;
import com.asbestosstar.crashdetector.limpiador.LimpiadorNingun;
import com.asbestosstar.crashdetector.limpiador.LimpiadorRegistroDeLauncherVainilla;
import com.asbestosstar.crashdetector.limpiador.LimpiadorRegistroLatestLog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Consola {
    public String contenido;
    public Path archivo;
    public List<String> enlaces = new ArrayList<String>();
    public int linea_original;
    public boolean nueva = false;
    public String contenido_verificar;
    public VerificacionDeStackTrace verificacion_de_stacktrace;
    public List<LectadorDeConsolasGUI.ErrorDeLectador> errores_de_lectadores = new ArrayList<LectadorDeConsolasGUI.ErrorDeLectador>();
    public LimpiadorDeRegistro limpiador;
    public static ArrayList<String> archivos_en_lista = new ArrayList();
    public static List<String> tipos_de_registros_de_launcher = new ArrayList<String>();
    public static SecureLoggerAPI secure_logger_api = new SecureLoggerAPI();
    public static List<DivisorDeArchivos> divisores = new ArrayList<DivisorDeArchivos>();
    public static List<LimpiadorDeRegistro> limpiadores = new ArrayList<LimpiadorDeRegistro>();
    public static ArrayList<File> archivos_para_mapa = new ArrayList();
    public static ArrayList<String> inutiles_archivo_strs = new ArrayList();
    private static final boolean ES_LINUX_O_BSD;

    public Consola(Path archivo) throws IOException {
        String clave;
        this.archivo = archivo;
        this.linea_original = 0;
        try {
            clave = archivo.toFile().getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            clave = archivo.toAbsolutePath().normalize().toString().replace('\\', '/');
        }
        if (!archivos_en_lista.contains(clave)) {
            archivos_en_lista.add(clave);
        }
        for (DivisorDeArchivos div : divisores) {
            int ln;
            String contento_existe;
            if (!div.predicado(archivo, contento_existe = MonitorDePID.leer_archivo(archivo)) || (ln = div.obtenerLineaOriginal(contento_existe)) <= 0) continue;
            this.linea_original = ln;
            break;
        }
    }

    private static void inutilesArchivoStrsPredetermindados() {
        inutiles_archivo_strs.add("kubejs");
        inutiles_archivo_strs.add("crafttweaker");
        inutiles_archivo_strs.add("crash_assistant");
        inutiles_archivo_strs.add("telemetry");
        inutiles_archivo_strs.add("launcher");
        inutiles_archivo_strs.add("latest.log");
        inutiles_archivo_strs.add("debug.log");
    }

    public static void escribirMapa(Instant tiempo) {
        File mapa;
        File carpetaDestino = Statics.carpeta_como_archivo;
        if (!carpetaDestino.exists()) {
            carpetaDestino.mkdirs();
        }
        if ((mapa = new File(carpetaDestino, "mapa_de_registros")).exists()) {
            mapa.delete();
        }
        String nl = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        HashSet<String> vistos = new HashSet<String>();
        for (File f : archivos_para_mapa) {
            if (f == null) continue;
            try {
                String rutaCanonica = f.getCanonicalPath();
                if (vistos.contains(rutaCanonica)) continue;
                vistos.add(rutaCanonica);
                if (!f.exists() || !f.isFile()) continue;
                int linea = 0;
                boolean huboDivisor = false;
                for (DivisorDeArchivos div : divisores) {
                    try {
                        String contenido = MonitorDePID.leer_archivo(f.toPath());
                        if (!div.predicado(f.toPath(), contenido)) continue;
                        huboDivisor = true;
                        int ln = div.obtenerLineaOriginal(contenido);
                        if (ln <= 0) continue;
                        linea = ln;
                        break;
                    }
                    catch (Exception ex) {
                        CrashDetectorLogger.logException(ex);
                    }
                }
                if (!huboDivisor || linea <= 0) {
                    linea = Consola.contarLineas(f.toPath());
                }
                if (linea <= 0) continue;
                sb.append(rutaCanonica).append('\t').append(tiempo.toEpochMilli()).append('\t').append(linea).append(nl);
            }
            catch (IOException e) {
                CrashDetectorLogger.logException(e);
            }
        }
        try (BufferedWriter w = new BufferedWriter(new FileWriter(mapa));){
            w.write(sb.toString());
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
        }
    }

    private static int contarLineas(Path ruta) {
        int total = 0;
        try (BufferedReader br = Files.newBufferedReader(ruta);){
            while (br.readLine() != null) {
                ++total;
            }
        }
        catch (IOException e) {
            CrashDetectorLogger.logException(e);
        }
        return total;
    }

    public static List<Consola> leerMapaConsolasComoLista() {
        ArrayList<Consola> lista;
        block17: {
            lista = new ArrayList<Consola>();
            File carpeta = Statics.carpeta_como_archivo;
            File mapa = new File(carpeta, "mapa_de_registros");
            if (!mapa.exists() || !mapa.isFile()) {
                return lista;
            }
            HashSet<String> vistas = new HashSet<String>();
            try {
                BufferedReader br = new BufferedReader(new FileReader(mapa));
                block13: while (true) {
                    String linea;
                    while ((linea = br.readLine()) != null) {
                        File f;
                        String[] partes;
                        String l = linea.trim();
                        if (l.isEmpty() || (partes = l.split("\t")).length < 3) continue;
                        String ruta = partes[0].trim();
                        long tiempoGuardado = 0L;
                        int lineaGuardada = 0;
                        try {
                            tiempoGuardado = Long.parseLong(partes[1].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            lineaGuardada = Integer.parseInt(partes[2].trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (!(f = new File(ruta)).exists() || !f.isFile()) continue;
                        try {
                            File fCanonico = f.getCanonicalFile();
                            String key = fCanonico.getAbsolutePath();
                            if (vistas.contains(key)) continue;
                            vistas.add(key);
                            long modAhora = fCanonico.lastModified();
                            if (modAhora <= tiempoGuardado) continue block13;
                            Consola c = new Consola(fCanonico.toPath());
                            if (lineaGuardada > 0) {
                                c.linea_original = lineaGuardada;
                            }
                            lista.add(c);
                            continue block13;
                        }
                        catch (IOException e) {
                            CrashDetectorLogger.logException(e);
                        }
                    }
                    break block17;
                    {
                        continue block13;
                        break;
                    }
                    break;
                }
                finally {
                    br.close();
                }
            }
            catch (IOException e) {
                CrashDetectorLogger.logException(e);
            }
        }
        return lista;
    }

    public void finalizarContenido(Instant tiempo, boolean ignorar_necesita_estar_despues_de_tiempo) {
        try {
            Instant epoc = Instant.ofEpochMilli(this.archivo.toFile().lastModified());
            if (epoc.isAfter(tiempo) || ignorar_necesita_estar_despues_de_tiempo || this.nueva) {
                int inicio;
                this.nueva = true;
                this.contenido = MonitorDePID.leer_archivo(this.archivo);
                String[] lineas = this.contenido.split("\\r?\\n", -1);
                StringBuilder para_verificar = new StringBuilder(this.contenido.length() + 64);
                for (int i = inicio = Math.max(0, this.linea_original); i < lineas.length; ++i) {
                    para_verificar.append(lineas[i]);
                    if (i >= lineas.length - 1) continue;
                    para_verificar.append('\n');
                }
                boolean limpiado = false;
                for (LimpiadorDeRegistro limp : limpiadores) {
                    if (!limp.predicado(this.archivo)) continue;
                    this.contenido_verificar = limp.limpiarConsola(para_verificar.toString());
                    this.limpiador = limp;
                    limpiado = true;
                }
                if (!limpiado) {
                    this.limpiador = new LimpiadorNingun();
                    this.contenido_verificar = para_verificar.toString();
                }
            } else {
                this.nueva = false;
                this.contenido = "";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void finalizarContenidoInyectado(String contento) {
        this.nueva = true;
        this.contenido = contento;
        boolean limpiado = false;
        for (LimpiadorDeRegistro limp : limpiadores) {
            if (!limp.predicado(this.archivo)) continue;
            this.contenido_verificar = limp.limpiarConsola(contento);
            limpiado = true;
            this.limpiador = limp;
        }
        if (!limpiado) {
            this.limpiador = new LimpiadorNingun();
            this.contenido_verificar = contento.toString();
        }
    }

    public static List<Consola> obtenerConsolas() {
        ArrayList<Consola> resultado = new ArrayList<Consola>();
        for (File archivo : Consola.obtenerArchivosDeConsolas()) {
            String k;
            if (archivo == null || !archivo.exists() || !archivo.isFile() || archivos_en_lista.contains(k = Consola.clave(archivo))) continue;
            try {
                Consola c = new Consola(archivo.toPath());
                resultado.add(c);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultado;
    }

    private static String clave(Path p) {
        try {
            return p.toFile().getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            return p.toAbsolutePath().normalize().toString().replace('\\', '/');
        }
    }

    private static String clave(File f) {
        try {
            return f.getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            return f.getAbsolutePath().replace('\\', '/');
        }
    }

    public static List<File> obtenerArchivosDeConsolas() {
        ArrayList<File> resultado = new ArrayList<File>();
        Consola.agregarDirectorio(resultado, new File("logs/"));
        Consola.agregarDirectorio(resultado, new File("crash-reports/"));
        Consola.agregarDirectorio(resultado, new File("var/logs/"));
        resultado.add(NoRegistroDeLauncherVShojo.cd_launcherlog);
        resultado.add(new File("hs_err_pid" + String.valueOf(MonitorDePID.pid) + ".log"));
        return resultado;
    }

    /*
     * Unable to fully structure code
     */
    public static void agregarDirectorio(List<File> resultado, File directorio) {
        if (!directorio.exists() || !directorio.isDirectory()) {
            return;
        }
        inutilesLower = Consola.inutiles_archivo_strs == null ? Collections.emptySet() : Consola.inutiles_archivo_strs.stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Ljava/lang/String;)Z)()).map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toLowerCase(), (Ljava/lang/String;)Ljava/lang/String;)()).collect(Collectors.toSet());
        archivos = directorio.listFiles();
        if (archivos == null) {
            return;
        }
        for (File archivo : archivos) {
            if (archivo == null || (nombre = archivo.getName()) == null) continue;
            lowerNombre = nombre.toLowerCase();
            if (archivo.isDirectory()) {
                if (inutilesLower.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.CharSequence ), (Ljava/lang/String;)Z)((String)lowerNombre))) continue;
                Consola.agregarDirectorio(resultado, archivo);
                continue;
            }
            if (!archivo.isFile()) continue;
            v0 = esComprimido = lowerNombre.endsWith(".gz") != false || lowerNombre.endsWith(".xz") != false;
            if (inutilesLower.isEmpty()) ** GOTO lbl-1000
            if (inutilesLower.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.CharSequence ), (Ljava/lang/String;)Z)((String)lowerNombre))) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = contieneInutil = false;
            }
            if (esComprimido || contieneInutil) continue;
            resultado.add(archivo);
        }
    }

    public static List<Consola> reorganizar(List<Consola> consolas) {
        ArrayList<Consola> crashReports = new ArrayList<Consola>();
        ArrayList<Consola> otros = new ArrayList<Consola>();
        ArrayList<Consola> latestYDebug = new ArrayList<Consola>();
        for (Consola consola : consolas) {
            String nombreArchivo = consola.archivo.toString().toLowerCase();
            if (nombreArchivo.contains("crash-report")) {
                crashReports.add(consola);
                continue;
            }
            if (nombreArchivo.endsWith("latest.log") || nombreArchivo.endsWith("debug.log")) {
                latestYDebug.add(consola);
                continue;
            }
            otros.add(consola);
        }
        ArrayList<Consola> priorizadas = new ArrayList<Consola>(crashReports.size() + otros.size() + latestYDebug.size());
        priorizadas.addAll(crashReports);
        priorizadas.addAll(latestYDebug);
        priorizadas.addAll(otros);
        return priorizadas;
    }

    public static boolean tiene_registro_de_launcher(List<Consola> cons) {
        for (Consola con : cons) {
            File arch = con.archivo.toFile();
            String nombre = arch.getName();
            if (nombre.toLowerCase().contains("launcher") && !nombre.contains("PrismLauncher-0")) {
                return true;
            }
            if (nombre.toLowerCase().contains(".hmcl") && nombre.toLowerCase().contains("logs")) {
                return true;
            }
            if (nombre.toLowerCase().contains("klauncher") && nombre.toLowerCase().contains("logs")) {
                return true;
            }
            for (String regdelauncher : tipos_de_registros_de_launcher) {
                if (!nombre.equals(regdelauncher)) continue;
                return true;
            }
        }
        return false;
    }

    public String obtenerRutaParaPublicar() {
        boolean anon = ConfigMundial.obtenerInstancia().esAnonimizarRegistros();
        if (anon) {
            return AnonimizadorDeRuta.anonimizarNombreDeUsuario(this.archivo.toString());
        }
        return this.archivo.toString();
    }

    public String obtainerContenidoParaPublicar() {
        boolean anon = ConfigMundial.obtenerInstancia().esAnonimizarRegistros();
        if (anon) {
            return AnonimizadordeRegistros.anonimizar(this.contenido_verificar);
        }
        return this.contenido_verificar;
    }

    public String obtenerMensajeUltimaTrace() {
        List<VerificacionDeStackTrace.TraceInfo> tracesInfo = VerificacionDeStackTrace.obtenerTracesConLinea(this.contenido_verificar);
        if (!tracesInfo.isEmpty()) {
            String[] lineas;
            VerificacionDeStackTrace.TraceInfo ultimaTraceInfo = tracesInfo.get(tracesInfo.size() - 1);
            String ultimaTrace = ultimaTraceInfo.trace;
            for (String linea : lineas = ultimaTrace.split(VerificacionDeStackTrace.nl)) {
                String trimLinea = linea.trim();
                if (trimLinea.isEmpty() || trimLinea.startsWith("at ") || trimLinea.contains("Caused by") || trimLinea.contains("Suppressed")) continue;
                return trimLinea;
            }
        }
        return "";
    }

    public String obtainerMensajeFatalUltimaTrace() {
        List<VerificacionDeStackTrace.TraceInfo> tracesInfo = VerificacionDeStackTrace.obtenerTracesFatalConLinea(this.contenido_verificar);
        if (!tracesInfo.isEmpty()) {
            String[] lineas;
            VerificacionDeStackTrace.TraceInfo ultimaTraceInfo = tracesInfo.get(tracesInfo.size() - 1);
            String ultimaTrace = ultimaTraceInfo.trace;
            for (String linea : lineas = ultimaTrace.split(VerificacionDeStackTrace.nl)) {
                String trimLinea = linea.trim();
                if (trimLinea.isEmpty() || trimLinea.startsWith("at ") || trimLinea.contains("Caused by") || trimLinea.contains("Suppressed")) continue;
                return trimLinea;
            }
        }
        return "";
    }

    public String agregarErrorALectador(int numero_de_linea, Verificaciones verificacion) {
        LectadorDeConsolasGUI.ErrorDeLectador letc = new LectadorDeConsolasGUI.ErrorDeLectador(this, numero_de_linea, verificacion);
        this.errores_de_lectadores.add(letc);
        String url = letc.toString();
        String texto = MonitorDePID.idioma.verEnConsola();
        String color = Config.obtenerInstancia().obtenerColorEnlace();
        String enlaceHtml = "<a href=\"" + url + "\" style=\"color:" + color + ";\">" + texto + "</a>";
        return enlaceHtml;
    }

    public LimpiadorDeRegistro obtenerLimpiador() {
        return this.limpiador;
    }

    public List<String> obtainerEnlaces() throws DemasiadoGrande, ErrorConPublicar, NoAPIdeRegistro, LimteDeTasa {
        if (this.enlaces.isEmpty()) {
            APIdeSitioDeRegistro api = APIdeSitioDeRegistro.obtenerAPIdeConfig();
            List<String> ret = api.publicarRegistroEnPartes(this);
            this.enlaces.addAll(ret);
        }
        return this.enlaces;
    }

    @Deprecated
    public String obtainerEnlance() throws DemasiadoGrande, ErrorConPublicar, NoAPIdeRegistro, LimteDeTasa {
        List<String> ls = this.obtainerEnlaces();
        return ls != null && !ls.isEmpty() ? ls.get(0) : null;
    }

    static {
        APIdeSitioDeRegistro.APIS.add(secure_logger_api);
        APIdeSitioDeRegistro.APIS.add(new StikkedAPI());
        APIdeSitioDeRegistro.APIS.add(new MCLogsAPI());
        APIdeSitioDeRegistro.APIS.add(new PastesDevAPI());
        APIdeSitioDeRegistro.APIS.add(new CrashDetectorPasteAPI());
        divisores.add(new TLauncherConsolaDivisor());
        divisores.add(new HolaMundoConsolaDivisidor());
        tipos_de_registros_de_launcher.add("../../logs/ftb-app-electron.log");
        tipos_de_registros_de_launcher.add(NoRegistroDeLauncherVShojo.cd_launcherlog.getName());
        limpiadores.add(new LimpiadorRegistroDeLauncherVainilla());
        limpiadores.add(new LimpiadorRegistroLatestLog());
        archivos_para_mapa.addAll(Consola.obtenerArchivosDeConsolas());
        Consola.inutilesArchivoStrsPredetermindados();
        ES_LINUX_O_BSD = System.getProperty("os.name").toLowerCase().contains("linux") || System.getProperty("os.name").toLowerCase().contains("bsd");
    }
}

